/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.security;

import io.smallrye.openapi.api.models.security.SecuritySchemeImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.ReferenceType;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.jandex.AnnotationInstance;

public class SecuritySchemeIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<SecurityScheme, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_NAME = "name";
    private static final String PROP_BEARER_FORMAT = "bearerFormat";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_FLOWS = "flows";
    private static final String PROP_IN = "in";
    private static final String PROP_SCHEME = "scheme";
    private static final String PROP_OPEN_ID_CONNECT_URL = "openIdConnectUrl";
    private static final String PROP_TYPE = "type";
    private static final String PROP_API_KEY_NAME = "apiKeyName";
    private static final String PROP_SECURITY_SCHEME_NAME = "securitySchemeName";

    public SecuritySchemeIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.SECURITY_SCHEME, Names.create(SecurityScheme.class));
    }

    @Override
    protected Optional<String> getName(AnnotationInstance annotation) {
        return this.getName(annotation, PROP_SECURITY_SCHEME_NAME);
    }

    @Override
    public SecurityScheme read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@SecurityScheme");
        SecuritySchemeImpl securityScheme = new SecuritySchemeImpl();
        securityScheme.setType(this.enumValue(annotation, PROP_TYPE, SecurityScheme.Type.class));
        securityScheme.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        securityScheme.setName((String)this.value(annotation, PROP_API_KEY_NAME));
        securityScheme.setIn(this.enumValue(annotation, PROP_IN, SecurityScheme.In.class));
        securityScheme.setScheme((String)this.value(annotation, PROP_SCHEME));
        securityScheme.setBearerFormat((String)this.value(annotation, PROP_BEARER_FORMAT));
        securityScheme.setFlows((OAuthFlows)this.oauthFlowsIO().read(annotation.value(PROP_FLOWS)));
        securityScheme.setOpenIdConnectUrl((String)this.value(annotation, PROP_OPEN_ID_CONNECT_URL));
        securityScheme.setRef(ReferenceType.SECURITY_SCHEME.refValue(annotation));
        securityScheme.setExtensions(this.extensionIO().readExtensible(annotation));
        return securityScheme;
    }

    @Override
    public SecurityScheme readObject(O node) {
        SecuritySchemeImpl model = new SecuritySchemeImpl();
        model.setRef(this.readReference(node));
        model.setType(this.enumValue(this.jsonIO().getValue(node, PROP_TYPE), SecurityScheme.Type.class));
        model.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        model.setName(this.jsonIO().getString(node, PROP_NAME));
        model.setIn(this.enumValue(this.jsonIO().getValue(node, PROP_IN), SecurityScheme.In.class));
        model.setScheme(this.jsonIO().getString(node, PROP_SCHEME));
        model.setBearerFormat(this.jsonIO().getString(node, PROP_BEARER_FORMAT));
        model.setFlows((OAuthFlows)this.oauthFlowsIO().readValue(this.jsonIO().getValue(node, PROP_FLOWS)));
        model.setOpenIdConnectUrl(this.jsonIO().getString(node, PROP_OPEN_ID_CONNECT_URL));
        model.setExtensions(this.extensionIO().readMap(node));
        return model;
    }

    @Override
    public Optional<O> write(SecurityScheme model) {
        return this.optionalJsonObject(model).map(node -> {
            if (this.isReference((Reference<?>)model)) {
                this.setReference(node, (Reference<?>)model);
                this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
            } else {
                this.setIfPresent(node, PROP_TYPE, this.jsonIO().toJson(model.getType()));
                this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
                this.setIfPresent(node, PROP_NAME, this.jsonIO().toJson(model.getName()));
                this.setIfPresent(node, PROP_IN, this.jsonIO().toJson(model.getIn()));
                this.setIfPresent(node, PROP_SCHEME, this.jsonIO().toJson(model.getScheme()));
                this.setIfPresent(node, PROP_BEARER_FORMAT, this.jsonIO().toJson(model.getBearerFormat()));
                this.setIfPresent(node, PROP_FLOWS, this.oauthFlowsIO().write(model.getFlows()));
                this.setIfPresent(node, PROP_OPEN_ID_CONNECT_URL, this.jsonIO().toJson(model.getOpenIdConnectUrl()));
                this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
            }
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

