/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.security;

import io.smallrye.openapi.api.models.security.SecurityRequirementImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class SecurityRequirementsSetIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<SecurityRequirement, V, A, O, AB, OB> {
    public SecurityRequirementsSetIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.SECURITY_REQUIREMENTS_SET, Names.create(SecurityRequirement.class));
    }

    public List<SecurityRequirement> readList(AnnotationTarget target) {
        return this.readList(this.getRepeatableAnnotations(target));
    }

    public List<SecurityRequirement> readList(AnnotationValue annotations) {
        return Optional.ofNullable(annotations).map(AnnotationValue::asNestedArray).map(this::readList).orElse(null);
    }

    private List<SecurityRequirement> readList(AnnotationInstance[] annotations) {
        return this.readList(Arrays.asList(annotations));
    }

    public List<SecurityRequirement> readList(Collection<AnnotationInstance> annotations) {
        return annotations.stream().map(set -> Optional.ofNullable(set.value()).map(AnnotationValue::asNestedArray).map(this::readSet).orElseGet(SecurityRequirementImpl::new)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    SecurityRequirement readSet(AnnotationInstance[] annotations) {
        SecurityRequirementImpl requirement = new SecurityRequirementImpl();
        Arrays.stream(annotations).map(this.securityRequirementIO()::readEntry).forEach(scheme -> requirement.addScheme((String)scheme.getKey(), (List)scheme.getValue()));
        return requirement;
    }

    @Override
    public SecurityRequirement read(AnnotationInstance annotation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SecurityRequirement readObject(O node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<O> write(SecurityRequirement model) {
        throw new UnsupportedOperationException();
    }
}

