/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.schema;

import io.smallrye.openapi.api.constants.JDKConstants;
import io.smallrye.openapi.api.constants.MutinyConstants;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.OpenApiDataObjectScanner;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.EnumProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class SchemaFactory {
    private SchemaFactory() {
    }

    public static Schema readSchema(AnnotationScannerContext context, AnnotationValue value) {
        if (value == null) {
            return null;
        }
        return SchemaFactory.readSchema(context, value.asNested());
    }

    public static Schema readSchema(AnnotationScannerContext context, AnnotationInstance schemaAnnotation) {
        if (SchemaFactory.isAnnotationMissingOrHidden(context, schemaAnnotation, Collections.emptyMap())) {
            return null;
        }
        return SchemaFactory.readSchema(context, (Schema)new SchemaImpl(), schemaAnnotation, Collections.emptyMap());
    }

    public static Schema readSchema(AnnotationScannerContext context, Schema schema, AnnotationInstance annotation, ClassInfo clazz) {
        return SchemaFactory.readSchema(context, schema, annotation, clazz, Collections.emptyMap());
    }

    static Schema readSchema(AnnotationScannerContext context, Schema schema, AnnotationInstance annotation, ClassInfo clazz, Map<String, Object> defaults) {
        if (SchemaFactory.isAnnotationMissingOrHidden(context, annotation, defaults)) {
            return schema;
        }
        schema = SchemaFactory.readSchema(context, schema, annotation, defaults);
        ClassType clazzType = (ClassType)Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS);
        SchemaFactory.schemaRegistration(context, (Type)clazzType, schema);
        return schema;
    }

    public static Schema readSchema(AnnotationScannerContext context, Schema schema, AnnotationInstance annotation, Map<String, Object> defaults) {
        if (SchemaFactory.isAnnotationMissingOrHidden(context, annotation, defaults)) {
            return schema;
        }
        String ref = (String)((Object)SchemaFactory.readAttr(context, annotation, "ref", defaults));
        if (ref != null) {
            schema.setRef(ref);
            defaults = Collections.emptyMap();
        }
        schema.setNot(SchemaFactory.readAttr(context, annotation, "not", types -> SchemaFactory.readClassSchema(context, types, true), defaults));
        schema.setOneOf(SchemaFactory.readAttr(context, annotation, "oneOf", types -> SchemaFactory.readClassSchemas(context, types, false), defaults));
        schema.setAnyOf(SchemaFactory.readAttr(context, annotation, "anyOf", types -> SchemaFactory.readClassSchemas(context, types, false), defaults));
        schema.setAllOf(SchemaFactory.readAttr(context, annotation, "allOf", types -> SchemaFactory.readClassSchemas(context, types, true), defaults));
        schema.setIfSchema(SchemaFactory.readAttr(context, annotation, "ifSchema", types -> SchemaFactory.readClassSchema(context, types, true), defaults));
        schema.setThenSchema(SchemaFactory.readAttr(context, annotation, "thenSchema", types -> SchemaFactory.readClassSchema(context, types, true), defaults));
        schema.setElseSchema(SchemaFactory.readAttr(context, annotation, "elseSchema", types -> SchemaFactory.readClassSchema(context, types, true), defaults));
        schema.setTitle((String)((Object)SchemaFactory.readAttr(context, annotation, "title", defaults)));
        schema.setMultipleOf(SchemaFactory.readAttr(context, annotation, "multipleOf", BigDecimal::valueOf, defaults));
        BigDecimal maximum = SchemaFactory.readAttr(context, annotation, "maximum", SchemaFactory::tolerantParseBigDecimal, defaults);
        BigDecimal minimum = SchemaFactory.readAttr(context, annotation, "minimum", SchemaFactory::tolerantParseBigDecimal, defaults);
        if (maximum != null) {
            if (Boolean.TRUE.equals(SchemaFactory.readAttr(context, annotation, "exclusiveMaximum", defaults))) {
                schema.setExclusiveMaximum(maximum);
            } else {
                schema.setMaximum(maximum);
            }
        }
        if (minimum != null) {
            if (Boolean.TRUE.equals(SchemaFactory.readAttr(context, annotation, "exclusiveMinimum", defaults))) {
                schema.setExclusiveMinimum(minimum);
            } else {
                schema.setMinimum(minimum);
            }
        }
        schema.setMaxLength((Integer)((Object)SchemaFactory.readAttr(context, annotation, "maxLength", defaults)));
        schema.setMinLength((Integer)((Object)SchemaFactory.readAttr(context, annotation, "minLength", defaults)));
        schema.setPattern((String)((Object)SchemaFactory.readAttr(context, annotation, "pattern", defaults)));
        schema.setMaxProperties((Integer)((Object)SchemaFactory.readAttr(context, annotation, "maxProperties", defaults)));
        schema.setMinProperties((Integer)((Object)SchemaFactory.readAttr(context, annotation, "minProperties", defaults)));
        schema.setRequired((List)((Object)SchemaFactory.readAttr(context, annotation, "requiredProperties", defaults)));
        schema.setDescription((String)((Object)SchemaFactory.readAttr(context, annotation, "description", defaults)));
        schema.setFormat((String)((Object)SchemaFactory.readAttr(context, annotation, "format", defaults)));
        SchemaImpl.setNullable(schema, (Boolean)((Object)SchemaFactory.readAttr(context, annotation, "nullable", defaults)));
        schema.setReadOnly((Boolean)((Object)SchemaFactory.readAttr(context, annotation, "readOnly", defaults)));
        schema.setWriteOnly((Boolean)((Object)SchemaFactory.readAttr(context, annotation, "writeOnly", defaults)));
        schema.setExternalDocs((ExternalDocumentation)context.io().extDocIO().read(annotation.value("externalDocs")));
        schema.setDeprecated((Boolean)((Object)SchemaFactory.readAttr(context, annotation, "deprecated", defaults)));
        Schema.SchemaType type = SchemaFactory.readSchemaType(context, annotation, schema, defaults);
        SchemaImpl.setType(schema, type);
        Object example = SchemaFactory.parseSchemaAttr(context, annotation, "example", defaults, type);
        List examples = SchemaFactory.readAttr(context, annotation, "examples", egs -> Arrays.stream(egs).map(e -> SchemaFactory.parseValue(context, e, type)).collect(Collectors.toCollection(ArrayList::new)), defaults);
        if (examples != null) {
            if (example != null) {
                examples.add(example);
            }
            schema.setExamples(examples);
        } else {
            schema.setExamples(SchemaFactory.wrapInList(example));
        }
        schema.setDefaultValue(SchemaFactory.parseSchemaAttr(context, annotation, "defaultValue", defaults, type));
        schema.setDiscriminator(context.io().discriminatorIO().read(annotation));
        schema.setMaxItems((Integer)((Object)SchemaFactory.readAttr(context, annotation, "maxItems", defaults)));
        schema.setMinItems((Integer)((Object)SchemaFactory.readAttr(context, annotation, "minItems", defaults)));
        schema.setUniqueItems((Boolean)((Object)SchemaFactory.readAttr(context, annotation, "uniqueItems", defaults)));
        schema.setExtensions(context.io().extensionIO().readExtensible(annotation));
        schema.setComment((String)((Object)SchemaFactory.readAttr(context, annotation, "comment", defaults)));
        schema.setConstValue(SchemaFactory.parseSchemaAttr(context, annotation, "constValue", defaults, type));
        schema.setProperties(SchemaFactory.readAttr(context, annotation, "properties", properties -> {
            if (properties == null || ((AnnotationInstance[])properties).length == 0) {
                return null;
            }
            LinkedHashMap<String, Schema> propertySchemas = new LinkedHashMap<String, Schema>(((AnnotationInstance[])properties).length);
            for (AnnotationInstance propAnnotation : properties) {
                String key = (String)context.annotations().value(propAnnotation, "name");
                Schema value = SchemaFactory.readSchema(context, (Schema)new SchemaImpl(), propAnnotation, Collections.emptyMap());
                propertySchemas.put(key, value);
            }
            return propertySchemas;
        }, defaults));
        schema.setAdditionalPropertiesSchema(SchemaFactory.readAttr(context, annotation, "additionalProperties", types -> SchemaFactory.readClassSchema(context, types, true), defaults));
        schema.setDependentRequired(SchemaFactory.readAttr(context, annotation, "dependentRequired", annos -> SchemaFactory.readDependentRequired(context, annos), defaults));
        schema.setDependentSchemas(SchemaFactory.readAttr(context, annotation, "dependentSchemas", annos -> SchemaFactory.readDependentSchemas(context, annos), defaults));
        schema.setContentEncoding((String)((Object)SchemaFactory.readAttr(context, annotation, "contentEncoding", defaults)));
        schema.setContentMediaType((String)((Object)SchemaFactory.readAttr(context, annotation, "contentMediaType", defaults)));
        schema.setContentSchema(SchemaFactory.readAttr(context, annotation, "contentSchema", types -> SchemaFactory.readClassSchema(context, types, true), defaults));
        schema.setContains(SchemaFactory.readAttr(context, annotation, "contains", types -> SchemaFactory.readClassSchema(context, types, true), defaults));
        schema.setMaxContains((Integer)((Object)SchemaFactory.readAttr(context, annotation, "maxContains", defaults)));
        schema.setMinContains((Integer)((Object)SchemaFactory.readAttr(context, annotation, "minContains", defaults)));
        schema.setPrefixItems(SchemaFactory.readAttr(context, annotation, "prefixItems", types -> SchemaFactory.readClassSchemas(context, types, true), defaults));
        schema.setPropertyNames(SchemaFactory.readAttr(context, annotation, "propertyNames", types -> SchemaFactory.readClassSchema(context, types, true), defaults));
        schema.setPatternProperties(SchemaFactory.readAttr(context, annotation, "patternProperties", annos -> SchemaFactory.readPatternProperties(context, annos), defaults));
        List enumeration = SchemaFactory.readAttr(context, annotation, "enumeration", values -> {
            ArrayList<Object> parsed = new ArrayList<Object>(((Object[])values).length);
            if (type == Schema.SchemaType.STRING) {
                parsed.addAll(Arrays.asList(values));
            } else {
                Arrays.stream(values).map(String.class::cast).map(v -> SchemaFactory.parseValue(context, v, type)).forEach(parsed::add);
            }
            return parsed;
        }, defaults);
        if (enumeration != null && !enumeration.isEmpty()) {
            schema.setEnumeration(enumeration);
        }
        boolean namedComponent = SchemaImpl.isNamed(schema);
        if (JandexUtil.isSimpleClassSchema(annotation)) {
            Schema implSchema = SchemaFactory.readClassSchema(context, (Type)context.annotations().value(annotation, "implementation"), !namedComponent);
            schema = MergeUtil.mergeObjects(implSchema, schema);
        } else if (JandexUtil.isSimpleArraySchema(context, annotation)) {
            Schema implSchema = SchemaFactory.readClassSchema(context, (Type)context.annotations().value(annotation, "implementation"), !namedComponent);
            schema.setItems(implSchema);
        } else {
            schema = SchemaFactory.includeTypeSchema(context, schema, (Type)context.annotations().value(annotation, "implementation"));
        }
        return schema;
    }

    public static Schema includeTypeSchema(AnnotationScannerContext context, Schema schema, Type type) {
        Schema implSchema = null;
        if (type != null) {
            implSchema = SchemaFactory.readClassSchema(context, type, false);
        }
        if (schema.getType() != null && schema.getType().contains(Schema.SchemaType.ARRAY) && implSchema != null) {
            schema.setItems(implSchema);
        } else if (implSchema != null) {
            schema = MergeUtil.mergeObjects(implSchema, schema);
        }
        return schema;
    }

    static boolean isAnnotationMissingOrHidden(AnnotationScannerContext context, AnnotationInstance annotation, Map<String, Object> defaults) {
        if (annotation == null) {
            return true;
        }
        return Boolean.TRUE.equals(SchemaFactory.readAttr(context, annotation, "hidden", defaults));
    }

    static <T> T readAttr(AnnotationScannerContext context, AnnotationInstance annotation, String propertyName, Map<String, Object> defaults) {
        return (T)SchemaFactory.readAttr(context, annotation, propertyName, defaults.get(propertyName));
    }

    static <T> T readAttr(AnnotationScannerContext context, AnnotationInstance annotation, String propertyName, T defaultValue) {
        Object value = context.annotations().value(annotation, propertyName);
        if (value == null) {
            value = defaultValue;
        } else if (value.getClass().isArray()) {
            value = Arrays.stream((Object[])value).collect(Collectors.toList());
        }
        return value;
    }

    static Object parseSchemaAttr(AnnotationScannerContext context, AnnotationInstance annotation, String propertyName, Map<String, Object> defaults, Schema.SchemaType schemaType) {
        return SchemaFactory.readAttr(context, annotation, propertyName, value -> {
            if (value instanceof String) {
                return SchemaFactory.parseValue(context, (String)value, schemaType);
            }
            return value;
        }, defaults);
    }

    static Object parseValue(AnnotationScannerContext context, String stringValue, Schema.SchemaType schemaType) {
        if (schemaType != Schema.SchemaType.STRING) {
            for (AnnotationScannerExtension e : context.getExtensions()) {
                Object parsedValue = e.parseValue(stringValue);
                if (parsedValue == null) continue;
                return parsedValue;
            }
        }
        return stringValue;
    }

    static <R, T> T readAttr(AnnotationScannerContext context, AnnotationInstance annotation, String propertyName, Function<R, T> converter, Map<String, Object> defaults) {
        Object rawValue = context.annotations().value(annotation, propertyName);
        Object value = rawValue == null ? defaults.get(propertyName) : converter.apply(rawValue);
        return (T)value;
    }

    static Schema.SchemaType readSchemaType(AnnotationScannerContext context, AnnotationInstance annotation, Schema schema, Map<String, Object> defaults) {
        Schema.SchemaType type = SchemaFactory.readAttr(context, annotation, "type", SchemaFactory::parseSchemaType, defaults);
        if (type != null) {
            return type;
        }
        List types = schema.getType();
        if (types != null) {
            return types.stream().filter(t -> t != Schema.SchemaType.NULL).findFirst().orElse(null);
        }
        return null;
    }

    static Schema.SchemaType parseSchemaType(String value) {
        try {
            return Schema.SchemaType.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static <T> List<T> wrapInList(T value) {
        if (value == null) {
            return null;
        }
        return Collections.singletonList(value);
    }

    static Schema readClassSchema(AnnotationScannerContext context, Type type, boolean schemaReferenceSupported) {
        Schema schema;
        if (type == null) {
            return null;
        }
        if (type.name().equals((Object)SchemaConstant.DOTNAME_TRUE_SCHEMA)) {
            schema = new SchemaImpl().booleanSchema(true);
        } else if (type.name().equals((Object)SchemaConstant.DOTNAME_FALSE_SCHEMA)) {
            schema = new SchemaImpl().booleanSchema(false);
        } else if (type.kind() == Type.Kind.ARRAY) {
            schema = new SchemaImpl().addType(Schema.SchemaType.ARRAY);
            ArrayType array = type.asArrayType();
            int dimensions = array.dimensions();
            Type componentType = array.component();
            if (dimensions > 1) {
                schema.setItems(SchemaFactory.readClassSchema(context, (Type)ArrayType.create((Type)componentType, (int)(dimensions - 1)), schemaReferenceSupported));
            } else {
                schema.setItems(SchemaFactory.readClassSchema(context, componentType, schemaReferenceSupported));
            }
        } else {
            schema = type.kind() == Type.Kind.PRIMITIVE ? OpenApiDataObjectScanner.process(type.asPrimitiveType()) : SchemaFactory.introspectClassToSchema(context, type.asClassType(), schemaReferenceSupported);
        }
        return schema;
    }

    public static Schema typeToSchema(AnnotationScannerContext context, Type type) {
        return SchemaFactory.typeToSchema(context, type, null, context.getExtensions());
    }

    public static Schema typeToSchema(AnnotationScannerContext context, Type type, AnnotationInstance schemaAnnotation, List<AnnotationScannerExtension> extensions) {
        Schema schema = null;
        Schema fromAnnotation = null;
        if (schemaAnnotation != null && (fromAnnotation = SchemaFactory.readSchema(context, schemaAnnotation)) == null) {
            return null;
        }
        Optional<AnnotationScanner> currentScanner = context.getCurrentScanner();
        if (TypeUtil.isWrappedType(type)) {
            schema = SchemaFactory.typeToSchema(context, TypeUtil.unwrapType(type), null, extensions);
        } else if (currentScanner.isPresent() && currentScanner.get().isWrapperType(type)) {
            schema = SchemaFactory.typeToSchema(context, currentScanner.get().unwrapType(type), null, extensions);
        } else if (TypeUtil.isTerminalType(type)) {
            schema = new SchemaImpl();
            TypeUtil.applyTypeAttributes(type, schema);
            schema = SchemaFactory.schemaRegistration(context, type, schema);
        } else if (type.kind() == Type.Kind.ARRAY) {
            schema = new SchemaImpl().addType(Schema.SchemaType.ARRAY);
            ArrayType array = type.asArrayType();
            int dimensions = array.dimensions();
            Type componentType = array.component();
            if (dimensions > 1) {
                schema.setItems(SchemaFactory.typeToSchema(context, (Type)ArrayType.create((Type)componentType, (int)(dimensions - 1)), null, extensions));
            } else {
                schema.setItems(SchemaFactory.typeToSchema(context, componentType, null, extensions));
            }
        } else {
            schema = type.kind() == Type.Kind.CLASS ? SchemaFactory.introspectClassToSchema(context, type.asClassType(), true) : (type.kind() == Type.Kind.PRIMITIVE ? OpenApiDataObjectScanner.process(type.asPrimitiveType()) : SchemaFactory.otherTypeToSchema(context, type, extensions));
        }
        if (fromAnnotation != null) {
            schema = MergeUtil.mergeObjects(schema, fromAnnotation);
        }
        return schema;
    }

    public static Schema enumToSchema(AnnotationScannerContext context, Type enumType) {
        IoLogging.logger.enumProcessing(enumType);
        List<Object> enumeration = EnumProcessor.enumConstants(context, enumType);
        ClassInfo enumKlazz = context.getIndex().getClassByName(TypeUtil.getName(enumType));
        AnnotationInstance schemaAnnotation = context.annotations().getAnnotation((AnnotationTarget)enumKlazz, SchemaConstant.DOTNAME_SCHEMA);
        SchemaImpl enumSchema = new SchemaImpl();
        if (schemaAnnotation != null) {
            HashMap<String, Object> defaults = new HashMap<String, Object>(2);
            defaults.put("type", Schema.SchemaType.STRING);
            defaults.put("enumeration", enumeration);
            enumSchema = SchemaFactory.readSchema(context, enumSchema, schemaAnnotation, enumKlazz, defaults);
        } else {
            enumSchema.addType(Schema.SchemaType.STRING);
            enumSchema.setEnumeration(enumeration);
        }
        return enumSchema;
    }

    private static Schema introspectClassToSchema(AnnotationScannerContext context, ClassType ctype, boolean schemaReferenceSupported) {
        AnnotationInstance schemaAnnotation;
        Optional<AnnotationScanner> currentScanner = context.getCurrentScanner();
        if (currentScanner.isPresent() && currentScanner.get().isScannerInternalResponse((Type)ctype)) {
            return null;
        }
        ClassInfo classInfo = context.getAugmentedIndex().getClass((Type)ctype);
        if (classInfo != null && (schemaAnnotation = context.annotations().getAnnotation((AnnotationTarget)classInfo, SchemaConstant.DOTNAME_SCHEMA)) != null && Boolean.TRUE.equals(SchemaFactory.readAttr(context, schemaAnnotation, "hidden", false))) {
            return null;
        }
        SchemaRegistry schemaRegistry = context.getSchemaRegistry();
        if (schemaRegistry.hasSchema((Type)ctype, context.getJsonViews())) {
            if (schemaReferenceSupported) {
                return schemaRegistry.lookupRef((Type)ctype, context.getJsonViews());
            }
            return SchemaImpl.copyOf(schemaRegistry.lookupSchema((Type)ctype, context.getJsonViews()));
        }
        if (context.getScanStack().contains(ctype)) {
            return schemaRegistry.registerReference((Type)ctype, context.getJsonViews(), null, new SchemaImpl());
        }
        Schema schema = OpenApiDataObjectScanner.process(context, (Type)ctype);
        if (schemaReferenceSupported) {
            return SchemaFactory.schemaRegistration(context, (Type)ctype, schema);
        }
        return schema;
    }

    public static Schema schemaRegistration(AnnotationScannerContext context, Type type, Schema schema) {
        SchemaRegistry schemaRegistry = context.getSchemaRegistry();
        if (SchemaFactory.allowRegistration(context, schemaRegistry, type, schema)) {
            schema = schemaRegistry.register(type, context.getJsonViews(), schema);
        } else if (schemaRegistry != null && schemaRegistry.hasRef(type, context.getJsonViews())) {
            schema = schemaRegistry.lookupRef(type, context.getJsonViews());
        }
        return schema;
    }

    static boolean allowRegistration(AnnotationScannerContext context, SchemaRegistry registry, Type type, Schema schema) {
        if (schema == null || registry.isDisabled() || !registry.isTypeRegistrationSupported(type, schema)) {
            return false;
        }
        return !registry.hasSchema(type, context.getJsonViews());
    }

    private static List<Schema> readClassSchemas(AnnotationScannerContext context, Type[] types, boolean removeCurrent) {
        if (Arrays.stream(types).allMatch(type -> type.kind() == Type.Kind.VOID)) {
            return null;
        }
        IoLogging.logger.annotationsList("schema Class");
        Type introspectedClassType = removeCurrent ? context.getScanStack().peek() : null;
        return Arrays.stream(types).filter(type -> !type.equals((Object)introspectedClassType)).map(type -> SchemaFactory.readClassSchema(context, type, true)).collect(Collectors.toList());
    }

    private static Schema otherTypeToSchema(AnnotationScannerContext context, Type type, List<AnnotationScannerExtension> extensions) {
        if (TypeUtil.isA(context, type, MutinyConstants.MULTI_TYPE)) {
            Schema schema = new SchemaImpl().addType(Schema.SchemaType.ARRAY);
            Type componentType = (Type)type.asParameterizedType().arguments().get(0);
            schema.setItems(SchemaFactory.typeToSchema(context, componentType, null, extensions));
            return schema;
        }
        Type asyncType = SchemaFactory.resolveAsyncType(context, type, extensions);
        return SchemaFactory.schemaRegistration(context, asyncType, OpenApiDataObjectScanner.process(context, asyncType));
    }

    static Type resolveAsyncType(AnnotationScannerContext context, Type type, List<AnnotationScannerExtension> extensions) {
        ParameterizedType pType;
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && (pType = type.asParameterizedType()).arguments().size() == 1 && TypeUtil.isA(context, type, JDKConstants.COMPLETION_STAGE_TYPE)) {
            return (Type)pType.arguments().get(0);
        }
        for (AnnotationScannerExtension extension : extensions) {
            Type asyncType = extension.resolveAsyncType(type);
            if (asyncType == null) continue;
            return asyncType;
        }
        return type;
    }

    private static BigDecimal tolerantParseBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Map<String, List<String>> readDependentRequired(AnnotationScannerContext context, AnnotationInstance[] requireds) {
        if (requireds == null || requireds.length == 0) {
            return null;
        }
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (AnnotationInstance required : requireds) {
            String name = (String)context.annotations().value(required, "name");
            String[] requires = (String[])context.annotations().value(required, "requires");
            result.put(name, new ArrayList<String>(Arrays.asList(requires)));
        }
        return result;
    }

    private static Map<String, Schema> readDependentSchemas(AnnotationScannerContext context, AnnotationInstance[] dependentSchemas) {
        if (dependentSchemas == null || dependentSchemas.length == 0) {
            return null;
        }
        LinkedHashMap<String, Schema> result = new LinkedHashMap<String, Schema>();
        for (AnnotationInstance dependentSchema : dependentSchemas) {
            String name = (String)context.annotations().value(dependentSchema, "name");
            Type schemaClass = (Type)context.annotations().value(dependentSchema, "schema");
            Schema schema = SchemaFactory.readClassSchema(context, schemaClass, true);
            if (schema == null) continue;
            result.put(name, schema);
        }
        return result;
    }

    private static Map<String, Schema> readPatternProperties(AnnotationScannerContext context, AnnotationInstance[] patternProperties) {
        if (patternProperties == null || patternProperties.length == 0) {
            return null;
        }
        LinkedHashMap<String, Schema> result = new LinkedHashMap<String, Schema>();
        for (AnnotationInstance patternProperty : patternProperties) {
            String regex = (String)context.annotations().value(patternProperty, "regex");
            Type schemaClass = (Type)context.annotations().value(patternProperty, "schema");
            Schema schema = SchemaFactory.readClassSchema(context, schemaClass, true);
            if (schema == null) continue;
            result.put(regex, schema);
        }
        return result;
    }
}

