/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.schema;

import io.smallrye.openapi.runtime.io.schema.DataType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.jboss.jandex.DotName;

public class SchemaConstant {
    public static final DotName DOTNAME_SCHEMA = DotName.createSimple((String)Schema.class.getName());
    public static final DotName DOTNAME_TRUE_SCHEMA = DotName.createSimple((String)(Schema.class.getName() + "$True"));
    public static final DotName DOTNAME_FALSE_SCHEMA = DotName.createSimple((String)(Schema.class.getName() + "$False"));
    public static final String PROP_DISCRIMINATOR = "discriminator";
    public static final String PROP_XML = "xml";
    public static final String PROP_NAME = "name";
    public static final String PROP_REQUIRED = "required";
    public static final String PROP_IMPLEMENTATION = "implementation";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_TYPE = "type";
    public static final String PROP_FORMAT = "format";
    public static final String PROP_PATTERN = "pattern";
    public static final String PROP_EXAMPLE = "example";
    public static final String PROP_EXAMPLES = "examples";
    public static final String PROP_EXTERNAL_DOCS = "externalDocs";
    public static final String REF = "ref";
    public static final String PROP_MIN_PROPERTIES = "minProperties";
    public static final String PROP_ALL_OF = "allOf";
    public static final String PROP_MAX_ITEMS = "maxItems";
    public static final String PROP_EXCLUSIVE_MINIMUM = "exclusiveMinimum";
    public static final String PROP_DEFAULT_VALUE = "defaultValue";
    public static final String PROP_DEFAULT = "default";
    public static final String PROP_DISCRIMINATOR_MAPPING = "discriminatorMapping";
    public static final String PROP_ANY_OF = "anyOf";
    public static final String PROP_SCHEMA = "schema";
    public static final String PROP_ADDITIONAL_PROPERTIES = "additionalProperties";
    public static final String PROP_MULTIPLE_OF = "multipleOf";
    public static final String PROP_DEPRECATED = "deprecated";
    public static final String PROP_MINIMUM = "minimum";
    public static final String PROP_DISCRIMINATOR_PROPERTY = "discriminatorProperty";
    public static final String PROP_MAXIMUM = "maximum";
    public static final String PROP_READ_ONLY = "readOnly";
    public static final String PROP_TITLE = "title";
    public static final String PROP_NULLABLE = "nullable";
    public static final String PROP_UNIQUE_ITEMS = "uniqueItems";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_MIN_LENGTH = "minLength";
    public static final String PROP_SCHEMA_DIALECT = "$schema";
    public static final String PROP_COMMENT = "$comment";
    public static final String PROP_REF = "$ref";
    public static final String PROP_IF = "if";
    public static final String PROP_THEN = "then";
    public static final String PROP_ELSE = "else";
    public static final String PROP_DEPENDENT_SCHEMAS = "dependentSchemas";
    public static final String PROP_PROPERTY_NAMES = "propertyNames";
    public static final String PROP_UNEVALUATED_ITEMS = "unevaluatedItems";
    public static final String PROP_UNEVALUATED_PROPERTIES = "unevaluatedProperties";
    public static final String PROP_CONST = "const";
    public static final String PROP_MAX_CONTAINS = "maxContains";
    public static final String PROP_MIN_CONTAINS = "minContains";
    public static final String PROP_DEPENDENT_REQUIRED = "dependentRequired";
    public static final String PROP_CONTENT_ENCODING = "contentEncoding";
    public static final String PROP_CONTENT_MEDIA_TYPE = "contentMediaType";
    public static final String PROP_CONTENT_SCHEMA = "contentSchema";
    public static final String PROP_ENUMERATION = "enumeration";
    public static final String PROP_ENUM = "enum";
    public static final String PROP_MAX_LENGTH = "maxLength";
    public static final String PROP_EXCLUSIVE_MAXIMUM = "exclusiveMaximum";
    public static final String PROP_WRITE_ONLY = "writeOnly";
    public static final String PROP_VALUE = "value";
    public static final String PROP_MIN_ITEMS = "minItems";
    public static final String PROP_ONE_OF = "oneOf";
    public static final String PROP_ITEMS = "items";
    public static final String PROP_MAX_PROPERTIES = "maxProperties";
    public static final String PROP_PREFIX_ITEMS = "prefixItems";
    public static final String PROP_CONTAINS = "contains";
    public static final String PROP_PATTERN_PROPERTIES = "patternProperties";
    public static final String PROP_IF_SCHEMA = "ifSchema";
    public static final String PROP_THEN_SCHEMA = "thenSchema";
    public static final String PROP_ELSE_SCHEMA = "elseSchema";
    public static final String PROP_CONST_VALUE = "constValue";
    public static final String PROP_COMMENT_FIELD = "comment";
    public static final String PROP_REQUIRED_PROPERTIES = "requiredProperties";
    public static final String PROP_PROPERTIES = "properties";
    public static final String PROP_NOT = "not";
    public static final String PROP_REGEX = "regex";
    public static final String PROP_REQUIRES = "requires";
    public static final String DIALECT_OAS31 = "https://spec.openapis.org/oas/3.1/dialect/base";
    public static final String DIALECT_JSON_2020_12 = "https://json-schema.org/draft/2020-12/schema";
    public static final List<String> PROPERTIES_NONDISPLAY = Collections.unmodifiableList(Arrays.asList("implementation", "name", "required"));
    public static final Map<String, DataType> PROPERTIES_DATA_TYPES = new HashMap<String, DataType>();

    private SchemaConstant() {
    }

    static {
        PROPERTIES_DATA_TYPES.put(PROP_REF, DataType.type(String.class));
        PROPERTIES_DATA_TYPES.put(PROP_DISCRIMINATOR, DataType.type(Discriminator.class));
        PROPERTIES_DATA_TYPES.put(PROP_TITLE, DataType.type(String.class));
        PROPERTIES_DATA_TYPES.put(PROP_DEFAULT, DataType.type(Object.class));
        PROPERTIES_DATA_TYPES.put(PROP_ENUM, DataType.listOf(DataType.type(Object.class)));
        PROPERTIES_DATA_TYPES.put(PROP_MULTIPLE_OF, DataType.type(BigDecimal.class));
        PROPERTIES_DATA_TYPES.put(PROP_MAXIMUM, DataType.type(BigDecimal.class));
        PROPERTIES_DATA_TYPES.put(PROP_EXCLUSIVE_MAXIMUM, DataType.type(BigDecimal.class));
        PROPERTIES_DATA_TYPES.put(PROP_MINIMUM, DataType.type(BigDecimal.class));
        PROPERTIES_DATA_TYPES.put(PROP_EXCLUSIVE_MINIMUM, DataType.type(BigDecimal.class));
        PROPERTIES_DATA_TYPES.put(PROP_MAX_LENGTH, DataType.type(Integer.class));
        PROPERTIES_DATA_TYPES.put(PROP_MIN_LENGTH, DataType.type(Integer.class));
        PROPERTIES_DATA_TYPES.put(PROP_PATTERN, DataType.type(String.class));
        PROPERTIES_DATA_TYPES.put(PROP_MAX_ITEMS, DataType.type(Integer.class));
        PROPERTIES_DATA_TYPES.put(PROP_MIN_ITEMS, DataType.type(Integer.class));
        PROPERTIES_DATA_TYPES.put(PROP_UNIQUE_ITEMS, DataType.type(Boolean.class));
        PROPERTIES_DATA_TYPES.put(PROP_MAX_PROPERTIES, DataType.type(Integer.class));
        PROPERTIES_DATA_TYPES.put(PROP_MIN_PROPERTIES, DataType.type(Integer.class));
        PROPERTIES_DATA_TYPES.put(PROP_REQUIRED, DataType.listOf(DataType.type(String.class)));
        PROPERTIES_DATA_TYPES.put(PROP_NOT, DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
        PROPERTIES_DATA_TYPES.put(PROP_PROPERTIES, DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class)));
        PROPERTIES_DATA_TYPES.put(PROP_ADDITIONAL_PROPERTIES, DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
        PROPERTIES_DATA_TYPES.put(PROP_DESCRIPTION, DataType.type(String.class));
        PROPERTIES_DATA_TYPES.put(PROP_FORMAT, DataType.type(String.class));
        PROPERTIES_DATA_TYPES.put(PROP_READ_ONLY, DataType.type(Boolean.class));
        PROPERTIES_DATA_TYPES.put(PROP_WRITE_ONLY, DataType.type(Boolean.class));
        PROPERTIES_DATA_TYPES.put(PROP_EXAMPLE, DataType.type(Object.class));
        PROPERTIES_DATA_TYPES.put(PROP_EXTERNAL_DOCS, DataType.type(ExternalDocumentation.class));
        PROPERTIES_DATA_TYPES.put(PROP_DEPRECATED, DataType.type(Boolean.class));
        PROPERTIES_DATA_TYPES.put(PROP_XML, DataType.type(XML.class));
        PROPERTIES_DATA_TYPES.put(PROP_ITEMS, DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
        PROPERTIES_DATA_TYPES.put(PROP_ALL_OF, DataType.listOf(DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class)));
        PROPERTIES_DATA_TYPES.put(PROP_ANY_OF, DataType.listOf(DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class)));
        PROPERTIES_DATA_TYPES.put(PROP_ONE_OF, DataType.listOf(DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class)));
        PROPERTIES_DATA_TYPES.put(PROP_SCHEMA_DIALECT, DataType.type(String.class));
        PROPERTIES_DATA_TYPES.put(PROP_COMMENT, DataType.type(String.class));
        PROPERTIES_DATA_TYPES.put(PROP_IF, DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
        PROPERTIES_DATA_TYPES.put(PROP_THEN, DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
        PROPERTIES_DATA_TYPES.put(PROP_ELSE, DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
        PROPERTIES_DATA_TYPES.put(PROP_DEPENDENT_SCHEMAS, DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class)));
        PROPERTIES_DATA_TYPES.put(PROP_PREFIX_ITEMS, DataType.listOf(DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class)));
        PROPERTIES_DATA_TYPES.put(PROP_CONTAINS, DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
        PROPERTIES_DATA_TYPES.put(PROP_PATTERN_PROPERTIES, DataType.mapOf(DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class)));
        PROPERTIES_DATA_TYPES.put(PROP_PROPERTY_NAMES, DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
        PROPERTIES_DATA_TYPES.put(PROP_UNEVALUATED_ITEMS, DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
        PROPERTIES_DATA_TYPES.put(PROP_UNEVALUATED_PROPERTIES, DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
        PROPERTIES_DATA_TYPES.put(PROP_CONST, DataType.type(Object.class));
        PROPERTIES_DATA_TYPES.put(PROP_MAX_CONTAINS, DataType.type(Integer.class));
        PROPERTIES_DATA_TYPES.put(PROP_MIN_CONTAINS, DataType.type(Integer.class));
        PROPERTIES_DATA_TYPES.put(PROP_DEPENDENT_REQUIRED, DataType.mapOf(DataType.listOf(DataType.type(String.class))));
        PROPERTIES_DATA_TYPES.put(PROP_CONTENT_ENCODING, DataType.type(String.class));
        PROPERTIES_DATA_TYPES.put(PROP_CONTENT_MEDIA_TYPE, DataType.type(String.class));
        PROPERTIES_DATA_TYPES.put(PROP_CONTENT_SCHEMA, DataType.type(org.eclipse.microprofile.openapi.models.media.Schema.class));
        PROPERTIES_DATA_TYPES.put(PROP_EXAMPLES, DataType.listOf(DataType.type(Object.class)));
    }
}

