/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.responses;

import io.smallrye.openapi.api.models.responses.APIResponsesImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class APIResponsesIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<APIResponses, V, A, O, AB, OB> {
    private static final String PROP_DEFAULT = "default";

    public APIResponsesIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.API_RESPONSES, Names.create(APIResponses.class));
    }

    public Map<String, APIResponse> readSingle(AnnotationTarget target) {
        return Optional.ofNullable(this.apiResponseIO().getAnnotation(target)).map(Collections::singleton).map(annotations -> this.apiResponseIO().readMap((AnnotationInstance)annotations, this.apiResponseIO()::responseCode)).orElse(null);
    }

    public Map<String, APIResponse> readAll(AnnotationTarget target) {
        return this.apiResponseIO().readMap((AnnotationInstance)target, this.apiResponseIO()::responseCode);
    }

    @Override
    public APIResponses read(AnnotationInstance annotation) {
        AnnotationTarget target = annotation.target();
        return Optional.ofNullable(annotation).map(AnnotationInstance::value).map(AnnotationValue::asNestedArray).map(annotations -> (AnnotationInstance[])Arrays.stream(annotations).map(a -> AnnotationInstance.create((DotName)a.name(), (AnnotationTarget)target, (List)a.values())).toArray(AnnotationInstance[]::new)).map(this::read).map(responses -> (APIResponses)responses.extensions(this.extensionIO().readExtensible(annotation))).orElse(null);
    }

    @Override
    public APIResponses read(AnnotationValue annotation) {
        return Optional.ofNullable(annotation).map(AnnotationValue::asNestedArray).map(this::read).orElse(null);
    }

    public Optional<Map<String, APIResponse>> readResponseSchema(AnnotationTarget target) {
        return Optional.ofNullable(this.scannerContext().annotations().getAnnotation(target, Names.API_RESPONSE_SCHEMA)).map(this.apiResponseIO()::readResponseSchema);
    }

    public APIResponses read(AnnotationInstance[] annotations) {
        IoLogging.logger.annotationsListInto("@APIResponse", "APIResponses model");
        APIResponsesImpl responses = new APIResponsesImpl();
        for (AnnotationInstance nested : annotations) {
            this.apiResponseIO().responseCode(nested).ifPresent(responseCode -> responses.addAPIResponse((String)responseCode, this.apiResponseIO().read(nested)));
        }
        return responses;
    }

    @Override
    public APIResponses readObject(O node) {
        IoLogging.logger.jsonList("APIResponse");
        APIResponsesImpl model = new APIResponsesImpl();
        model.setDefaultValue((APIResponse)this.apiResponseIO().readValue(this.jsonIO().getValue(node, PROP_DEFAULT)));
        model.setExtensions(this.extensionIO().readMap(node));
        this.jsonIO().properties(node).stream().filter(APIResponsesIO.not(property -> PROP_DEFAULT.equals(property.getKey()))).forEach(property -> model.addAPIResponse((String)property.getKey(), (APIResponse)this.apiResponseIO().readValue(property.getValue())));
        return model;
    }

    @Override
    public Optional<O> write(APIResponses model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
            this.setIfPresent(node, PROP_DEFAULT, this.apiResponseIO().write(model.getDefaultValue()));
            this.setAllIfPresent(node, this.apiResponseIO().write(model.getAPIResponses()));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

