/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.media;

import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.media.XMLImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.schema.DataType;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.jandex.AnnotationInstance;

public class SchemaIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<Schema, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_NAME = "name";
    private static final String PROP_PREFIX = "prefix";
    private static final String PROP_NAMESPACE = "namespace";
    private static final String PROP_WRAPPED = "wrapped";
    private static final String PROP_ATTRIBUTE = "attribute";

    public SchemaIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.SCHEMA, Names.create(Schema.class));
    }

    @Override
    public Schema read(AnnotationInstance annotation) {
        return this.read(null, annotation);
    }

    @Override
    protected Schema read(String name, AnnotationInstance annotation) {
        return SchemaFactory.readSchema(this.scannerContext(), (Schema)new SchemaImpl(name), annotation, Collections.emptyMap());
    }

    @Override
    public Schema readValue(V node) {
        if (node == null) {
            return null;
        }
        if (this.jsonIO().isBoolean(node)) {
            return new SchemaImpl().booleanSchema(this.jsonIO().asBoolean(node));
        }
        if (this.jsonIO().isObject(node)) {
            return this.readObject((O)this.jsonIO().asObject(node));
        }
        return null;
    }

    @Override
    public Schema readObject(O node) {
        IoLogging.logger.singleJsonObject("Schema");
        String name = this.getName(node);
        SchemaImpl schema = new SchemaImpl(name);
        String dialect = this.jsonIO().getString(node, "$schema");
        if (dialect == null || dialect.equals("https://spec.openapis.org/oas/3.1/dialect/base") || dialect.equals("https://json-schema.org/draft/2020-12/schema")) {
            this.populateSchemaObject(schema, node);
        } else {
            schema.getDataMap().putAll((Map)this.jsonIO().fromJson(node));
        }
        return schema;
    }

    private void populateSchemaObject(SchemaImpl schema, O node) {
        Map<String, Object> dataMap = schema.getDataMap();
        Object typeNode = this.jsonIO().getValue(node, "type");
        if (typeNode != null) {
            if (this.jsonIO().isString(typeNode)) {
                ArrayList<Object> typeList = new ArrayList<Object>();
                typeList.add(this.readJson(typeNode, DataType.type(Schema.SchemaType.class)));
                dataMap.put("type", typeList);
            } else {
                dataMap.put("type", this.readJson(typeNode, DataType.listOf(DataType.type(Schema.SchemaType.class))));
            }
        }
        for (Map.Entry<String, DataType> entry : SchemaConstant.PROPERTIES_DATA_TYPES.entrySet()) {
            String key = entry.getKey();
            DataType type = entry.getValue();
            Object fieldNode = this.jsonIO().getValue(node, key);
            if (fieldNode == null) continue;
            dataMap.put(key, this.readJson(fieldNode, type));
        }
        for (Map.Entry<String, DataType> entry : this.jsonIO().properties(node)) {
            String name = entry.getKey();
            DataType fieldNode = entry.getValue();
            if (SchemaConstant.PROPERTIES_DATA_TYPES.containsKey(name) || name.equals("type") || name.equals(PROP_NAME)) continue;
            dataMap.put(name, this.jsonIO().fromJson(fieldNode));
        }
    }

    private String getName(O node) {
        Object name = this.jsonIO().getValue(node, PROP_NAME);
        if (this.jsonIO().isString(name)) {
            return this.jsonIO().asString(name);
        }
        return null;
    }

    private Object readJson(V node, DataType desiredType) {
        if (this.jsonIO().isObject(node) && desiredType.type == DataType.Type.MAP) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Object object = this.jsonIO().asObject(node);
            for (Map.Entry entry : this.jsonIO().properties(object)) {
                result.put(entry.getKey(), this.readJson(entry.getValue(), desiredType.content));
            }
            return result;
        }
        if (this.jsonIO().isArray(node) && desiredType.type == DataType.Type.LIST) {
            ArrayList<Object> result = new ArrayList<Object>();
            Object array = this.jsonIO().asArray(node);
            for (Object element : this.jsonIO().entries(array)) {
                result.add(this.readJson(element, desiredType.content));
            }
            return result;
        }
        if (desiredType.type == DataType.Type.OBJECT) {
            return this.readValue(node, desiredType.clazz);
        }
        return this.jsonIO().fromJson(node);
    }

    private Object readValue(V node, Class<?> desiredType) {
        Object result = this.jsonIO().fromJson(node, desiredType);
        if (result != null) {
            return result;
        }
        if (Enum.class.isAssignableFrom(desiredType) && (result = this.enumValue(node, desiredType.asSubclass(Enum.class))) != null) {
            return result;
        }
        if (this.jsonIO().isObject(node)) {
            if (desiredType == Schema.class) {
                return this.readValue(node);
            }
            if (desiredType == XML.class) {
                return this.readXML(node);
            }
            if (desiredType == ExternalDocumentation.class) {
                return this.extDocIO().readValue(node);
            }
            if (desiredType == Discriminator.class) {
                return this.discriminatorIO().readValue(node);
            }
        }
        return this.jsonIO().fromJson(node);
    }

    public XML readXML(V node) {
        return Optional.ofNullable(node).filter(this.jsonIO()::isObject).map(this.jsonIO()::asObject).map(object -> {
            XMLImpl xml = new XMLImpl();
            xml.setName(this.jsonIO().getString(node, PROP_NAME));
            xml.setNamespace(this.jsonIO().getString(node, PROP_NAMESPACE));
            xml.setPrefix(this.jsonIO().getString(node, PROP_PREFIX));
            xml.setAttribute(this.jsonIO().getBoolean(node, PROP_ATTRIBUTE));
            xml.setWrapped(this.jsonIO().getBoolean(node, PROP_WRAPPED));
            xml.setExtensions(this.extensionIO().readMap(node));
            return xml;
        }).orElse(null);
    }

    @Override
    public Optional<? extends V> write(Schema model) {
        if (model == null) {
            return Optional.empty();
        }
        if (model.getBooleanSchema() != null) {
            return this.jsonIO().toJson(model.getBooleanSchema());
        }
        SchemaImpl impl = (SchemaImpl)model;
        Map<String, Object> data = impl.getDataMap();
        return this.writeMap(data);
    }

    private Optional<? extends V> writeObject(Object value) {
        if (value instanceof Schema) {
            return this.write((Schema)value);
        }
        if (value instanceof XML) {
            return this.write((XML)value);
        }
        if (value instanceof Constructible) {
            return this.writeConstructible((Constructible)value);
        }
        if (value instanceof List) {
            return this.writeList((List)value);
        }
        if (value instanceof Map) {
            return this.writeMap((Map)value);
        }
        return this.jsonIO().toJson(value);
    }

    private Optional<? extends V> writeConstructible(Constructible value) {
        if (value instanceof ExternalDocumentation) {
            return this.extDocIO().write((ExternalDocumentation)value);
        }
        if (value instanceof Discriminator) {
            return this.discriminatorIO().write((Discriminator)value);
        }
        if (value instanceof Components) {
            return this.componentsIO().write((Components)value);
        }
        if (value instanceof OpenAPI) {
            return this.openApiDefinitionIO().write((OpenAPI)value);
        }
        if (value instanceof Operation) {
            return this.operationIO().write((Operation)value);
        }
        if (value instanceof PathItem) {
            return this.pathItemIO().write((PathItem)value);
        }
        if (value instanceof Paths) {
            return this.pathsIO().write((Paths)value);
        }
        if (value instanceof Callback) {
            return this.callbackIO().write((Callback)value);
        }
        if (value instanceof Header) {
            return this.headerIO().write((Header)value);
        }
        if (value instanceof Contact) {
            return this.contactIO().write((Contact)value);
        }
        if (value instanceof Info) {
            return this.infoIO().write((Info)value);
        }
        if (value instanceof License) {
            return this.licenseIO().write((License)value);
        }
        if (value instanceof Link) {
            return this.linkIO().write((Link)value);
        }
        if (value instanceof Content) {
            return this.contentIO().write((Content)value);
        }
        if (value instanceof Encoding) {
            return this.encodingIO().write((Encoding)value);
        }
        if (value instanceof Example) {
            return this.exampleObjectIO().write((Example)value);
        }
        if (value instanceof MediaType) {
            return this.mediaTypeIO().write((MediaType)value);
        }
        if (value instanceof Parameter) {
            return this.parameterIO().write((Parameter)value);
        }
        if (value instanceof RequestBody) {
            return this.requestBodyIO().write((RequestBody)value);
        }
        if (value instanceof APIResponse) {
            return this.apiResponseIO().write((APIResponse)value);
        }
        if (value instanceof APIResponses) {
            return this.apiResponsesIO().write((APIResponses)value);
        }
        if (value instanceof OAuthFlow) {
            return this.oauthFlowIO().write((OAuthFlow)value);
        }
        if (value instanceof OAuthFlows) {
            return this.oauthFlowsIO().write((OAuthFlows)value);
        }
        if (value instanceof SecurityRequirement) {
            return this.securityRequirementIO().write((SecurityRequirement)value);
        }
        if (value instanceof SecurityScheme) {
            return this.securitySchemeIO().write((SecurityScheme)value);
        }
        if (value instanceof Server) {
            return this.serverIO().write((Server)value);
        }
        if (value instanceof ServerVariable) {
            return this.serverVariableIO().write((ServerVariable)value);
        }
        if (value instanceof Tag) {
            return this.tagIO().write((Tag)value);
        }
        return this.jsonIO().toJson(value);
    }

    private Optional<O> writeMap(Map<?, ?> map) {
        return this.optionalJsonObject(map).map(result -> {
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("type".equals(key) && value instanceof List && ((List)value).size() == 1) {
                    value = ((List)value).get(0);
                }
                this.setIfPresent(result, key, this.writeObject(value));
            }
            return result;
        }).map(this.jsonIO()::buildObject);
    }

    private Optional<A> writeList(List<?> list) {
        return this.optionalJsonArray(list).map(result -> {
            for (Object entry : list) {
                this.writeObject(entry).ifPresent(v -> this.jsonIO().add(result, v));
            }
            return this.jsonIO().buildArray(result);
        });
    }

    @Override
    public Optional<O> write(XML model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_NAME, this.jsonIO().toJson(model.getName()));
            this.setIfPresent(node, PROP_NAMESPACE, this.jsonIO().toJson(model.getNamespace()));
            this.setIfPresent(node, PROP_PREFIX, this.jsonIO().toJson(model.getPrefix()));
            this.setIfPresent(node, PROP_ATTRIBUTE, this.jsonIO().toJson(model.getAttribute()));
            this.setIfPresent(node, PROP_WRAPPED, this.jsonIO().toJson(model.getWrapped()));
            this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

