/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.media;

import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;

public class MediaTypeIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<MediaType, V, A, O, AB, OB> {
    private static final String PROP_EXAMPLE = "example";
    private static final String PROP_EXAMPLES = "examples";
    private static final String PROP_ENCODING = "encoding";
    private static final String PROP_SCHEMA = "schema";

    public MediaTypeIO(IOContext<V, A, O, AB, OB> context) {
        super(context, null, Names.create(MediaType.class));
    }

    @Override
    public MediaType read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotationAs("@Content", "MediaType");
        MediaTypeImpl mediaType = new MediaTypeImpl();
        mediaType.setExamples(this.exampleObjectIO().readMap(annotation.value(PROP_EXAMPLES)));
        mediaType.setExample(this.exampleObjectIO().parseValue((String)this.value(annotation, PROP_EXAMPLE)));
        mediaType.setSchema((Schema)this.schemaIO().read(annotation.value(PROP_SCHEMA)));
        mediaType.setEncoding(this.encodingIO().readMap(annotation.value(PROP_ENCODING)));
        mediaType.setExtensions(this.extensionIO().readExtensible(annotation));
        return mediaType;
    }

    @Override
    public MediaType readObject(O node) {
        IoLogging.logger.singleJsonNode("Content");
        MediaTypeImpl mediaType = new MediaTypeImpl();
        mediaType.setSchema(this.schemaIO().readValue(this.jsonIO().getValue(node, PROP_SCHEMA)));
        mediaType.setExample(this.jsonIO().fromJson(this.jsonIO().getValue(node, PROP_EXAMPLE)));
        mediaType.setExamples(this.exampleObjectIO().readMap(this.jsonIO().getValue(node, PROP_EXAMPLES)));
        mediaType.setEncoding(this.encodingIO().readMap(this.jsonIO().getValue(node, PROP_ENCODING)));
        this.extensionIO().readMap(node).forEach((arg_0, arg_1) -> ((MediaType)mediaType).addExtension(arg_0, arg_1));
        return mediaType;
    }

    @Override
    public Optional<O> write(MediaType model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_SCHEMA, this.schemaIO().write(model.getSchema()));
            this.setIfPresent(node, PROP_EXAMPLE, this.jsonIO().toJson(model.getExample()));
            this.setIfPresent(node, PROP_EXAMPLES, this.exampleObjectIO().write(model.getExamples()));
            this.setIfPresent(node, PROP_ENCODING, this.encodingIO().write(model.getEncoding()));
            this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

