/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.media;

import io.smallrye.openapi.api.models.examples.ExampleImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.ReferenceType;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.jboss.jandex.AnnotationInstance;

public class ExampleObjectIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<Example, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_VALUE = "value";
    private static final String PROP_SUMMARY = "summary";
    private static final String PROP_EXTERNAL_VALUE = "externalValue";
    private static final String PROP_DESCRIPTION = "description";

    public ExampleObjectIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.EXAMPLE_OBJECT, Names.create(Example.class));
    }

    @Override
    public Example read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@ExampleObject");
        ExampleImpl example = new ExampleImpl();
        example.setRef(ReferenceType.EXAMPLE.refValue(annotation));
        example.setSummary((String)this.value(annotation, PROP_SUMMARY));
        example.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        example.setValue(this.parseValue((String)this.value(annotation, PROP_VALUE)));
        example.setExternalValue((String)this.value(annotation, PROP_EXTERNAL_VALUE));
        example.setExtensions(this.extensionIO().readExtensible(annotation));
        return example;
    }

    @Override
    public Example readObject(O node) {
        IoLogging.logger.singleJsonNode("ExampleObjectIO");
        ExampleImpl example = new ExampleImpl();
        example.setRef(this.readReference(node));
        example.setSummary(this.jsonIO().getString(node, PROP_SUMMARY));
        example.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        example.setValue(this.jsonIO().fromJson(this.jsonIO().getValue(node, PROP_VALUE)));
        example.setExternalValue(this.jsonIO().getString(node, PROP_EXTERNAL_VALUE));
        example.setExtensions(this.extensionIO().readMap(node));
        return example;
    }

    @Override
    public Optional<O> write(Example model) {
        return this.optionalJsonObject(model).map(node -> {
            if (this.isReference((Reference<?>)model)) {
                this.setReference(node, (Reference<?>)model);
                this.setIfPresent(node, PROP_SUMMARY, this.jsonIO().toJson(model.getSummary()));
                this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
            } else {
                this.setIfPresent(node, PROP_SUMMARY, this.jsonIO().toJson(model.getSummary()));
                this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
                this.setIfPresent(node, PROP_VALUE, this.jsonIO().toJson(model.getValue()));
                this.setIfPresent(node, PROP_EXTERNAL_VALUE, this.jsonIO().toJson(model.getExternalValue()));
                this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
            }
            return node;
        }).map(this.jsonIO()::buildObject);
    }

    public Object parseValue(String value) {
        Object parsedValue;
        block1: {
            AnnotationScannerExtension e;
            parsedValue = value;
            if (value == null) break block1;
            Iterator<AnnotationScannerExtension> iterator = this.scannerContext().getExtensions().iterator();
            while (iterator.hasNext() && (parsedValue = (e = iterator.next()).parseValue(value)) == null) {
            }
        }
        return parsedValue;
    }
}

