/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.links;

import io.smallrye.openapi.api.models.links.LinkImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.ReferenceType;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.jboss.jandex.AnnotationInstance;

public class LinkIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<Link, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_OPERATION_ID = "operationId";
    private static final String PROP_PARAMETERS = "parameters";
    private static final String PROP_OPERATION_REF = "operationRef";
    private static final String PROP_SERVER = "server";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_REQUEST_BODY = "requestBody";

    public LinkIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.LINK, Names.create(Link.class));
    }

    @Override
    public Link read(AnnotationInstance annotationInstance) {
        IoLogging.logger.singleAnnotation("@Link");
        LinkImpl link = new LinkImpl();
        link.setOperationRef((String)this.value(annotationInstance, PROP_OPERATION_REF));
        link.setOperationId((String)this.value(annotationInstance, PROP_OPERATION_ID));
        link.setParameters(this.linkParameterIO().readMap(annotationInstance.value(PROP_PARAMETERS)));
        link.setDescription((String)this.value(annotationInstance, PROP_DESCRIPTION));
        link.setRequestBody(this.value(annotationInstance, PROP_REQUEST_BODY));
        link.setServer((Server)this.serverIO().read(annotationInstance.value(PROP_SERVER)));
        link.setRef(ReferenceType.LINK.refValue(annotationInstance));
        link.setExtensions(this.extensionIO().readExtensible(annotationInstance));
        return link;
    }

    @Override
    public Link readObject(O node) {
        IoLogging.logger.singleJsonNode("Link");
        LinkImpl link = new LinkImpl();
        link.setRef(this.readReference(node));
        link.setOperationRef(this.jsonIO().getString(node, PROP_OPERATION_REF));
        link.setOperationId(this.jsonIO().getString(node, PROP_OPERATION_ID));
        link.setParameters(this.linkParameterIO().readMap(this.jsonIO().getValue(node, PROP_PARAMETERS)));
        link.setRequestBody(this.jsonIO().fromJson(this.jsonIO().getValue(node, PROP_REQUEST_BODY)));
        link.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        link.setServer((Server)this.serverIO().readValue(this.jsonIO().getValue(node, PROP_SERVER)));
        this.extensionIO().readMap(node).forEach((arg_0, arg_1) -> ((Link)link).addExtension(arg_0, arg_1));
        return link;
    }

    @Override
    public Optional<O> write(Link model) {
        return this.optionalJsonObject(model).map(node -> {
            if (this.isReference((Reference<?>)model)) {
                this.setReference(node, (Reference<?>)model);
                this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
            } else {
                this.setIfPresent(node, PROP_OPERATION_REF, this.jsonIO().toJson(model.getOperationRef()));
                this.setIfPresent(node, PROP_OPERATION_ID, this.jsonIO().toJson(model.getOperationId()));
                this.setIfPresent(node, PROP_PARAMETERS, this.linkParameterIO().write(model.getParameters()));
                this.setIfPresent(node, PROP_REQUEST_BODY, this.jsonIO().toJson(model.getRequestBody()));
                this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
                this.setIfPresent(node, PROP_SERVER, this.serverIO().write(model.getServer()));
                this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
            }
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

