/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.info;

import io.smallrye.openapi.api.models.info.ContactImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.jboss.jandex.AnnotationInstance;

public class ContactIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<Contact, V, A, O, AB, OB> {
    private static final String PROP_NAME = "name";
    private static final String PROP_EMAIL = "email";
    private static final String PROP_URL = "url";

    public ContactIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.CONTACT, Names.create(Contact.class));
    }

    @Override
    public Contact read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@Contact");
        ContactImpl contact = new ContactImpl();
        contact.setName((String)this.value(annotation, PROP_NAME));
        contact.setUrl((String)this.value(annotation, PROP_URL));
        contact.setEmail((String)this.value(annotation, PROP_EMAIL));
        contact.setExtensions(this.extensionIO().readExtensible(annotation));
        return contact;
    }

    @Override
    public Contact readObject(O node) {
        IoLogging.logger.singleJsonNode("Contact");
        ContactImpl contact = new ContactImpl();
        contact.setName(this.jsonIO().getString(node, PROP_NAME));
        contact.setUrl(this.jsonIO().getString(node, PROP_URL));
        contact.setEmail(this.jsonIO().getString(node, PROP_EMAIL));
        this.extensionIO().readMap(node).forEach((arg_0, arg_1) -> ((Contact)contact).addExtension(arg_0, arg_1));
        return contact;
    }

    @Override
    public Optional<O> write(Contact model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_NAME, this.jsonIO().toJson(model.getName()));
            this.setIfPresent(node, PROP_URL, this.jsonIO().toJson(model.getUrl()));
            this.setIfPresent(node, PROP_EMAIL, this.jsonIO().toJson(model.getEmail()));
            this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

