/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.OperationIO;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.ReferenceType;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Reference;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class PathItemIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<PathItem, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_PARAMETERS = "parameters";
    private static final String PROP_SERVERS = "servers";
    private static final String PROP_SUMMARY = "summary";
    private static final Set<String> OPERATION_PROPS = Arrays.asList(PathItem.HttpMethod.values()).stream().map(Enum::toString).map(String::toLowerCase).collect(Collectors.toSet());
    private static final String PROP_OPERATIONS = "operations";

    public PathItemIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.PATH_ITEM, Names.create(PathItem.class));
    }

    @Override
    public PathItem read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@PathItem");
        PathItemImpl pathItem = new PathItemImpl();
        pathItem.setRef(ReferenceType.PATH_ITEM.refValue(annotation));
        pathItem.setDescription((String)this.value(annotation, PROP_DESCRIPTION));
        pathItem.setSummary((String)this.value(annotation, PROP_SUMMARY));
        pathItem.setServers(this.serverIO().readList(annotation.value(PROP_SERVERS)));
        pathItem.setParameters(this.parameterIO().readList(annotation.value(PROP_PARAMETERS)));
        Optional.ofNullable(annotation.value(PROP_OPERATIONS)).map(AnnotationValue::asNestedArray).ifPresent(annotations -> this.readOperationsInto(pathItem, (AnnotationInstance[])annotations, this.pathItemOperationIO()));
        pathItem.setExtensions(this.extensionIO().readExtensible(annotation));
        return pathItem;
    }

    public PathItem readCallbackOperations(AnnotationInstance[] annotations) {
        PathItemImpl pathItem = new PathItemImpl();
        this.readOperationsInto(pathItem, annotations, this.callbackOperationIO());
        return pathItem;
    }

    private void readOperationsInto(PathItem pathItem, AnnotationInstance[] annotations, OperationIO<V, A, O, AB, OB> operationIO) {
        Arrays.stream(annotations).filter(annotation -> Objects.nonNull(this.value((AnnotationInstance)annotation, "method"))).forEach(annotation -> {
            String method = (String)this.value((AnnotationInstance)annotation, "method");
            Operation operation = operationIO.read((AnnotationInstance)annotation);
            operation.setExtensions(this.extensionIO().readExtensible((AnnotationInstance)annotation));
            pathItem.setOperation(PathItem.HttpMethod.valueOf((String)method.toUpperCase(Locale.ROOT)), operation);
        });
    }

    @Override
    public PathItem readObject(O node) {
        IoLogging.logger.singleJsonNode("PathItem");
        PathItemImpl pathItem = new PathItemImpl();
        pathItem.setRef(this.readReference(node));
        pathItem.setSummary(this.jsonIO().getString(node, PROP_SUMMARY));
        pathItem.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        this.jsonIO().properties(node).stream().filter(entry -> OPERATION_PROPS.contains(entry.getKey())).forEach(entry -> {
            PathItem.HttpMethod method = PathItem.HttpMethod.valueOf((String)((String)entry.getKey()).toUpperCase(Locale.ROOT));
            Operation operation = (Operation)this.operationIO().readValue(entry.getValue());
            pathItem.setOperation(method, operation);
        });
        pathItem.setParameters(this.parameterIO().readList(this.jsonIO().getValue(node, PROP_PARAMETERS)));
        pathItem.setServers(this.serverIO().readList(this.jsonIO().getValue(node, PROP_SERVERS)));
        pathItem.setExtensions(this.extensionIO().readObjectMap(node));
        return pathItem;
    }

    @Override
    public Optional<O> write(PathItem model) {
        return this.optionalJsonObject(model).map(node -> this.write(model, node)).map(this.jsonIO()::buildObject);
    }

    private OB write(PathItem model, OB node) {
        this.setReference(node, (Reference<?>)model);
        this.setIfPresent(node, PROP_SUMMARY, this.jsonIO().toJson(model.getSummary()));
        this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
        model.getOperations().forEach((method, operation) -> this.setIfPresent(node, method.name().toLowerCase(), this.operationIO().write((Operation)operation)));
        this.setIfPresent(node, PROP_PARAMETERS, this.parameterIO().write(model.getParameters()));
        this.setIfPresent(node, PROP_SERVERS, this.serverIO().write(model.getServers()));
        this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
        return node;
    }
}

