/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.jboss.jandex.AnnotationInstance;

public class OpenAPIDefinitionIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<OpenAPI, V, A, O, AB, OB> {
    public static final String PROP_COMPONENTS = "components";
    public static final String PROP_EXTERNAL_DOCS = "externalDocs";
    public static final String PROP_INFO = "info";
    public static final String PROP_OPENAPI = "openapi";
    public static final String PROP_PATHS = "paths";
    public static final String PROP_SECURITY = "security";
    public static final String PROP_SECURITY_SETS = "securitySets";
    public static final String PROP_SERVERS = "servers";
    public static final String PROP_TAGS = "tags";
    public static final String PROP_WEBHOOKS = "webhooks";

    public OpenAPIDefinitionIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.OPENAPI_DEFINITION, Names.create(OpenAPI.class));
    }

    @Override
    public OpenAPI read(AnnotationInstance annotation) {
        IoLogging.logger.annotation("@OpenAPIDefinition");
        OpenAPIImpl openApi = new OpenAPIImpl();
        openApi.setOpenapi("3.1.0");
        openApi.setInfo((Info)this.infoIO().read(annotation.value(PROP_INFO)));
        openApi.setTags(this.tagIO().readList(annotation.value(PROP_TAGS)));
        openApi.setServers(this.serverIO().readList(annotation.value(PROP_SERVERS)));
        openApi.setSecurity(this.securityIO().readRequirements(annotation.value(PROP_SECURITY), annotation.value(PROP_SECURITY_SETS)));
        openApi.setExternalDocs((ExternalDocumentation)this.extDocIO().read(annotation.value(PROP_EXTERNAL_DOCS)));
        openApi.setWebhooks(this.pathItemIO().readMap(annotation.value(PROP_WEBHOOKS)));
        openApi.setComponents((Components)this.componentsIO().read(annotation.value(PROP_COMPONENTS)));
        openApi.setExtensions(this.extensionIO().readExtensible(annotation));
        return openApi;
    }

    @Override
    public OpenAPI readObject(O node) {
        IoLogging.logger.jsonNode("OpenAPIDefinition");
        OpenAPIImpl openApi = new OpenAPIImpl();
        openApi.setOpenapi(this.jsonIO().getString(node, PROP_OPENAPI));
        openApi.setInfo((Info)this.infoIO().readValue(this.jsonIO().getValue(node, PROP_INFO)));
        openApi.setTags(this.tagIO().readList(this.jsonIO().getValue(node, PROP_TAGS)));
        openApi.setServers(this.serverIO().readList(this.jsonIO().getValue(node, PROP_SERVERS)));
        openApi.setSecurity(this.securityIO().readRequirements(this.jsonIO().getValue(node, PROP_SECURITY)));
        openApi.setExternalDocs((ExternalDocumentation)this.extDocIO().readValue(this.jsonIO().getValue(node, PROP_EXTERNAL_DOCS)));
        openApi.setComponents((Components)this.componentsIO().readValue(this.jsonIO().getValue(node, PROP_COMPONENTS)));
        openApi.setPaths((Paths)this.pathsIO().readValue(this.jsonIO().getValue(node, PROP_PATHS)));
        openApi.setWebhooks(this.pathItemIO().readMap(this.jsonIO().getValue(node, PROP_WEBHOOKS)));
        openApi.setExtensions(this.extensionIO().readMap(node));
        return openApi;
    }

    @Override
    public Optional<O> write(OpenAPI model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_OPENAPI, this.jsonIO().toJson(model.getOpenapi()));
            this.setIfPresent(node, PROP_INFO, this.infoIO().write(model.getInfo()));
            this.setIfPresent(node, PROP_EXTERNAL_DOCS, this.extDocIO().write(model.getExternalDocs()));
            this.setIfPresent(node, PROP_SERVERS, this.serverIO().write(model.getServers()));
            this.setIfPresent(node, PROP_SECURITY, this.securityIO().write(model.getSecurity()));
            this.setIfPresent(node, PROP_TAGS, this.tagIO().write(model.getTags()));
            this.setIfPresent(node, PROP_PATHS, this.pathsIO().write(model.getPaths()));
            this.setIfPresent(node, PROP_WEBHOOKS, this.pathItemIO().write(model.getWebhooks()));
            this.setIfPresent(node, PROP_COMPONENTS, this.componentsIO().write(model.getComponents()));
            this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

