/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.JsonIO;
import io.xlate.yamljson.Yaml;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;

class JakartaJsonIO
implements JsonIO<JsonValue, JsonArray, JsonObject, JsonArrayBuilder, JsonObjectBuilder> {
    private final OpenApiConfig config;
    private final JsonProvider json;
    private final JsonReaderFactory jsonReaderFactory;
    private final JsonWriterFactory jsonWriterFactory;
    private final JsonReaderFactory yamlReaderFactory;
    private final JsonWriterFactory yamlWriterFactory;

    public JakartaJsonIO(OpenApiConfig config, JsonProvider jsonProvider, JsonProvider yamlProvider) {
        this.config = config;
        this.json = jsonProvider;
        this.jsonReaderFactory = jsonProvider.createReaderFactory(Collections.emptyMap());
        this.jsonWriterFactory = jsonProvider.createWriterFactory(Collections.emptyMap());
        LoaderOptions loaderOptions = new LoaderOptions();
        Optional.ofNullable(this.config.getMaximumStaticFileSize()).ifPresent(arg_0 -> ((LoaderOptions)loaderOptions).setCodePointLimit(arg_0));
        HashMap<String, LoaderOptions> yamlReaderConfig = new HashMap<String, LoaderOptions>();
        yamlReaderConfig.put("io.xlate.yamljson.LOAD_CONFIG", loaderOptions);
        this.yamlReaderFactory = yamlProvider.createReaderFactory(yamlReaderConfig);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setMaxSimpleKeyLength(1024);
        HashMap<String, Object> yamlWriterConfig = new HashMap<String, Object>();
        yamlWriterConfig.put("io.xlate.yamljson.DUMP_CONFIG", dumperOptions);
        yamlWriterConfig.put("io.xlate.yamljson.DUMP_MINIMIZE_QUOTES", true);
        this.yamlWriterFactory = yamlProvider.createWriterFactory(yamlWriterConfig);
    }

    public JakartaJsonIO(OpenApiConfig config) {
        this(config, JsonProvider.provider(), Yaml.provider());
    }

    public JakartaJsonIO() {
        this(OpenApiConfig.fromConfig(ConfigProvider.getConfig()), JsonProvider.provider(), Yaml.provider());
    }

    @Override
    public boolean isArray(JsonValue value) {
        return value instanceof JsonArray;
    }

    @Override
    public JsonArray asArray(JsonValue value) {
        return (JsonArray)value;
    }

    @Override
    public List<JsonValue> entries(JsonArray array) {
        return array;
    }

    @Override
    public boolean isObject(JsonValue value) {
        return value instanceof JsonObject;
    }

    @Override
    public JsonObject asObject(JsonValue value) {
        return (JsonObject)value;
    }

    @Override
    public boolean isBoolean(JsonValue value) {
        if (value == null) {
            return false;
        }
        JsonValue.ValueType type = value.getValueType();
        return type == JsonValue.ValueType.TRUE || type == JsonValue.ValueType.FALSE;
    }

    @Override
    public Boolean asBoolean(JsonValue value) {
        JsonValue.ValueType type = value.getValueType();
        if (type == JsonValue.ValueType.TRUE) {
            return Boolean.TRUE;
        }
        if (type == JsonValue.ValueType.FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean hasKey(JsonObject object, String key) {
        return object.containsKey((Object)key);
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> properties(JsonObject object) {
        return object.entrySet();
    }

    @Override
    public boolean isString(JsonValue value) {
        return value != null && value.getValueType() == JsonValue.ValueType.STRING;
    }

    @Override
    public String asString(JsonValue value) {
        if (value == null) {
            return null;
        }
        switch (value.getValueType()) {
            case ARRAY: 
            case OBJECT: 
            case NULL: {
                return null;
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
        }
        return value.toString();
    }

    @Override
    public Integer getJsonInt(JsonObject object, String key) {
        JsonValue value = (JsonValue)object.get((Object)key);
        return value != null && value.getValueType() == JsonValue.ValueType.NUMBER ? Integer.valueOf(((JsonNumber)value).intValue()) : null;
    }

    @Override
    public String getJsonString(JsonObject object, String key) {
        return this.asString((JsonValue)object.get((Object)key));
    }

    @Override
    public Boolean getJsonBoolean(JsonObject object, String key) {
        JsonValue value = (JsonValue)object.get((Object)key);
        if (value == null) {
            return null;
        }
        switch (value.getValueType()) {
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public BigDecimal getJsonBigDecimal(JsonObject object, String key) {
        JsonValue value = (JsonValue)object.get((Object)key);
        return value != null && value.getValueType() == JsonValue.ValueType.NUMBER ? ((JsonNumber)value).bigDecimalValue() : null;
    }

    @Override
    public JsonValue getValue(JsonObject object, String key) {
        return (JsonValue)object.get((Object)key);
    }

    @Override
    public Optional<JsonArray> getArray(JsonObject object, String key) {
        JsonValue value = (JsonValue)object.get((Object)key);
        return value != null && value.getValueType() == JsonValue.ValueType.ARRAY ? Optional.of(value.asJsonArray()) : Optional.empty();
    }

    @Override
    public Optional<JsonObject> getObject(JsonObject object, String key) {
        JsonValue value = (JsonValue)object.get((Object)key);
        return value != null && value.getValueType() == JsonValue.ValueType.OBJECT ? Optional.of(value.asJsonObject()) : Optional.empty();
    }

    @Override
    public JsonValue toJson(Object value, JsonValue defaultValue) {
        if (value instanceof String) {
            return this.json.createValue((String)value);
        }
        if (value instanceof JsonValue) {
            return (JsonValue)value;
        }
        if (value instanceof BigDecimal) {
            return this.json.createValue((BigDecimal)value);
        }
        if (value instanceof BigInteger) {
            return this.json.createValue((BigInteger)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (value instanceof Double) {
            return this.json.createValue((Number)((Double)value));
        }
        if (value instanceof Float) {
            return this.json.createValue((Number)((Float)value));
        }
        if (value instanceof Short) {
            return this.json.createValue((int)((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return this.json.createValue((Number)((Integer)value));
        }
        if (value instanceof Long) {
            return this.json.createValue((Number)((Long)value));
        }
        if (value instanceof Character) {
            return this.json.createValue(((Character)value).toString());
        }
        if (value instanceof List) {
            JsonArrayBuilder array = this.createArray();
            ((List)value).stream().map(v -> this.toJson(v, JsonValue.NULL)).forEach(arg_0 -> ((JsonArrayBuilder)array).add(arg_0));
            return array.build();
        }
        if (value instanceof Map) {
            JsonObjectBuilder object = this.createObject();
            ((Map)value).forEach((key, obj) -> object.add(String.valueOf(key), this.toJson(obj, JsonValue.NULL)));
            return object.build();
        }
        if (value instanceof Enum) {
            return this.json.createValue(value.toString());
        }
        return defaultValue;
    }

    @Override
    public Object fromJson(JsonValue value) {
        if (value == null || value == JsonValue.NULL) {
            return null;
        }
        switch (value.getValueType()) {
            case NULL: {
                return null;
            }
            case NUMBER: {
                return ((JsonNumber)value).numberValue();
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case ARRAY: {
                ArrayList items = new ArrayList();
                value.asJsonArray().forEach(entry -> items.add(this.fromJson((JsonValue)entry)));
                return items;
            }
            case OBJECT: {
                LinkedHashMap items = new LinkedHashMap();
                value.asJsonObject().forEach((key, property) -> items.put(key, this.fromJson((JsonValue)property)));
                return items;
            }
        }
        return null;
    }

    @Override
    public <T> T fromJson(JsonValue object, Class<T> desiredType) {
        JsonValue.ValueType type = object.getValueType();
        if (desiredType == String.class) {
            if (type == JsonValue.ValueType.STRING) {
                return (T)((JsonString)object).getString();
            }
            if (type == JsonValue.ValueType.NUMBER) {
                return (T)((JsonNumber)object).numberValue().toString();
            }
            if (type == JsonValue.ValueType.TRUE) {
                return (T)"true";
            }
            if (type == JsonValue.ValueType.FALSE) {
                return (T)"false";
            }
        }
        if (type == JsonValue.ValueType.NUMBER) {
            JsonNumber number = (JsonNumber)object;
            try {
                if (desiredType == Integer.class) {
                    return (T)Integer.valueOf(number.intValueExact());
                }
                if (desiredType == Long.class) {
                    return (T)Long.valueOf(number.longValueExact());
                }
                if (desiredType == BigInteger.class) {
                    return (T)number.bigIntegerValueExact();
                }
                if (desiredType == BigDecimal.class) {
                    return (T)number.bigDecimalValue();
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        if (desiredType == Boolean.class) {
            if (type == JsonValue.ValueType.TRUE) {
                return (T)Boolean.TRUE;
            }
            if (type == JsonValue.ValueType.FALSE) {
                return (T)Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public String toString(JsonValue value, Format format) {
        StringWriter output = new StringWriter();
        try (JsonWriter writer = format == Format.JSON ? this.jsonWriterFactory.createWriter((Writer)output) : this.yamlWriterFactory.createWriter((Writer)output);){
            writer.write(value);
        }
        catch (JsonException e) {
            throw new OpenApiRuntimeException("Failed to read " + (Object)((Object)format) + " stream", e);
        }
        return ((Object)output).toString();
    }

    @Override
    public JsonValue fromReader(Reader reader, Format format) {
        JsonValue jsonValue;
        block8: {
            JsonReader jsonReader = format == Format.JSON ? this.jsonReaderFactory.createReader(reader) : this.yamlReaderFactory.createReader(reader);
            try {
                jsonValue = jsonReader.readValue();
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException e) {
                    throw new OpenApiRuntimeException("Failed to read " + (Object)((Object)format) + " stream", e);
                }
            }
            jsonReader.close();
        }
        return jsonValue;
    }

    @Override
    public JsonArrayBuilder createArray() {
        return this.json.createArrayBuilder();
    }

    @Override
    public void add(JsonArrayBuilder array, JsonValue value) {
        array.add(value);
    }

    @Override
    public JsonArray buildArray(JsonArrayBuilder array) {
        return array.build();
    }

    @Override
    public JsonObjectBuilder createObject() {
        return this.json.createObjectBuilder();
    }

    @Override
    public void set(JsonObjectBuilder object, String key, JsonValue value) {
        object.add(key, value);
    }

    @Override
    public void setAll(JsonObjectBuilder object, JsonObject valueSource) {
        valueSource.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)object).add(arg_0, arg_1));
    }

    @Override
    public JsonObject buildObject(JsonObjectBuilder object) {
        return object.build();
    }
}

