/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.callbacks.CallbackIO;
import io.smallrye.openapi.runtime.io.security.SecuritySchemeIO;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.jboss.jandex.AnnotationInstance;

public class ComponentsIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<Components, V, A, O, AB, OB> {
    private static final String PROP_CALLBACKS = "callbacks";
    private static final String PROP_LINKS = "links";
    private static final String PROP_SECURITY_SCHEMES = "securitySchemes";
    private static final String PROP_HEADERS = "headers";
    private static final String PROP_REQUEST_BODIES = "requestBodies";
    private static final String PROP_EXAMPLES = "examples";
    private static final String PROP_PARAMETERS = "parameters";
    private static final String PROP_RESPONSES = "responses";
    private static final String PROP_SCHEMAS = "schemas";
    private static final String PROP_PATH_ITEMS = "pathItems";

    public ComponentsIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.COMPONENTS, Names.create(Components.class));
    }

    public CallbackIO<V, A, O, AB, OB> callbacks() {
        return this.callbackIO();
    }

    public SecuritySchemeIO<V, A, O, AB, OB> securitySchemes() {
        return this.securitySchemeIO();
    }

    @Override
    public Components read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@Components");
        ComponentsImpl components = new ComponentsImpl();
        components.setCallbacks(this.callbackIO().readMap(annotation.value(PROP_CALLBACKS)));
        components.setExamples(this.exampleObjectIO().readMap(annotation.value(PROP_EXAMPLES)));
        components.setHeaders(this.headerIO().readMap(annotation.value(PROP_HEADERS)));
        components.setLinks(this.linkIO().readMap(annotation.value(PROP_LINKS)));
        components.setParameters(this.parameterIO().readMap(annotation.value(PROP_PARAMETERS)));
        components.setPathItems(this.pathItemIO().readMap(annotation.value(PROP_PATH_ITEMS)));
        components.setRequestBodies(this.requestBodyIO().readMap(annotation.value(PROP_REQUEST_BODIES)));
        components.setResponses(this.apiResponseIO().readMap(annotation.value(PROP_RESPONSES)));
        components.setSchemas(this.schemaIO().readMap(annotation.value(PROP_SCHEMAS)));
        components.setSecuritySchemes(this.securitySchemeIO().readMap(annotation.value(PROP_SECURITY_SCHEMES)));
        components.setExtensions(this.extensionIO().readExtensible(annotation));
        return components;
    }

    @Override
    public Components readObject(O node) {
        IoLogging.logger.singleJsonNode("Components");
        ComponentsImpl components = new ComponentsImpl();
        components.setCallbacks(this.callbackIO().readMap(this.jsonIO().getValue(node, PROP_CALLBACKS)));
        components.setExamples(this.exampleObjectIO().readMap(this.jsonIO().getValue(node, PROP_EXAMPLES)));
        components.setHeaders(this.headerIO().readMap(this.jsonIO().getValue(node, PROP_HEADERS)));
        components.setLinks(this.linkIO().readMap(this.jsonIO().getValue(node, PROP_LINKS)));
        components.setParameters(this.parameterIO().readMap(this.jsonIO().getValue(node, PROP_PARAMETERS)));
        components.setRequestBodies(this.requestBodyIO().readMap(this.jsonIO().getValue(node, PROP_REQUEST_BODIES)));
        components.setResponses(this.apiResponseIO().readMap(this.jsonIO().getValue(node, PROP_RESPONSES)));
        components.setSchemas(this.schemaIO().readMap(this.jsonIO().getValue(node, PROP_SCHEMAS)));
        components.setSecuritySchemes(this.securitySchemeIO().readMap(this.jsonIO().getValue(node, PROP_SECURITY_SCHEMES)));
        components.setPathItems(this.pathItemIO().readMap(this.jsonIO().getValue(node, PROP_PATH_ITEMS)));
        components.setExtensions(this.extensionIO().readMap(node));
        return components;
    }

    @Override
    public Optional<O> write(Components model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_SCHEMAS, this.schemaIO().write(model.getSchemas()));
            this.setIfPresent(node, PROP_RESPONSES, this.apiResponseIO().write(model.getResponses()));
            this.setIfPresent(node, PROP_PARAMETERS, this.parameterIO().write(model.getParameters()));
            this.setIfPresent(node, PROP_EXAMPLES, this.exampleObjectIO().write(model.getExamples()));
            this.setIfPresent(node, PROP_REQUEST_BODIES, this.requestBodyIO().write(model.getRequestBodies()));
            this.setIfPresent(node, PROP_HEADERS, this.headerIO().write(model.getHeaders()));
            this.setIfPresent(node, PROP_SECURITY_SCHEMES, this.securitySchemeIO().write(model.getSecuritySchemes()));
            this.setIfPresent(node, PROP_LINKS, this.linkIO().write(model.getLinks()));
            this.setIfPresent(node, PROP_CALLBACKS, this.callbackIO().write(model.getCallbacks()));
            this.setIfPresent(node, PROP_PATH_ITEMS, this.pathItemIO().write(model.getPathItems()));
            this.setAllIfPresent(node, this.extensionIO().write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

