/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models.media;

import io.smallrye.openapi.api.models.ExternalDocumentationImpl;
import io.smallrye.openapi.api.models.MapBasedModelImpl;
import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.api.models.media.DiscriminatorImpl;
import io.smallrye.openapi.api.models.media.XMLImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.ReferenceType;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;

public class SchemaImpl
extends MapBasedModelImpl
implements Schema,
ModelImpl {
    private static final Set<String> NON_MERGABLE_PROPERTIES = Collections.singleton("examples");
    private String name;
    private int modCount;
    private List<Schema> typeObservers;
    private Boolean nullable = null;
    private boolean explicitSetExtensions = false;
    private Boolean booleanValue;

    @Override
    protected Set<String> getNonMergableCollections() {
        return NON_MERGABLE_PROPERTIES;
    }

    @Override
    public MapBasedModelImpl mergeFrom(MapBasedModelImpl other) {
        MapBasedModelImpl otherSchema = null;
        if (this.isBooleanSchema()) {
            return other;
        }
        if (other instanceof SchemaImpl && ((SchemaImpl)other).isBooleanSchema()) {
            return otherSchema;
        }
        return super.mergeFrom(other);
    }

    public static boolean isNamed(Schema schema) {
        return schema instanceof SchemaImpl && ((SchemaImpl)schema).name != null;
    }

    public static int getModCount(Schema schema) {
        return schema instanceof SchemaImpl ? ((SchemaImpl)schema).modCount : -1;
    }

    public static void addTypeObserver(Schema observable, Schema observer) {
        if (observable instanceof SchemaImpl) {
            SchemaImpl obs = (SchemaImpl)observable;
            obs.typeObservers = ModelUtil.add(observer, obs.typeObservers, ArrayList::new);
        }
        SchemaImpl.setTypeRetainingNull(observer, observable.getType());
    }

    public static SchemaImpl copyOf(Schema other) {
        if (other == null) {
            return new SchemaImpl();
        }
        if (other instanceof SchemaImpl) {
            SchemaImpl otherImpl = (SchemaImpl)other;
            SchemaImpl result = new SchemaImpl();
            result.data.putAll(SchemaImpl.copyOf(otherImpl.data));
            return result;
        }
        throw new UnsupportedOperationException("Can't copy a different impl");
    }

    public static void clear(Schema schema) {
        SchemaImpl impl = (SchemaImpl)schema;
        impl.data.clear();
        impl.booleanValue = null;
    }

    private static <K, V> Map<K, V> copyOf(Map<K, V> map) {
        HashMap<K, V> clone = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V val = entry.getValue();
            clone.put(key, SchemaImpl.copyOf(val));
        }
        return clone;
    }

    private static <T> List<T> copyOf(List<T> list) {
        ArrayList<T> clone = new ArrayList<T>();
        for (T value : list) {
            clone.add(SchemaImpl.copyOf(value));
        }
        return clone;
    }

    private static <T> T copyOf(T value) {
        if (value instanceof Map) {
            return (T)SchemaImpl.copyOf((Map)value);
        }
        if (value instanceof List) {
            return (T)SchemaImpl.copyOf((List)value);
        }
        if (value instanceof Schema) {
            return (T)SchemaImpl.copyOf((Schema)value);
        }
        if (value instanceof XML) {
            return (T)MergeUtil.mergeObjects(new XMLImpl(), (XML)value);
        }
        if (value instanceof ExternalDocumentation) {
            return (T)MergeUtil.mergeObjects(new ExternalDocumentationImpl(), (ExternalDocumentation)value);
        }
        if (value instanceof Discriminator) {
            return (T)MergeUtil.mergeObjects(new DiscriminatorImpl(), (Discriminator)value);
        }
        return value;
    }

    public SchemaImpl(String name) {
        this.name = name;
    }

    public SchemaImpl() {
        this(null);
    }

    public String getName() {
        return this.name;
    }

    private void incrementModCount() {
        ++this.modCount;
    }

    public static void setType(Schema schema, Schema.SchemaType type) {
        if (!(schema instanceof SchemaImpl)) {
            return;
        }
        SchemaImpl s = (SchemaImpl)schema;
        List currentValue = s.getListProperty("type");
        if (currentValue != null && currentValue.contains(Schema.SchemaType.NULL)) {
            if (type == null) {
                s.setListProperty("type", Arrays.asList(Schema.SchemaType.NULL));
            } else {
                s.setListProperty("type", Arrays.asList(type, Schema.SchemaType.NULL));
            }
        } else if (type == null) {
            s.setListProperty("type", null);
        } else {
            s.setListProperty("type", Collections.singletonList(type));
        }
        if (s.typeObservers != null) {
            s.typeObservers.forEach(o -> SchemaImpl.setType(o, type));
        }
    }

    public static Boolean getNullable(Schema schema) {
        List types = schema.getType();
        if (!(schema instanceof SchemaImpl)) {
            return types != null && types.contains(Schema.SchemaType.NULL);
        }
        SchemaImpl s = (SchemaImpl)schema;
        if (types != null) {
            boolean nullPermitted = types.contains(Schema.SchemaType.NULL);
            if (!nullPermitted && s.nullable == null) {
                return null;
            }
            return nullPermitted;
        }
        return s.nullable;
    }

    public static void setNullable(Schema schema, Boolean nullable) {
        if (!(schema instanceof SchemaImpl)) {
            return;
        }
        SchemaImpl s = (SchemaImpl)schema;
        s.incrementModCount();
        s.nullable = nullable;
        if (nullable == Boolean.TRUE) {
            List<Schema.SchemaType> types = s.getType();
            if (types == null || !types.contains(Schema.SchemaType.NULL)) {
                s.addType(Schema.SchemaType.NULL);
            }
        } else {
            s.removeType(Schema.SchemaType.NULL);
        }
    }

    public String getRef() {
        return this.getProperty("$ref", String.class);
    }

    public void setRef(String ref) {
        if (ref != null && !ref.contains("/")) {
            ref = ReferenceType.SCHEMA.referenceOf(ref);
        }
        this.setProperty("$ref", ref);
    }

    public Discriminator getDiscriminator() {
        return this.getProperty("discriminator", Discriminator.class);
    }

    public void setDiscriminator(Discriminator discriminator) {
        this.setProperty("discriminator", discriminator);
    }

    public String getTitle() {
        return this.getProperty("title", String.class);
    }

    public void setTitle(String title) {
        this.setProperty("title", title);
    }

    public Object getDefaultValue() {
        return this.getProperty("default", Object.class);
    }

    public void setDefaultValue(Object defaultValue) {
        this.setProperty("default", defaultValue);
    }

    public List<Object> getEnumeration() {
        return this.getListProperty("enum");
    }

    public void setEnumeration(List<Object> enumeration) {
        this.setListProperty("enum", enumeration);
    }

    public Schema addEnumeration(Object enumeration) {
        this.addToListProperty("enum", enumeration);
        return this;
    }

    public void removeEnumeration(Object enumeration) {
        this.removeFromListProperty("enum", enumeration);
    }

    public BigDecimal getMultipleOf() {
        return this.getProperty("multipleOf", BigDecimal.class);
    }

    public void setMultipleOf(BigDecimal multipleOf) {
        this.setProperty("multipleOf", multipleOf);
    }

    public BigDecimal getMaximum() {
        return this.getProperty("maximum", BigDecimal.class);
    }

    public void setMaximum(BigDecimal maximum) {
        this.setProperty("maximum", maximum);
    }

    public BigDecimal getExclusiveMaximum() {
        return this.getProperty("exclusiveMaximum", BigDecimal.class);
    }

    public void setExclusiveMaximum(BigDecimal exclusiveMaximum) {
        this.setProperty("exclusiveMaximum", exclusiveMaximum);
    }

    public BigDecimal getMinimum() {
        return this.getProperty("minimum", BigDecimal.class);
    }

    public void setMinimum(BigDecimal minimum) {
        this.setProperty("minimum", minimum);
    }

    public BigDecimal getExclusiveMinimum() {
        return this.getProperty("exclusiveMinimum", BigDecimal.class);
    }

    public void setExclusiveMinimum(BigDecimal exclusiveMinimum) {
        this.setProperty("exclusiveMinimum", exclusiveMinimum);
    }

    public Integer getMaxLength() {
        return this.getProperty("maxLength", Integer.class);
    }

    public void setMaxLength(Integer maxLength) {
        this.setProperty("maxLength", maxLength);
    }

    public Integer getMinLength() {
        return this.getProperty("minLength", Integer.class);
    }

    public void setMinLength(Integer minLength) {
        this.setProperty("minLength", minLength);
    }

    public String getPattern() {
        return this.getProperty("pattern", String.class);
    }

    public void setPattern(String pattern) {
        this.setProperty("pattern", pattern);
    }

    public Integer getMaxItems() {
        return this.getProperty("maxItems", Integer.class);
    }

    public void setMaxItems(Integer maxItems) {
        this.setProperty("maxItems", maxItems);
    }

    public Integer getMinItems() {
        return this.getProperty("minItems", Integer.class);
    }

    public void setMinItems(Integer minItems) {
        this.setProperty("minItems", minItems);
    }

    public Boolean getUniqueItems() {
        return this.getProperty("uniqueItems", Boolean.class);
    }

    public void setUniqueItems(Boolean uniqueItems) {
        this.setProperty("uniqueItems", uniqueItems);
    }

    public Integer getMaxProperties() {
        return this.getProperty("maxProperties", Integer.class);
    }

    public void setMaxProperties(Integer maxProperties) {
        this.setProperty("maxProperties", maxProperties);
    }

    public Integer getMinProperties() {
        return this.getProperty("minProperties", Integer.class);
    }

    public void setMinProperties(Integer minProperties) {
        this.setProperty("minProperties", minProperties);
    }

    public List<String> getRequired() {
        return this.getListProperty("required");
    }

    public void setRequired(List<String> required) {
        this.setListProperty("required", required);
    }

    public Schema addRequired(String required) {
        this.addToListProperty("required", required);
        return this;
    }

    public void removeRequired(String required) {
        this.removeFromListProperty("required", required);
    }

    public List<Schema.SchemaType> getType() {
        List<Schema.SchemaType> resultList = this.getListProperty("type");
        if (resultList != null) {
            return resultList;
        }
        Schema.SchemaType result = this.getProperty("type", Schema.SchemaType.class);
        if (result != null) {
            return Collections.singletonList(result);
        }
        return null;
    }

    public void setType(List<Schema.SchemaType> types) {
        this.nullable = null;
        this.setListProperty("type", types);
        if (this.typeObservers != null) {
            this.typeObservers.forEach(o -> SchemaImpl.setTypeRetainingNull(o, types));
        }
    }

    private static void setTypeRetainingNull(Schema target, List<Schema.SchemaType> types) {
        List oldTypes = target.getType();
        if (oldTypes != null && types != null && oldTypes.contains(Schema.SchemaType.NULL) && !types.contains(Schema.SchemaType.NULL)) {
            types = new ArrayList<Schema.SchemaType>(types);
            types.add(Schema.SchemaType.NULL);
        }
        target.setType(types);
    }

    public Schema addType(Schema.SchemaType type) {
        this.addToListProperty("type", type);
        if (this.typeObservers != null) {
            this.typeObservers.forEach(o -> o.addType(type));
        }
        return this;
    }

    public void removeType(Schema.SchemaType type) {
        this.removeFromListProperty("type", type);
        if (this.typeObservers != null) {
            this.typeObservers.forEach(o -> o.removeType(type));
        }
    }

    public Schema getNot() {
        return this.getProperty("not", Schema.class);
    }

    public void setNot(Schema not) {
        this.setProperty("not", not);
    }

    public Map<String, Schema> getProperties() {
        return this.getMapProperty("properties");
    }

    public void setProperties(Map<String, Schema> properties) {
        this.setMapProperty("properties", properties);
    }

    public Schema addProperty(String key, Schema propertySchema) {
        this.addToMapProperty("properties", key, propertySchema);
        return this;
    }

    public void removeProperty(String key) {
        this.removeFromMapProperty("properties", key);
    }

    public Schema getAdditionalPropertiesSchema() {
        return this.getProperty("additionalProperties", Schema.class);
    }

    public Boolean getAdditionalPropertiesBoolean() {
        Schema additionalPropertiesSchema = this.getAdditionalPropertiesSchema();
        return additionalPropertiesSchema == null ? null : additionalPropertiesSchema.getBooleanSchema();
    }

    public void setAdditionalPropertiesSchema(Schema additionalProperties) {
        this.setProperty("additionalProperties", additionalProperties);
    }

    public void setAdditionalPropertiesBoolean(Boolean additionalProperties) {
        if (additionalProperties != null) {
            this.setAdditionalPropertiesSchema(new SchemaImpl().booleanSchema(additionalProperties));
        } else {
            this.setAdditionalPropertiesSchema(null);
        }
    }

    public String getDescription() {
        return this.getProperty("description", String.class);
    }

    public void setDescription(String description) {
        this.setProperty("description", description);
    }

    public String getFormat() {
        return this.getProperty("format", String.class);
    }

    public void setFormat(String format) {
        this.setProperty("format", format);
    }

    public Boolean getReadOnly() {
        return this.getProperty("readOnly", Boolean.class);
    }

    public void setReadOnly(Boolean readOnly) {
        this.setProperty("readOnly", readOnly);
    }

    public Boolean getWriteOnly() {
        return this.getProperty("writeOnly", Boolean.class);
    }

    public void setWriteOnly(Boolean writeOnly) {
        this.setProperty("writeOnly", writeOnly);
    }

    public Object getExample() {
        return this.getProperty("example", Object.class);
    }

    public void setExample(Object example) {
        this.setProperty("example", example);
    }

    public ExternalDocumentation getExternalDocs() {
        return this.getProperty("externalDocs", ExternalDocumentation.class);
    }

    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.setProperty("externalDocs", externalDocs);
    }

    public Boolean getDeprecated() {
        return this.getProperty("deprecated", Boolean.class);
    }

    public void setDeprecated(Boolean deprecated) {
        this.setProperty("deprecated", deprecated);
    }

    public XML getXml() {
        return this.getProperty("xml", XML.class);
    }

    public void setXml(XML xml) {
        this.setProperty("xml", xml);
    }

    public Schema getItems() {
        return this.getProperty("items", Schema.class);
    }

    public void setItems(Schema items) {
        this.setProperty("items", items);
    }

    public List<Schema> getAllOf() {
        return this.getListProperty("allOf");
    }

    public void setAllOf(List<Schema> allOf) {
        this.setListProperty("allOf", allOf);
    }

    public Schema addAllOf(Schema allOf) {
        this.addToListProperty("allOf", allOf);
        return this;
    }

    public void removeAllOf(Schema allOf) {
        this.removeFromListProperty("allOf", allOf);
    }

    public List<Schema> getAnyOf() {
        return this.getListProperty("anyOf");
    }

    public void setAnyOf(List<Schema> anyOf) {
        this.setListProperty("anyOf", anyOf);
    }

    public Schema addAnyOf(Schema anyOf) {
        this.addToListProperty("anyOf", anyOf);
        return this;
    }

    public void removeAnyOf(Schema anyOf) {
        this.removeFromListProperty("anyOf", anyOf);
    }

    public List<Schema> getOneOf() {
        return this.getListProperty("oneOf");
    }

    public void setOneOf(List<Schema> oneOf) {
        this.setListProperty("oneOf", oneOf);
    }

    public Schema addOneOf(Schema oneOf) {
        this.addToListProperty("oneOf", oneOf);
        return this;
    }

    public void removeOneOf(Schema oneOf) {
        this.removeFromListProperty("oneOf", oneOf);
    }

    public Map<String, Object> getExtensions() {
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        this.data.forEach((k, v) -> {
            if (k.startsWith("x-")) {
                extensions.put((String)k, v);
            }
        });
        return extensions.isEmpty() && !this.explicitSetExtensions ? null : extensions;
    }

    public Schema addExtension(String name, Object value) {
        this.setProperty(name, value);
        this.explicitSetExtensions = true;
        return this;
    }

    public void removeExtension(String name) {
        this.setProperty(name, null);
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.assertObjectSchema();
        this.data.keySet().removeIf(k -> k.startsWith("x-"));
        if (extensions != null) {
            this.explicitSetExtensions = true;
            extensions.forEach((k, v) -> {
                k = k.startsWith("x-") ? k : "x-" + k;
                this.setProperty((String)k, (Object)v);
            });
        } else {
            this.explicitSetExtensions = false;
        }
    }

    public String getSchemaDialect() {
        return this.getProperty("$schema", String.class);
    }

    public void setSchemaDialect(String schemaDialect) {
        this.setProperty("$schema", schemaDialect);
    }

    public String getComment() {
        return this.getProperty("$comment", String.class);
    }

    public void setComment(String comment) {
        this.setProperty("$comment", comment);
    }

    public Schema getIfSchema() {
        return this.getProperty("if", Schema.class);
    }

    public void setIfSchema(Schema ifSchema) {
        this.setProperty("if", ifSchema);
    }

    public Schema getThenSchema() {
        return this.getProperty("then", Schema.class);
    }

    public void setThenSchema(Schema thenSchema) {
        this.setProperty("then", thenSchema);
    }

    public Schema getElseSchema() {
        return this.getProperty("else", Schema.class);
    }

    public void setElseSchema(Schema elseSchema) {
        this.setProperty("else", elseSchema);
    }

    public Map<String, Schema> getDependentSchemas() {
        return this.getMapProperty("dependentSchemas");
    }

    public void setDependentSchemas(Map<String, Schema> dependentSchemas) {
        this.setMapProperty("dependentSchemas", dependentSchemas);
    }

    public Schema addDependentSchema(String propertyName, Schema schema) {
        this.addToMapProperty("dependentSchemas", propertyName, schema);
        return this;
    }

    public void removeDependentSchema(String propertyName) {
        this.removeFromMapProperty("dependentSchemas", propertyName);
    }

    public List<Schema> getPrefixItems() {
        return this.getListProperty("prefixItems");
    }

    public void setPrefixItems(List<Schema> prefixItems) {
        this.setListProperty("prefixItems", prefixItems);
    }

    public Schema addPrefixItem(Schema prefixItem) {
        this.addToListProperty("prefixItems", prefixItem);
        return this;
    }

    public void removePrefixItem(Schema prefixItem) {
        this.removeFromListProperty("prefixItems", prefixItem);
    }

    public Schema getContains() {
        return this.getProperty("contains", Schema.class);
    }

    public void setContains(Schema contains) {
        this.setProperty("contains", contains);
    }

    public Map<String, Schema> getPatternProperties() {
        return this.getMapProperty("patternProperties");
    }

    public void setPatternProperties(Map<String, Schema> patternProperties) {
        this.setMapProperty("patternProperties", patternProperties);
    }

    public Schema addPatternProperty(String regularExpression, Schema schema) {
        this.addToMapProperty("patternProperties", regularExpression, schema);
        return this;
    }

    public void removePatternProperty(String regularExpression) {
        this.removeFromMapProperty("patternProperties", regularExpression);
    }

    public Schema getPropertyNames() {
        return this.getProperty("propertyNames", Schema.class);
    }

    public void setPropertyNames(Schema propertyNameSchema) {
        this.setProperty("propertyNames", propertyNameSchema);
    }

    public Schema getUnevaluatedItems() {
        return this.getProperty("unevaluatedItems", Schema.class);
    }

    public void setUnevaluatedItems(Schema unevaluatedItems) {
        this.setProperty("unevaluatedItems", unevaluatedItems);
    }

    public Schema getUnevaluatedProperties() {
        return this.getProperty("unevaluatedProperties", Schema.class);
    }

    public void setUnevaluatedProperties(Schema unevaluatedProperties) {
        this.setProperty("unevaluatedProperties", unevaluatedProperties);
    }

    public Object getConstValue() {
        return this.getProperty("const", Object.class);
    }

    public void setConstValue(Object constValue) {
        this.setProperty("const", constValue);
    }

    public Integer getMaxContains() {
        return this.getProperty("maxContains", Integer.class);
    }

    public void setMaxContains(Integer maxContains) {
        this.setProperty("maxContains", maxContains);
    }

    public Integer getMinContains() {
        return this.getProperty("minContains", Integer.class);
    }

    public void setMinContains(Integer minContains) {
        this.setProperty("minContains", minContains);
    }

    public Map<String, List<String>> getDependentRequired() {
        return this.getMapProperty("dependentRequired");
    }

    public void setDependentRequired(Map<String, List<String>> dependentRequired) {
        this.setMapProperty("dependentRequired", dependentRequired);
    }

    public Schema addDependentRequired(String propertyName, List<String> additionalRequiredPropertyNames) {
        this.addToMapProperty("dependentRequired", propertyName, additionalRequiredPropertyNames);
        return this;
    }

    public void removeDependentRequired(String propertyName) {
        this.removeFromMapProperty("dependentRequired", propertyName);
    }

    public String getContentEncoding() {
        return this.getProperty("contentEncoding", String.class);
    }

    public void setContentEncoding(String contentEncoding) {
        this.setProperty("contentEncoding", contentEncoding);
    }

    public String getContentMediaType() {
        return this.getProperty("contentMediaType", String.class);
    }

    public void setContentMediaType(String contentMediaType) {
        this.setProperty("contentMediaType", contentMediaType);
    }

    public Schema getContentSchema() {
        return this.getProperty("contentSchema", Schema.class);
    }

    public void setContentSchema(Schema contentSchema) {
        this.setProperty("contentSchema", contentSchema);
    }

    public Boolean getBooleanSchema() {
        return this.booleanValue;
    }

    public void setBooleanSchema(Boolean booleanSchema) {
        this.incrementModCount();
        this.booleanValue = booleanSchema;
    }

    public List<Object> getExamples() {
        return this.getListProperty("examples");
    }

    public void setExamples(List<Object> examples) {
        this.setListProperty("examples", examples);
    }

    public Schema addExample(Object example) {
        this.addToListProperty("examples", example);
        return this;
    }

    public void removeExample(Object example) {
        this.removeFromListProperty("examples", example);
    }

    private boolean isBooleanSchema() {
        return this.booleanValue != null;
    }

    private void assertObjectSchema() throws UnsupportedOperationException {
        if (this.isBooleanSchema()) {
            throw new UnsupportedOperationException("Schema has a boolean value");
        }
    }

    @Override
    protected <T> void setProperty(String propertyName, T value) {
        this.assertObjectSchema();
        this.incrementModCount();
        super.setProperty(propertyName, value);
    }

    @Override
    protected <T> T getProperty(String propertyName, Class<T> clazz) {
        if (this.isBooleanSchema()) {
            return null;
        }
        return super.getProperty(propertyName, clazz);
    }

    @Override
    protected <T> List<T> getListProperty(String propertyName) {
        if (this.isBooleanSchema()) {
            return null;
        }
        return super.getListProperty(propertyName);
    }

    @Override
    protected <T> void setListProperty(String propertyName, List<T> value) {
        this.assertObjectSchema();
        this.incrementModCount();
        super.setListProperty(propertyName, value);
    }

    @Override
    protected <T> void addToListProperty(String propertyName, T value) {
        this.assertObjectSchema();
        this.incrementModCount();
        super.addToListProperty(propertyName, value);
    }

    @Override
    protected <T> void removeFromListProperty(String propertyName, T toRemove) {
        if (!this.isBooleanSchema()) {
            this.incrementModCount();
            super.removeFromListProperty(propertyName, toRemove);
        }
    }

    @Override
    protected <T> void setMapProperty(String propertyName, Map<String, T> value) {
        this.assertObjectSchema();
        this.incrementModCount();
        super.setMapProperty(propertyName, value);
    }

    @Override
    protected <T> Map<String, T> getMapProperty(String propertyName) {
        if (this.isBooleanSchema()) {
            return null;
        }
        return super.getMapProperty(propertyName);
    }

    @Override
    protected <T> void addToMapProperty(String propertyName, String key, T value) {
        this.assertObjectSchema();
        this.incrementModCount();
        super.addToMapProperty(propertyName, key, value);
    }

    @Override
    protected <T> void removeFromMapProperty(String propertyName, String key) {
        if (!this.isBooleanSchema()) {
            this.incrementModCount();
            super.removeFromMapProperty(propertyName, key);
        }
    }

    public Object get(String propertyName) {
        return this.getProperty(propertyName, Object.class);
    }

    public Schema set(String propertyName, Object value) {
        this.setProperty(propertyName, value);
        return this;
    }

    public Map<String, ?> getAll() {
        return Collections.unmodifiableMap(this.data);
    }

    public void setAll(Map<String, ?> allProperties) {
        this.incrementModCount();
        this.data.clear();
        if (allProperties != null) {
            allProperties.forEach(this::setProperty);
        }
    }
}

