/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models.callbacks;

import io.smallrye.openapi.api.models.ExtensibleImpl;
import io.smallrye.openapi.api.models.MapModel;
import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.runtime.io.ReferenceType;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;

public class CallbackImpl
extends ExtensibleImpl<Callback>
implements Callback,
ModelImpl,
MapModel<PathItem> {
    private String ref;
    private Map<String, PathItem> pathItems;

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref != null && !ref.contains("/")) {
            ref = ReferenceType.CALLBACK.referenceOf(ref);
        }
        this.ref = ref;
    }

    public Callback ref(String ref) {
        this.setRef(ref);
        return this;
    }

    public Callback addPathItem(String name, PathItem item) {
        this.pathItems = ModelUtil.add(name, item, this.pathItems, LinkedHashMap::new);
        return this;
    }

    public void removePathItem(String name) {
        ModelUtil.remove(this.pathItems, name);
    }

    public Map<String, PathItem> getPathItems() {
        return ModelUtil.unmodifiableMap(this.pathItems);
    }

    public void setPathItems(Map<String, PathItem> items) {
        this.pathItems = ModelUtil.replace(items, LinkedHashMap::new);
    }

    @Override
    public Map<String, PathItem> getMap() {
        return this.pathItems;
    }

    @Override
    public void setMap(Map<String, PathItem> map) {
        this.pathItems = map;
    }

    @Override
    public PathItem get(Object key) {
        return (PathItem)MapModel.super.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return MapModel.super.containsKey(key);
    }

    @Override
    public PathItem put(String key, PathItem value) {
        return MapModel.super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends PathItem> m) {
        MapModel.super.putAll(m);
    }

    @Override
    public PathItem remove(Object key) {
        return (PathItem)MapModel.super.remove(key);
    }
}

