/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models;

import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MapBasedModelImpl
implements ModelImpl {
    protected final HashMap<String, Object> data = new HashMap();

    protected MapBasedModelImpl() {
    }

    public MapBasedModelImpl mergeFrom(MapBasedModelImpl other) {
        MapBasedModelImpl.mergeMap(this.data, other.data, this.getNonMergableCollections());
        return this;
    }

    public Map<String, Object> getDataMap() {
        return this.data;
    }

    private static <T> void mergeMap(Map<String, T> into, Map<String, T> from, Set<String> nonMergableNames) {
        for (Map.Entry<String, T> entry : from.entrySet()) {
            String name = entry.getKey();
            T value = entry.getValue();
            T oldValue = into.get(entry.getKey());
            if (oldValue == null || oldValue.getClass() != value.getClass()) {
                into.put(name, value);
                continue;
            }
            if (oldValue instanceof Map && !nonMergableNames.contains(name)) {
                MapBasedModelImpl.mergeMap((Map)oldValue, (Map)value, nonMergableNames);
                continue;
            }
            if (oldValue instanceof List && !nonMergableNames.contains(name)) {
                MapBasedModelImpl.mergeList((List)oldValue, (List)value);
                continue;
            }
            if (oldValue instanceof ModelImpl) {
                into.put(name, MergeUtil.mergeObjects(oldValue, value));
                continue;
            }
            into.put(name, value);
        }
    }

    private static <T> void mergeList(List<T> oldValue, List<T> value) {
        HashSet<T> contents = new HashSet<T>(oldValue);
        for (T element : value) {
            if (contents.contains(element)) continue;
            oldValue.add(element);
        }
    }

    protected <T> void setProperty(String propertyName, T value) {
        if (value == null) {
            this.data.remove(propertyName);
        } else {
            this.data.put(propertyName, value);
        }
    }

    protected <T> T getProperty(String propertyName, Class<T> type) {
        Object result = this.data.get(propertyName);
        if (type.isInstance(result)) {
            return type.cast(result);
        }
        return null;
    }

    protected <T> List<T> getListProperty(String propertyName) {
        Object result = this.data.get(propertyName);
        if (result instanceof List) {
            return Collections.unmodifiableList((List)result);
        }
        return null;
    }

    protected <T> void setListProperty(String propertyName, List<T> value) {
        if ((value = ModelUtil.replace(value, ArrayList::new)) == null) {
            this.data.remove(propertyName);
        } else {
            this.data.put(propertyName, value);
        }
    }

    protected <T> void addToListProperty(String propertyName, T value) {
        if (value != null) {
            ArrayList<T> list;
            Object existing = this.data.get(propertyName);
            if (existing instanceof List) {
                list = (ArrayList<T>)existing;
            } else {
                list = new ArrayList<T>();
                this.data.put(propertyName, list);
            }
            list.add(value);
        }
    }

    protected <T> void removeFromListProperty(String propertyName, T toRemove) {
        Object existing = this.data.get(propertyName);
        if (existing instanceof List) {
            List list = (List)existing;
            ModelUtil.remove(list, toRemove);
        }
    }

    protected <T> void setMapProperty(String propertyName, Map<String, T> value) {
        if ((value = ModelUtil.replace(value, HashMap::new)) == null) {
            this.data.remove(propertyName);
        } else {
            this.data.put(propertyName, value);
        }
    }

    protected <T> Map<String, T> getMapProperty(String propertyName) {
        Object result = this.data.get(propertyName);
        if (result instanceof Map) {
            return Collections.unmodifiableMap((Map)this.data.get(propertyName));
        }
        return null;
    }

    protected <T> void addToMapProperty(String propertyName, String key, T value) {
        if (value != null) {
            HashMap<String, T> map;
            Object existing = this.data.get(propertyName);
            if (existing instanceof Map) {
                map = (HashMap<String, T>)existing;
            } else {
                map = new HashMap<String, T>();
                this.data.put(propertyName, map);
            }
            map.put(key, value);
        }
    }

    protected <T> void removeFromMapProperty(String propertyName, String key) {
        Object existing = this.data.get(propertyName);
        if (existing instanceof Map) {
            Map map = (Map)existing;
            ModelUtil.remove(map, key);
        }
    }

    protected Set<String> getNonMergableCollections() {
        return Collections.emptySet();
    }
}

