/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.json.JSONException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import test.io.smallrye.openapi.runtime.scanner.dataobject.SingleAnnotatedConstructorArgument;
import test.io.smallrye.openapi.runtime.scanner.jakarta.JAXBElementDto;

class StandaloneSchemaScanTest
extends IndexScannerTestBase {
    StandaloneSchemaScanTest() {
    }

    @Test
    void testUnreferencedSchemasInComponents() throws Exception {
        OpenAPI result = StandaloneSchemaScanTest.scan(Cat.class, Dog.class, Class.forName(this.getClass().getPackage().getName() + ".package-info"));
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.unreferenced.json", result);
    }

    @Test
    void testInheritanceAnyOf() throws Exception {
        OpenAPI result = StandaloneSchemaScanTest.scan(Reptile.class, Lizard.class, Snake.class, Turtle.class, Alligator.class);
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.inheritance.json", result);
    }

    @Test
    void testInheritanceAutomaticAnyOf() throws Exception {
        OpenAPI result = StandaloneSchemaScanTest.scan(StandaloneSchemaScanTest.config("mp.openapi.extensions.smallrye.auto-inheritance", "BOTH"), ReptileNoAllOf.class, LizardNoAllOf.class, SnakeNoAllOf.class, TurtleNoAllOf.class, AlligatorNoAllOf.class);
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.inheritance.json", result);
    }

    @Test
    void testInheritanceAutomaticAnyOfParentOnly() throws Exception {
        OpenAPI result = StandaloneSchemaScanTest.scan(StandaloneSchemaScanTest.config("mp.openapi.extensions.smallrye.auto-inheritance", "PARENT_ONLY"), ReptileNoAllOf.class, LizardNoAllOf.class, SnakeNoAllOf.class, TurtleNoAllOf.class, AlligatorNoAllOf.class);
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.inheritance-parent-only.json", result);
    }

    @Test
    void testRegisteredSchemaTypePreserved() throws IOException, JSONException {
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.registered-schema-type-preserved.json", RegisteredSchemaTypePreservedModel.Animal.class, RegisteredSchemaTypePreservedModel.AnimalListEnvelope.class, RegisteredSchemaTypePreservedModel.MessageBase.class, RegisteredSchemaTypePreservedModel.MessageData.class, RegisteredSchemaTypePreservedModel.MessageDataItems.class);
    }

    @Test
    void testJavaxJaxbElementUnwrapped() throws IOException, JSONException {
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.jaxbelement-generic-type-unwrapped.json", test.io.smallrye.openapi.runtime.scanner.javax.JAXBElementDto.class);
    }

    @Test
    void testJakartaJaxbElementUnwrapped() throws IOException, JSONException {
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.jaxbelement-generic-type-unwrapped.json", JAXBElementDto.class);
    }

    @Test
    void testJacksonJsonUnwrapped() throws IOException, JSONException {
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas-jackson-jsonunwrapped.json", JacksonJsonPerson.class, JacksonJsonPersonWithPrefixedAddress.class, JacksonJsonPersonWithSuffixedAddress.class, JacksonJsonAddress.class);
    }

    @Test
    void testNestedCollectionSchemas() throws IOException, JSONException {
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.nested-parameterized-collection-types.json", CollectionBean.class, EntryBean.class, MultivaluedCollection.class, MultivaluedMap.class, Collection.class, ArrayList.class, HashMap.class, List.class, Map.class, Set.class, UUID.class);
    }

    @Test
    void testNestedCustomGenericSchemas() throws IOException, JSONException {
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.nested-custom-generics.json", Foo.class, Generic0.class, Generic1.class, Generic2.class, CustomMap.class);
    }

    @Test
    void testOptionalArrayTypes() throws IOException, JSONException {
        @Schema(name="B")
        class B {
            public UUID id;

            B() {
            }
        }
        @Schema(name="A")
        class A {
            public UUID id;
            public Optional<B> optionalOfB;
            public List<B> listOfB;
            public Optional<List<B>> optionalListOfB;
            public Optional<B[]> optionalArrayOfB;
            public Optional<B>[] arrayOfOptionalB;
            public List<Optional<B>> listOfOptionalB;

            A() {
            }
        }
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.optional-arraytype.json", B.class, A.class, UUID.class, List.class, Optional.class);
    }

    @Test
    void testArraySchemaTypeOverridden() throws IOException, JSONException {
        @Schema(name="Sample")
        class Sample {
            @Schema(type=SchemaType.STRING, format="base64")
            public byte[] data;
            @Schema(type=SchemaType.STRING)
            public char[] chars;
            @Schema(type=SchemaType.ARRAY)
            public char[] arrayFromSchema;
            @Schema
            public char[] arrayFromType;

            Sample() {
            }
        }
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.array-type-override.json", Sample.class);
    }

    @Test
    void testSingleAnnotatedConstructorArgumentIgnored() throws IOException, JSONException {
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.annotated-constructor-arg-ignored.json", SingleAnnotatedConstructorArgument.class);
    }

    @Test
    void testParameterizedTypeWithNonparameterizedAncestryChainLink() throws IOException, JSONException {
        @Schema(name="TestBean")
        class Bean {
            Pair<String, String> pair;

            Bean() {
            }
        }
        class Pair<T1, T2>
        extends Tuple {
            Pair() {
                class Tuple
                implements Iterable<Object> {
                    Tuple() {
                    }

                    @Override
                    public Iterator<Object> iterator() {
                        return null;
                    }
                }
            }
        }
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.nonparameterized-ancestry-chain-link.json", Bean.class, Pair.class, Tuple.class);
    }

    @Test
    void testSchemaDeprecation() throws IOException, JSONException {
        @Schema(name="Bean1")
        @Deprecated
        class Bean1 {
            String prop1;
            String prop2;

            Bean1() {
            }
        }
        @Schema(name="Bean2")
        class Bean2 {
            @Deprecated
            String prop1;
            String prop2;
            Bean1 prop3;

            Bean2() {
            }
        }
        @Schema(name="Bean3")
        class Bean3 {
            String prop1;
            String prop2;
            Bean2 prop3;

            Bean3() {
            }
        }
        OpenAPI result = StandaloneSchemaScanTest.scan(Bean1.class, Bean2.class, Bean3.class);
        Assertions.assertTrue((boolean)((org.eclipse.microprofile.openapi.models.media.Schema)result.getComponents().getSchemas().get("Bean1")).getDeprecated());
        Assertions.assertNull((Object)((org.eclipse.microprofile.openapi.models.media.Schema)((org.eclipse.microprofile.openapi.models.media.Schema)result.getComponents().getSchemas().get("Bean1")).getProperties().get("prop1")).getDeprecated());
        Assertions.assertNull((Object)((org.eclipse.microprofile.openapi.models.media.Schema)((org.eclipse.microprofile.openapi.models.media.Schema)result.getComponents().getSchemas().get("Bean1")).getProperties().get("prop2")).getDeprecated());
        Assertions.assertNull((Object)((org.eclipse.microprofile.openapi.models.media.Schema)result.getComponents().getSchemas().get("Bean2")).getDeprecated());
        Assertions.assertTrue((boolean)((org.eclipse.microprofile.openapi.models.media.Schema)((org.eclipse.microprofile.openapi.models.media.Schema)result.getComponents().getSchemas().get("Bean2")).getProperties().get("prop1")).getDeprecated());
        Assertions.assertNull((Object)((org.eclipse.microprofile.openapi.models.media.Schema)((org.eclipse.microprofile.openapi.models.media.Schema)result.getComponents().getSchemas().get("Bean2")).getProperties().get("prop2")).getDeprecated());
        Assertions.assertNull((Object)((org.eclipse.microprofile.openapi.models.media.Schema)((org.eclipse.microprofile.openapi.models.media.Schema)result.getComponents().getSchemas().get("Bean2")).getProperties().get("prop3")).getDeprecated());
        Assertions.assertNull((Object)((org.eclipse.microprofile.openapi.models.media.Schema)result.getComponents().getSchemas().get("Bean3")).getDeprecated());
        Assertions.assertNull((Object)((org.eclipse.microprofile.openapi.models.media.Schema)((org.eclipse.microprofile.openapi.models.media.Schema)result.getComponents().getSchemas().get("Bean3")).getProperties().get("prop1")).getDeprecated());
        Assertions.assertNull((Object)((org.eclipse.microprofile.openapi.models.media.Schema)((org.eclipse.microprofile.openapi.models.media.Schema)result.getComponents().getSchemas().get("Bean3")).getProperties().get("prop2")).getDeprecated());
        Assertions.assertNull((Object)((org.eclipse.microprofile.openapi.models.media.Schema)((org.eclipse.microprofile.openapi.models.media.Schema)result.getComponents().getSchemas().get("Bean3")).getProperties().get("prop3")).getDeprecated());
    }

    @Test
    void testFieldSchemaOverridesTypeAssertion() throws IOException, JSONException {
        @Schema(name="OtherBean", description="The first bean")
        class OtherBean {
            @Schema(maxLength=5)
            String prop1;
            Object prop2;

            OtherBean() {
            }
        }
        @Schema(name="Bean")
        class Bean {
            @Schema(title="In-lined schema with overridden attributes", description="Not 'The first bean'", properties={@SchemaProperty(name="prop1", maxLength=4), @SchemaProperty(name="prop2", type=SchemaType.INTEGER)})
            OtherBean first;
            @Schema(title="Property with `type` and reference to `OtherBean`")
            OtherBean second;
            @Schema
            OtherBean third;

            Bean() {
            }
        }
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.field-overrides-type.json", OtherBean.class, Bean.class);
    }

    @Test
    void testStreamTypes() throws IOException, JSONException {
        @Schema(name="TestBean")
        class Bean {
            Stream<String> stringArrayFromStream;
            IntStream intArrayFromStream;
            Properties anyValueMapFromProperties;
            StringArray stringArrayFromIterator;
            LongStream longArrayFromStream;
            DoubleStream doubleArrayFromStream;
            Collection anyArrayFromRawCollection;

            Bean() {
            }
        }
        @Schema(name="StringArray")
        class StringArray
        extends ArrayList<String> {
            StringArray() {
            }
        }
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.iterator-stream-map-types.json", Bean.class, StringArray.class);
    }

    @Test
    void testZonedDateTimeArrayWrapper() throws IOException, JSONException {
        @Schema(name="ZonedDateTimeArrayWrapper")
        class ZonedDateTimeArrayWrapper {
            ZonedDateTime[] now;

            ZonedDateTimeArrayWrapper() {
            }
        }
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.terminal-array-item-registration.json", ZonedDateTimeArrayWrapper.class, ZonedDateTime.class);
    }

    @Test
    void testNoSelfRefToSchemaOfAnnotatedObjectProperty() throws IOException, JSONException {
        @Schema(description="some description", name="MyClass")
        class Class1 {
            Class2 value;

            Class1() {
            }
        }
        @Schema(type=SchemaType.STRING, name="MyValueClass")
        class Class2 {
            Class2() {
            }
        }
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.no-self-ref-for-property-schema.json", Class1.class, Class2.class);
    }

    @Test
    void testParameterizedTypeSchemaConfig() throws IOException, JSONException {
        class Nullable<T> {
            T value;
            boolean isPresent;

            Nullable() {
            }

            boolean isPresent() {
                return this.isPresent;
            }
        }
        String nullableStringArySig = Nullable.class.getName() + "<java.lang.String[]>";
        @Schema(name="Bean")
        class Bean {
            Nullable<String[]> nullableString;

            Bean() {
            }
        }
        OpenAPI result = StandaloneSchemaScanTest.scan(StandaloneSchemaScanTest.config("mp.openapi.schema." + nullableStringArySig, "{ \"name\": \"NullableStringArray\", \"type\": \"array\", \"items\": { \"type\": \"string\" }, \"nullable\": true }"), Nullable.class, Bean.class);
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.parameterized-type-schema-config.json", result);
    }

    @Test
    void testJacksonPropertyAccess() throws IOException, JSONException {
        @Schema(name="Bean")
        class Bean {
            @JsonProperty
            String dflt;
            @JsonProperty(access=JsonProperty.Access.READ_ONLY)
            String ro;
            @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
            String wo;
            @JsonProperty(access=JsonProperty.Access.READ_WRITE)
            String rw;
            @JsonProperty(access=JsonProperty.Access.AUTO)
            @JsonIgnore
            String ignored;

            Bean() {
            }

            public void setRo(String ro) {
                this.ro = ro;
            }

            public String getWo() {
                return this.wo;
            }
        }
        StandaloneSchemaScanTest.assertJsonEquals("components.schemas.jackson-property-access.json", Bean.class);
    }

    static class Cat {
        public String name;
        @Schema(minimum="1", maximum="20")
        public int age;
        @Schema(nullable=true)
        public String color;

        Cat() {
        }
    }

    @Schema(name="DogType")
    static class Dog {
        public String name;
        public int age;
        @Schema(required=true)
        public int volume;

        Dog() {
        }
    }

    @Schema(discriminatorProperty="type", discriminatorMapping={@DiscriminatorMapping(value="lizard", schema=Lizard.class), @DiscriminatorMapping(value="snake", schema=Snake.class), @DiscriminatorMapping(value="turtle", schema=Turtle.class)})
    static abstract class Reptile {
        @Schema(required=true)
        private String type;

        Reptile() {
        }
    }

    @Schema(allOf={Reptile.class, Lizard.class})
    static class Lizard
    extends Reptile {
        String color;

        Lizard() {
        }
    }

    @Schema(allOf={Reptile.class, Snake.class})
    static class Snake
    extends Reptile {
        int length;
        String lengthUnits;

        Snake() {
        }
    }

    @Schema(allOf={Reptile.class, Turtle.class})
    static class Turtle
    extends Reptile {
        String shellPattern;

        Turtle() {
        }
    }

    @Schema(description="An alligator is a reptile without allOf inheritance")
    static class Alligator
    extends Reptile {
        float jawLength;

        Alligator() {
        }
    }

    @Schema(name="Reptile", discriminatorProperty="type", discriminatorMapping={@DiscriminatorMapping(value="lizard", schema=LizardNoAllOf.class), @DiscriminatorMapping(value="snake", schema=SnakeNoAllOf.class), @DiscriminatorMapping(value="turtle", schema=TurtleNoAllOf.class)})
    static abstract class ReptileNoAllOf {
        @Schema(required=true)
        private String type;

        ReptileNoAllOf() {
        }
    }

    @Schema(name="Lizard")
    static class LizardNoAllOf
    extends ReptileNoAllOf {
        String color;

        LizardNoAllOf() {
        }
    }

    @Schema(name="Snake")
    static class SnakeNoAllOf
    extends ReptileNoAllOf {
        int length;
        String lengthUnits;

        SnakeNoAllOf() {
        }
    }

    @Schema(name="Turtle")
    static class TurtleNoAllOf
    extends ReptileNoAllOf {
        String shellPattern;

        TurtleNoAllOf() {
        }
    }

    @Schema(name="Alligator", allOf={void.class}, description="An alligator is a reptile without allOf inheritance")
    static class AlligatorNoAllOf
    extends ReptileNoAllOf {
        float jawLength;

        AlligatorNoAllOf() {
        }
    }

    static class RegisteredSchemaTypePreservedModel {
        RegisteredSchemaTypePreservedModel() {
        }

        @Schema
        static class MessageDataItems<T> {
            private List<T> items;

            public MessageDataItems() {
            }

            public MessageDataItems(List<T> items) {
                this.items = new ArrayList<T>(items);
            }

            public List<T> getItems() {
                return Collections.unmodifiableList(this.items);
            }

            public void setItems(List<T> items) {
                this.items = new ArrayList<T>(items);
            }

            @Schema(example="1")
            public int getCurrentItemCount() {
                return this.items == null ? 0 : this.items.size();
            }
        }

        @Schema
        static class MessageBase {
            @Schema(description="The API version", example="v3")
            protected String apiVersion = "v3";
            @Schema(description="Unique request-id (used for logging)", example="F176f717c7a71")
            protected String requestId;
            @Schema(description="Optional context-value for request/response correlation")
            protected String context;

            protected MessageBase() {
            }

            public String getRequestId() {
                return this.requestId;
            }

            public void setRequestId(String id) {
                this.requestId = id;
            }

            public String getContext() {
                return this.context;
            }

            public void setContext(String context) {
                this.context = context;
            }

            public String getApiVersion() {
                return this.apiVersion;
            }

            public void setApiVersion(String apiVersion) {
                this.apiVersion = apiVersion;
            }
        }

        @Schema
        static class MessageData<T>
        extends MessageBase {
            @Schema(description="The business data object")
            private T data;

            public MessageData() {
            }

            public MessageData(T data) {
                this.data = data;
            }

            public T getData() {
                return this.data;
            }

            public void setData(T data) {
                this.data = data;
            }

            @Schema(description="The class-name of the business data object")
            public String getKind() {
                if (this.data == null) {
                    return null;
                }
                return this.data.getClass().getSimpleName();
            }
        }

        static class Animal {
            private String name;
            private int age;

            public Animal() {
            }

            public Animal(String name, int age) {
                this.name = name;
                this.age = age;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public int getAge() {
                return this.age;
            }

            public void setAge(int age) {
                this.age = age;
            }
        }

        @Schema
        static class AnimalListEnvelope
        extends MessageData<MessageDataItems<Animal>> {
            public AnimalListEnvelope() {
            }

            public AnimalListEnvelope(List<Animal> animals) {
                super(new MessageDataItems<Animal>(animals));
            }
        }
    }

    @Schema
    static class JacksonJsonPerson {
        protected String name;
        @JsonUnwrapped
        protected JacksonJsonAddress address;

        JacksonJsonPerson() {
        }

        @Schema(description="Ignored since address is unwrapped")
        public JacksonJsonAddress getAddress() {
            return this.address;
        }
    }

    @Schema
    static class JacksonJsonPersonWithPrefixedAddress {
        protected String name;
        @JsonUnwrapped(prefix="addr-")
        protected JacksonJsonAddress address;

        JacksonJsonPersonWithPrefixedAddress() {
        }
    }

    @Schema
    static class JacksonJsonPersonWithSuffixedAddress {
        protected String name;
        @JsonUnwrapped(suffix="-addr")
        protected JacksonJsonAddress address;

        JacksonJsonPersonWithSuffixedAddress() {
        }
    }

    @Schema
    static class JacksonJsonAddress {
        protected int streetNumber;
        protected String streetName;
        protected String city;
        protected String state;
        protected String postalCode;

        JacksonJsonAddress() {
        }
    }

    @Schema
    static class CollectionBean {
        @Schema(description="In-line schema, `additionalProperties` array `items` reference `EntryBean`")
        CustomMap<String, List<EntryBean>> a_customMapOfLists;
        @Schema(description="Reference to `MultivaluedMapStringEntryBean")
        MultivaluedMap<String, EntryBean> b_multivaluedEntryMap;
        @Schema(description="In-line schema, `additionalProperties` array `items` reference `EntryBean`")
        Map<String, List<EntryBean>> c_mapStringListEntryBean;
        @Schema(description="In-line schema (All JDK types, no references)")
        Collection<Map<String, List<String>>> d_collectionOfMapsOfListsOfStrings;
        @Schema(description="In-line schema")
        Map<UUID, Map<String, Set<UUID>>> e_mapOfMapsOfSetsOfUUIDs;
        @Schema(description="Reference to `MultivaluedCollectionString`")
        MultivaluedCollection<String> f_listOfStringLists;

        CollectionBean() {
        }
    }

    static class EntryBean {
        String name;
        String value;

        EntryBean() {
        }
    }

    static class MultivaluedCollection<T>
    extends ArrayList<List<T>> {
        private static final long serialVersionUID = 1L;

        MultivaluedCollection() {
        }
    }

    static class MultivaluedMap<K, V>
    extends HashMap<K, List<V>> {
        private static final long serialVersionUID = 1L;

        MultivaluedMap() {
        }
    }

    @Schema
    static class Foo {
        Generic2<String> generic;

        Foo() {
        }
    }

    static class Generic0<T> {
        T value;

        Generic0() {
        }
    }

    static class Generic1<T> {
        T value;

        Generic1() {
        }
    }

    static class Generic2<T> {
        Generic1<T> nested;
        CustomMap<T, T> nestedMap;
        Generic0<T>[] arrayOfGeneric0;

        Generic2() {
        }
    }

    static class CustomMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1L;

        CustomMap() {
        }

        static {
            throw new RuntimeException("CustomMap was initialized!?");
        }
    }

    @Target(value={ElementType.TYPE_USE})
    static @interface TestAnno {
    }
}

