/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import com.fasterxml.jackson.annotation.JsonValue;
import io.smallrye.openapi.api.SmallRyeOpenAPI;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Test;

class SchemaPropertyTest
extends IndexScannerTestBase {
    SchemaPropertyTest() {
    }

    @Test
    void testClassSchemaPropertyMergesWithFieldSchemas() throws Exception {
        Index index = SchemaPropertyTest.indexOf(Reptile.class, Lizard.class, Snake.class, Turtle.class, LengthUnits.class, Speed.class);
        SmallRyeOpenAPI result1 = SmallRyeOpenAPI.builder().withConfig(SchemaPropertyTest.config(Collections.emptyMap())).withIndex((IndexView)index).defaultRequiredProperties(false).build();
        SchemaPropertyTest.printToConsole(result1.model());
        SchemaPropertyTest.assertJsonEquals("components.schemas.schemaproperty-merge.json", result1.model());
    }

    @Schema(discriminatorProperty="type", discriminatorMapping={@DiscriminatorMapping(value="lizard", schema=Lizard.class), @DiscriminatorMapping(value="snake", schema=Snake.class), @DiscriminatorMapping(value="turtle", schema=Turtle.class)})
    static abstract class Reptile {
        @Schema(required=true)
        private String type;

        Reptile() {
        }
    }

    @Schema(allOf={Reptile.class, Lizard.class}, properties={@SchemaProperty(name="color", description="The color of the lizard")})
    static class Lizard
    extends Reptile {
        @Schema(defaultValue="GREEN", deprecated=false)
        String color;

        Lizard() {
        }
    }

    @Schema(allOf={Reptile.class, Snake.class}, properties={@SchemaProperty(name="lengthUnits", defaultValue="CM")})
    static class Snake
    extends Reptile {
        @Schema(multipleOf=0.1)
        double length;
        @Schema(description="The units of measure for length", defaultValue="MM")
        LengthUnits lengthUnits;

        Snake() {
        }
    }

    @Schema(allOf={Reptile.class, Turtle.class})
    static class Turtle
    extends Reptile {
        String shellPattern;
        Speed speed;

        Turtle() {
        }
    }

    @Schema(name="LengthUnitsEnum")
    static enum LengthUnits {
        CM,
        MM,
        IN;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    @Schema(name="SpeedEnum")
    public static enum Speed {
        SLOW,
        SLOWER,
        SLOWEST;

        @JsonValue
        final String notMethod = "junk";

        @JsonValue
        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @JsonValue(value=false)
        public String annotationValueIsFalse() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

