/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.OpenApiDataObjectScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class OpenApiDataObjectScannerTest {
    OpenApiDataObjectScanner target;

    OpenApiDataObjectScannerTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
    }

    @ParameterizedTest
    @CsvSource(value={"java.util.stream.DoubleStream, NUMBER,  double", "java.util.stream.IntStream   , INTEGER, int32", "java.util.stream.LongStream  , INTEGER, int64", "java.util.stream.Stream      ,        , "})
    void testStreams(String type, Schema.SchemaType itemType, String itemFormat) throws IOException {
        Index index = Index.of((Class[])new Class[0]);
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)index, Thread.currentThread().getContextClassLoader(), IndexScannerTestBase.emptyConfig());
        org.eclipse.microprofile.openapi.models.media.Schema out = OpenApiDataObjectScanner.process((AnnotationScannerContext)context, (Type)Type.create((DotName)DotName.createSimple((String)type), (Type.Kind)Type.Kind.CLASS));
        Assertions.assertEquals(Collections.singletonList(Schema.SchemaType.ARRAY), (Object)out.getType());
        List<Schema.SchemaType> expectedTypes = itemType == null ? null : Collections.singletonList(itemType);
        Assertions.assertEquals(expectedTypes, (Object)out.getItems().getType());
        Assertions.assertEquals((Object)itemFormat, (Object)out.getItems().getFormat());
    }

    @Test
    void testNoSelfReferencingRegardlessOfScanOrder() throws IOException {
        @Schema(description="Containing class")
        class C {
            N n;

            C() {
            }
        }
        @Schema(description="Nested class", type=SchemaType.STRING)
        class N {
            N() {
            }
        }
        Index index = Index.of((Class[])new Class[]{C.class, N.class});
        AnnotationScannerContext contextCFirst = new AnnotationScannerContext((IndexView)index, Thread.currentThread().getContextClassLoader(), IndexScannerTestBase.emptyConfig());
        AnnotationScannerContext contextNFirst = new AnnotationScannerContext((IndexView)index, Thread.currentThread().getContextClassLoader(), IndexScannerTestBase.emptyConfig());
        Type cType = Type.create((DotName)DotName.createSimple(C.class), (Type.Kind)Type.Kind.CLASS);
        Type nType = Type.create((DotName)DotName.createSimple(N.class), (Type.Kind)Type.Kind.CLASS);
        OpenApiDataObjectScanner.process((AnnotationScannerContext)contextCFirst, (Type)cType);
        OpenApiDataObjectScanner.process((AnnotationScannerContext)contextCFirst, (Type)nType);
        OpenApiDataObjectScanner.process((AnnotationScannerContext)contextNFirst, (Type)nType);
        OpenApiDataObjectScanner.process((AnnotationScannerContext)contextNFirst, (Type)cType);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNull((Object)((org.eclipse.microprofile.openapi.models.media.Schema)contextCFirst.getOpenApi().getComponents().getSchemas().get("1N")).getRef(), (String)"C first"), () -> Assertions.assertNull((Object)((org.eclipse.microprofile.openapi.models.media.Schema)contextNFirst.getOpenApi().getComponents().getSchemas().get("1N")).getRef(), (String)"N first")});
    }
}

