/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.SmallRyeOpenAPI;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.parameters.ParameterImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.json.JSONException;
import org.junit.jupiter.api.Assertions;
import org.skyscreamer.jsonassert.JSONAssert;

public class IndexScannerTestBase {
    private static final Logger LOG = Logger.getLogger(IndexScannerTestBase.class);
    static final Pattern PATTERN_CLASS_DOTNAME_COMPONENTIZE = Pattern.compile("([\\.$]|$)");

    protected static String pathOf(Class<?> clazz) {
        return clazz.getName().replace('.', '/').concat(".class");
    }

    protected static void indexDirectory(Indexer indexer, String baseDir) {
        InputStream directoryStream = IndexScannerTestBase.tcclGetResourceAsStream(baseDir);
        BufferedReader reader = new BufferedReader(new InputStreamReader(directoryStream));
        reader.lines().filter(resName -> resName.endsWith(".class")).map(resName -> Paths.get(baseDir, resName)).forEach(path -> IndexScannerTestBase.index(indexer, path.toString()));
    }

    private static InputStream tcclGetResourceAsStream(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public static Index indexOf(String ... classNames) {
        Indexer indexer = new Indexer();
        for (String name : classNames) {
            IndexScannerTestBase.index(indexer, name.replace('.', '/').concat(".class"));
        }
        return indexer.complete();
    }

    public static Index indexOf(Class<?> ... classes) {
        Indexer indexer = new Indexer();
        for (Class<?> klazz : classes) {
            IndexScannerTestBase.index(indexer, IndexScannerTestBase.pathOf(klazz));
        }
        return indexer.complete();
    }

    protected static void index(Indexer indexer, String resName) {
        try {
            InputStream stream = IndexScannerTestBase.tcclGetResourceAsStream(resName);
            indexer.index(stream);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    protected static DotName componentize(String className) {
        Matcher matcher = PATTERN_CLASS_DOTNAME_COMPONENTIZE.matcher(className);
        String previousDelimiter = null;
        int previousEnd = 0;
        DotName name = null;
        while (matcher.find()) {
            String localName = className.substring(previousEnd, matcher.start());
            boolean innerClass = "$".equals(previousDelimiter);
            name = DotName.createComponentized(name, (String)localName, (boolean)innerClass);
            previousDelimiter = matcher.group();
            previousEnd = matcher.end();
        }
        return name;
    }

    public static void printToConsole(String entityName, Schema schema) {
        LOG.debug((Object)IndexScannerTestBase.schemaToString(entityName, schema));
    }

    public static void printToConsole(OpenAPI oai) {
        LOG.debug((Object)IndexScannerTestBase.toJSON(oai));
    }

    public static String toJSON(OpenAPI oai) {
        return SmallRyeOpenAPI.builder().withConfig(IndexScannerTestBase.config(Collections.emptyMap())).withInitialModel(oai).defaultRequiredProperties(false).enableModelReader(false).enableStandardStaticFiles(false).enableAnnotationScan(false).enableStandardFilter(false).build().toJSON();
    }

    public static void verifyMethodAndParamRefsPresent(OpenAPI oai) {
        if (oai.getPaths() != null && oai.getPaths().getPathItems() != null) {
            for (Map.Entry pathItemEntry : oai.getPaths().getPathItems().entrySet()) {
                PathItem pathItem = (PathItem)pathItemEntry.getValue();
                if (pathItem.getOperations() == null) continue;
                for (Map.Entry operationEntry : pathItem.getOperations().entrySet()) {
                    Operation operation = (Operation)operationEntry.getValue();
                    String opRef = operationEntry.getKey() + " " + (String)pathItemEntry.getKey();
                    Assertions.assertNotNull((Object)OperationImpl.getMethodRef((Operation)operation), (String)("methodRef: " + opRef));
                    if (operation.getParameters() == null) continue;
                    for (Parameter parameter : operation.getParameters()) {
                        if (IndexScannerTestBase.isPathMatrixObject(parameter)) continue;
                        String pRef = opRef + ", " + parameter.getIn() + ": " + parameter.getName();
                        Assertions.assertNotNull((Object)ParameterImpl.getParamRef((Parameter)parameter), (String)("paramRef: " + pRef));
                    }
                }
            }
        }
    }

    private static boolean isPathMatrixObject(Parameter parameter) {
        return parameter.getIn() == Parameter.In.PATH && parameter.getStyle() == Parameter.Style.MATRIX && parameter.getSchema() != null && parameter.getSchema().getType() != null && parameter.getSchema().getType().equals(Collections.singletonList(Schema.SchemaType.OBJECT));
    }

    public static String schemaToString(String entityName, Schema schema) {
        return IndexScannerTestBase.toJSON(OASFactory.createOpenAPI().components(OASFactory.createComponents().addSchema(entityName, schema)));
    }

    public static void assertJsonEquals(String entityName, String expectedResource, Schema actual) throws JSONException, IOException {
        URL resourceUrl = IndexScannerTestBase.class.getResource(expectedResource);
        JSONAssert.assertEquals((String)IndexScannerTestBase.loadResource(resourceUrl), (String)IndexScannerTestBase.schemaToString(entityName, actual), (boolean)true);
    }

    public static void assertJsonEquals(String expectedResource, OpenAPI actual) throws JSONException, IOException {
        URL resourceUrl = IndexScannerTestBase.class.getResource(expectedResource);
        IndexScannerTestBase.assertJsonEquals(resourceUrl, actual);
    }

    public static void assertJsonEquals(URL expectedResourceUrl, OpenAPI actual) throws JSONException, IOException {
        String json = IndexScannerTestBase.toJSON(actual);
        try {
            JSONAssert.assertEquals((String)IndexScannerTestBase.loadResource(expectedResourceUrl), (String)json, (boolean)true);
        }
        catch (AssertionError e) {
            throw new AssertionError(((Throwable)((Object)e)).getMessage() + "\nFull result:\n" + json, (Throwable)((Object)e));
        }
    }

    public static OpenAPI scan(Class<?> ... classes) {
        return IndexScannerTestBase.scan(IndexScannerTestBase.config(Collections.emptyMap()), null, classes);
    }

    public static OpenAPI scan(InputStream customStaticFile, Class<?> ... classes) {
        return IndexScannerTestBase.scan(IndexScannerTestBase.config(Collections.emptyMap()), customStaticFile, classes);
    }

    public static OpenAPI scan(Config config, InputStream customStaticFile, Class<?> ... classes) {
        return IndexScannerTestBase.scan(config, false, customStaticFile, classes);
    }

    public static OpenAPI scan(Config config, Class<?> ... classes) {
        return IndexScannerTestBase.scan(config, false, null, classes);
    }

    public static OpenAPI scan(Config config, boolean defaultRequiredProperties, InputStream customStaticFile, Class<?> ... classes) {
        Index index = IndexScannerTestBase.indexOf(classes);
        OpenAPI result = SmallRyeOpenAPI.builder().defaultRequiredProperties(defaultRequiredProperties).withCustomStaticFile(() -> customStaticFile).withIndex((IndexView)index).withConfig(config).build().model();
        IndexScannerTestBase.printToConsole(result);
        return result;
    }

    public static void assertJsonEquals(String expectedResource, Class<?> ... classes) throws IOException, JSONException {
        IndexScannerTestBase.assertJsonEquals(expectedResource, IndexScannerTestBase.scan(IndexScannerTestBase.config(Collections.emptyMap()), null, classes));
    }

    public static String loadResource(URL testResource) throws IOException {
        char[] buffer = new char[8192];
        StringBuilder result = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(testResource.openStream(), StandardCharsets.UTF_8);){
            int count;
            while ((count = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                result.append(buffer, 0, count);
            }
        }
        return result.toString();
    }

    public static OpenApiConfig emptyConfig() {
        return IndexScannerTestBase.dynamicConfig(Collections.emptyMap());
    }

    public static OpenApiConfig dynamicConfig(String key, Object value) {
        HashMap<String, String> config = new HashMap<String, String>(1);
        config.put(key, value.toString());
        return IndexScannerTestBase.dynamicConfig(config);
    }

    public static OpenApiConfig failOnDuplicateOperationIdsConfig() {
        return IndexScannerTestBase.dynamicConfig("mp.openapi.extensions.smallrye.duplicateOperationIdBehavior", OpenApiConfig.DuplicateOperationIdBehavior.FAIL.name());
    }

    public static OpenApiConfig dynamicConfig(Map<String, String> properties) {
        return OpenApiConfig.fromConfig((Config)IndexScannerTestBase.config(properties));
    }

    public static Config config(String key, Object value) {
        HashMap<String, String> config = new HashMap<String, String>(1);
        config.put(key, value.toString());
        return IndexScannerTestBase.config(config);
    }

    public static Config config(Map<String, String> properties) {
        return new SmallRyeConfigBuilder().addDefaultSources().withSources(new ConfigSource[]{new PropertiesConfigSource(properties, "unit-test", 100)}).build();
    }
}

