/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiParser;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.json.JSONException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;
import org.yaml.snakeyaml.error.YAMLException;

class OpenApiParserAndSerializerTest {
    static final int REPEAT_BODY_CONTENTS_ITERATIONS = 1536;

    OpenApiParserAndSerializerTest() {
    }

    private static void assertJsonEquals(String expected, String actual) throws JSONException {
        JSONAssert.assertEquals((String)expected, (String)actual, (boolean)true);
    }

    private static void assertYamlEquals(String original, String roundTrip) {
        Assertions.assertEquals((Object)OpenApiParserAndSerializerTest.normalizeYaml(original), (Object)OpenApiParserAndSerializerTest.normalizeYaml(roundTrip));
    }

    private static String normalizeYaml(String yaml) {
        try {
            StringBuilder builder = new StringBuilder();
            BufferedReader reader = new BufferedReader(new StringReader(yaml));
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("--")) {
                    builder.append(line);
                    builder.append("\n");
                }
                line = reader.readLine();
            }
            return builder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path generateBigStaticFile() throws IOException {
        String bigFileHeader = IndexScannerTestBase.loadResource(OpenApiParserAndSerializerTest.class.getResource("openapi-fragment-header.yaml"));
        StringBuilder bigFileContents = new StringBuilder(bigFileHeader);
        String bodyChunk = IndexScannerTestBase.loadResource(OpenApiParserAndSerializerTest.class.getResource("openapi-fragment-body.yaml"));
        for (int i = 0; i < 1536; ++i) {
            bigFileContents.append(bodyChunk.replaceAll("@@ID@@", String.valueOf(i)));
        }
        String bigFileFooter = IndexScannerTestBase.loadResource(OpenApiParserAndSerializerTest.class.getResource("openapi-fragment-footer.yaml"));
        bigFileContents.append(bigFileFooter);
        Path tempFile = Files.createTempFile("sroap-big-file-test-", "-generated.yaml", new FileAttribute[0]);
        Files.write(tempFile, bigFileContents.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return tempFile;
    }

    private static void doTest(URL testResource, Format format, OpenAPI impl) throws IOException, JSONException {
        String original = IndexScannerTestBase.loadResource(testResource);
        String roundTrip = OpenApiSerializer.serialize((OpenAPI)impl, (Format)format);
        try {
            if (format == Format.JSON) {
                OpenApiParserAndSerializerTest.assertJsonEquals(original, roundTrip);
            } else {
                OpenApiParserAndSerializerTest.assertYamlEquals(original, roundTrip);
            }
        }
        catch (AssertionError e) {
            System.out.println("================");
            System.out.println(roundTrip);
            System.out.println("================");
            throw e;
        }
    }

    private static void doTest(String resource, Format format) throws IOException, JSONException {
        URL testResource = OpenApiParserAndSerializerTest.class.getResource(resource);
        OpenAPI impl = OpenApiParser.parse((URL)testResource);
        OpenApiParserAndSerializerTest.doTest(testResource, format, impl);
    }

    private static void doTest(URL testResource, Format format) throws IOException, JSONException {
        OpenAPI impl = OpenApiParser.parse((URL)testResource);
        OpenApiParserAndSerializerTest.doTest(testResource, format, impl);
    }

    @Test
    void testParseSimplest() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("simplest.json", Format.JSON);
    }

    @Test
    void testParseSimplestYaml() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("simplest.yaml", Format.YAML);
    }

    @Test
    void testParseInfo() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("info.json", Format.JSON);
    }

    @Test
    void testParseInfoYaml() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("info.yaml", Format.YAML);
    }

    @Test
    void testExternalDocs() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("externalDocs.json", Format.JSON);
    }

    @Test
    void testExtensions() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("extensions.json", Format.JSON);
    }

    @Test
    void testSecurity() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("security.json", Format.JSON);
    }

    @Test
    void testServers() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("servers.json", Format.JSON);
    }

    @Test
    void testServersYaml() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("servers.yaml", Format.YAML);
    }

    @Test
    void testTags() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("tags.json", Format.JSON);
    }

    @Test
    void testComponents_Callbacks() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-callbacks.json", Format.JSON);
    }

    @Test
    void testComponents_Empty() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-empty.json", Format.JSON);
    }

    @Test
    void testComponents_Examples() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-examples.json", Format.JSON);
    }

    @Test
    void testComponents_Headers() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-headers.json", Format.JSON);
    }

    @Test
    void testComponents_Links() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-links.json", Format.JSON);
    }

    @Test
    void testComponents_Parameters() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-parameters.json", Format.JSON);
    }

    @Test
    void testComponents_RequestBodies() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-requestBodies.json", Format.JSON);
    }

    @Test
    void testComponents_Responses() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-responses.json", Format.JSON);
    }

    @Test
    void testComponents_Schemas() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-schemas.json", Format.JSON);
    }

    @Test
    void testComponents_SecuritySchemes() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-securitySchemes.json", Format.JSON);
    }

    @Test
    void testPaths_AllOperations() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-all-operations.json", Format.JSON);
    }

    @Test
    void testPaths_Empty() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-empty.json", Format.JSON);
    }

    @Test
    void testPaths_GetCallbacks() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-callbacks.json", Format.JSON);
    }

    @Test
    void testPaths_GetParameters() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-parameters.json", Format.JSON);
    }

    @Test
    void testPaths_GetRequestBodyContent() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-requestBody-content.json", Format.JSON);
    }

    @Test
    void testPaths_GetRequestBodyExample() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-requestBody-example.json", Format.JSON);
    }

    @Test
    void testPaths_GetRequestBody() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-requestBody.json", Format.JSON);
    }

    @Test
    void testPaths_GetResponseContent() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-response-content.json", Format.JSON);
    }

    @Test
    void testPaths_GetResponseHeaders() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-response-headers.json", Format.JSON);
    }

    @Test
    void testPaths_GetResponseLinks() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-response-links.json", Format.JSON);
    }

    @Test
    void testPaths_GetResponses() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-responses.json", Format.JSON);
    }

    @Test
    void testPaths_GetSecurity() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-security.json", Format.JSON);
    }

    @Test
    void testPaths_GetServers() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-servers.json", Format.JSON);
    }

    @Test
    void testPaths_Get() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get.json", Format.JSON);
    }

    @Test
    void testPaths_Parameters() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-parameters.json", Format.JSON);
    }

    @Test
    void testPaths_Ref() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-ref.json", Format.JSON);
    }

    @Test
    void testPaths_Servers() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-servers.json", Format.JSON);
    }

    @Test
    void testPaths_Extensions() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-with-extensions.json", Format.JSON);
    }

    @Test
    void testSchemas_Discriminator() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-discriminator.json", Format.JSON);
    }

    @Test
    void testSchemas_AdditionalProperties() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-additionalProperties.json", Format.JSON);
    }

    @Test
    void testSchemas_AllOf() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-allOf.json", Format.JSON);
    }

    @Test
    void testSchemas_Composition() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-composition.json", Format.JSON);
    }

    @Test
    void testSchemas_Example() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-example.json", Format.JSON);
    }

    @Test
    void testSchemas_ExternalDocs() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-externalDocs.json", Format.JSON);
    }

    @Test
    void testSchemas_MetaData() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-metaData.json", Format.JSON);
    }

    @Test
    void testSchemas_XML() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-xml.json", Format.JSON);
    }

    @Test
    void testEverything() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("_everything.json", Format.JSON);
    }

    @Test
    void testEverythingYaml() throws IOException, JSONException {
        OpenApiParserAndSerializerTest.doTest("_everything.yaml", Format.YAML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testParsingBigStaticYamlFile() throws IOException, JSONException {
        Path tempFile = OpenApiParserAndSerializerTest.generateBigStaticFile();
        URL tempFileLoc = tempFile.toUri().toURL();
        Exception thrown = (Exception)Assertions.assertThrows(OpenApiRuntimeException.class, () -> OpenApiParserAndSerializerTest.doTest(tempFileLoc, Format.YAML));
        Assertions.assertNotNull((Object)thrown.getCause());
        Throwable rootCause = thrown.getCause().getCause();
        Assertions.assertTrue((boolean)(rootCause instanceof YAMLException));
        Integer maximumFileSize = 0x800000;
        try {
            System.setProperty("mp.openapi.extensions.smallrye.maximumStaticFileSize", maximumFileSize.toString());
            try (FileInputStream is = new FileInputStream(tempFile.toFile());){
                OpenApiParserAndSerializerTest.doTest(tempFile.toUri().toURL(), Format.YAML, OpenApiParser.parse((InputStream)is, (Format)Format.YAML, null));
            }
        }
        finally {
            System.clearProperty("mp.openapi.extensions.smallrye.maximumStaticFileSize");
        }
    }

    @Test
    void testSerializeLongKeyPreserved() throws IOException {
        OpenAPI doc = OASFactory.createOpenAPI();
        String key = "x-" + new String(new char[1021]).replace('\u0000', 'x');
        Assertions.assertEquals((int)1023, (int)key.length());
        doc.addExtension(key, (Object)"OK");
        String yaml = OpenApiSerializer.serialize((OpenAPI)doc, (Format)Format.YAML);
        Assertions.assertTrue((yaml.indexOf(63) < 0 ? 1 : 0) != 0);
    }

    @Test
    void testSerializeExtraLongKeyConvertsToExplicit() throws IOException {
        OpenAPI doc = OASFactory.createOpenAPI();
        String key = "x-" + new String(new char[1022]).replace('\u0000', 'x');
        Assertions.assertEquals((int)1024, (int)key.length());
        doc.addExtension(key, (Object)"OK");
        String yaml = OpenApiSerializer.serialize((OpenAPI)doc, (Format)Format.YAML);
        Assertions.assertTrue((yaml.indexOf(63) >= 0 ? 1 : 0) != 0);
    }

    @Test
    void testJsonObjectWriter() throws Exception {
        OpenAPI doc = OASFactory.createOpenAPI();
        doc.addExtension("x-foo", (Object)"bar");
        String json = OpenApiSerializer.serialize((OpenAPI)doc, (Format)Format.JSON);
        OpenApiParserAndSerializerTest.assertJsonEquals("{\"x-foo\":\"bar\"}", json);
    }

    @Test
    void testYamlObjectWriter() throws Exception {
        OpenAPI doc = OASFactory.createOpenAPI();
        doc.addExtension("x-foo", (Object)"bar");
        String yaml = OpenApiSerializer.serialize((OpenAPI)doc, (Format)Format.YAML);
        OpenApiParserAndSerializerTest.assertYamlEquals("x-foo: bar", yaml);
    }
}

