/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime;

import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import java.util.UUID;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class OpenApiProcessorTest {
    ClassLoader loader;

    OpenApiProcessorTest() {
    }

    @BeforeEach
    void setup() {
        this.loader = Thread.currentThread().getContextClassLoader();
    }

    @Test
    void testNewInstanceWithNullClassName() {
        Object instance = OpenApiProcessor.newInstance(null, (ClassLoader)this.loader, (IndexView)OpenApiProcessor.EMPTY_INDEX);
        Assertions.assertNull((Object)instance);
    }

    @Test
    void testNewInstanceWithNotFoundClassName() {
        String invalidClassName = UUID.randomUUID().toString();
        Throwable thrown = Assertions.assertThrows(OpenApiRuntimeException.class, () -> OpenApiProcessor.newInstance((String)invalidClassName, (ClassLoader)this.loader, (IndexView)OpenApiProcessor.EMPTY_INDEX));
        Assertions.assertEquals(ClassNotFoundException.class, thrown.getCause().getClass());
    }

    @Test
    void testNewInstanceWithEmptyIndex() {
        IndexAwareObject instance = (IndexAwareObject)OpenApiProcessor.newInstance((String)IndexAwareObject.class.getName(), (ClassLoader)this.loader, (IndexView)OpenApiProcessor.EMPTY_INDEX);
        Assertions.assertNotNull((Object)instance);
        Assertions.assertFalse((boolean)instance.defaultConstructorUsed);
        Assertions.assertEquals((int)0, (int)instance.index.getKnownClasses().size());
    }

    @Test
    void testNewInstanceWithIndexUnsupported() {
        IndexUnawareObject instance = (IndexUnawareObject)OpenApiProcessor.newInstance((String)IndexUnawareObject.class.getName(), (ClassLoader)this.loader, (IndexView)OpenApiProcessor.EMPTY_INDEX);
        Assertions.assertNotNull((Object)instance);
        Assertions.assertTrue((boolean)instance.defaultConstructorUsed);
    }

    static class IndexAwareObject {
        IndexView index;
        boolean defaultConstructorUsed;

        IndexAwareObject() {
            this.defaultConstructorUsed = true;
        }

        IndexAwareObject(IndexView index) {
            this.index = index;
            this.defaultConstructorUsed = false;
        }

        IndexAwareObject(Object other) {
            this.defaultConstructorUsed = false;
        }
    }

    static class IndexUnawareObject {
        boolean defaultConstructorUsed;

        IndexUnawareObject() {
            this.defaultConstructorUsed = true;
        }

        IndexUnawareObject(Object other) {
            this.defaultConstructorUsed = false;
        }
    }
}

