/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.fasterxml.jackson.databind.annotation.EnumNaming;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import java.util.Set;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Test;

class EnumNamingTest
extends IndexScannerTestBase {
    EnumNamingTest() {
    }

    static void test(Class<?> ... classes) throws Exception {
        Index index = EnumNamingTest.indexOf(classes);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(EnumNamingTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        EnumNamingTest.printToConsole(result);
        EnumNamingTest.assertJsonEquals("components.schemas.enum-naming.json", result);
    }

    @Test
    void testEnumNamingDefault() throws Exception {
        @Schema(name="Bean")
        class Bean {
            Set<DaysOfWeekDefault> days;

            Bean() {
            }
        }
        EnumNamingTest.test(Bean.class, DaysOfWeekDefault.class);
    }

    @Test
    void testEnumNamingValueMethod() throws Exception {
        @Schema(name="Bean")
        class Bean {
            Set<DaysOfWeekValue> days;

            Bean() {
            }
        }
        EnumNamingTest.test(Bean.class, DaysOfWeekValue.class);
    }

    @Test
    void testEnumNamingStrategy() throws Exception {
        @Schema(name="Bean")
        class Bean {
            Set<DaysOfWeekStrategy> days;

            Bean() {
            }
        }
        EnumNamingTest.test(Bean.class, DaysOfWeekStrategy.class);
    }

    @Test
    void testEnumNamingProperty() throws Exception {
        @Schema(name="Bean")
        class Bean {
            Set<DaysOfWeekProperty> days;

            Bean() {
            }
        }
        EnumNamingTest.test(Bean.class, DaysOfWeekProperty.class);
    }

    @Schema(name="DaysOfWeek")
    static enum DaysOfWeekProperty {
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY,
        SUNDAY;

    }

    public static class DaysOfWeekShortNaming
    implements EnumNamingStrategy {
        public String convertEnumToExternalName(String enumName) {
            return DaysOfWeekStrategy.valueOf((String)enumName).displayName;
        }
    }

    @Schema(name="DaysOfWeek")
    @EnumNaming(value=DaysOfWeekShortNaming.class)
    static enum DaysOfWeekStrategy {
        MON("Monday"),
        TUE("Tuesday"),
        WED("Wednesday"),
        THU("Thursday"),
        FRI("Friday"),
        SAT("Saturday"),
        SUN("Sunday");

        final String displayName;

        private DaysOfWeekStrategy(String displayName) {
            this.displayName = displayName;
        }
    }

    @Schema(name="DaysOfWeek")
    static enum DaysOfWeekValue {
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY,
        SUNDAY;


        @JsonValue
        public String toValue() {
            String name = this.name();
            return name.charAt(0) + name.substring(1).toLowerCase();
        }
    }

    @Schema(name="DaysOfWeek")
    static enum DaysOfWeekDefault {
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday,
        Sunday;

    }
}

