/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.encoding;

import io.smallrye.openapi.runtime.io.encoding.EncodingReader;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Encoding;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class EncodingReaderTest {
    EncodingReaderTest() {
    }

    @ParameterizedTest
    @CsvSource(value={"io.smallrye.openapi.runtime.io.encoding.EncodingReaderTest$Endpoint1, PIPE_DELIMITED", "io.smallrye.openapi.runtime.io.encoding.EncodingReaderTest$Endpoint2, "})
    void testReadEncodingStyle(Class<?> endpointClass, Encoding.Style expectedStyle) {
        Index index = IndexScannerTestBase.indexOf(endpointClass);
        ClassInfo clazz = index.getClassByName(DotName.createSimple((String)endpointClass.getName()));
        AnnotationInstance annotation = clazz.method("getData", new Type[0]).annotation(DotName.createSimple((String)APIResponse.class.getName())).value("content").asNestedArray()[0].value("encoding").asNestedArray()[0];
        Encoding.Style style = EncodingReader.readEncodingStyle((AnnotationInstance)annotation);
        Assertions.assertEquals((Object)expectedStyle, (Object)style);
    }

    static class Endpoint2 {
        Endpoint2() {
        }

        @APIResponse(content={@Content(encoding={@Encoding(style="invalid")})})
        public String getData() {
            return null;
        }
    }

    static class Endpoint1 {
        Endpoint1() {
        }

        @APIResponse(content={@Content(encoding={@Encoding(style="pipeDelimited")})})
        public String getData() {
            return null;
        }
    }
}

