/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.OpenApiConfig;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OpenApiConfigImplTest {
    private static final String TEST_PROPERTY = "mp.openapi.extensions.OpenApiConfigImplTest";

    OpenApiConfigImplTest() {
    }

    @Test
    void testGetStringConfigValueMissingIsNull() {
        System.clearProperty(TEST_PROPERTY);
        Config config = ConfigProvider.getConfig();
        OpenApiConfig oaiConfig = OpenApiConfig.fromConfig((Config)config);
        Assertions.assertNull((Object)oaiConfig.getConfigValue(TEST_PROPERTY, String.class, () -> null));
    }

    @Test
    void testGetStringConfigValueBlankIsNull() {
        System.setProperty(TEST_PROPERTY, "\t \n\r");
        try {
            Config config = ConfigProvider.getConfig();
            OpenApiConfig oaiConfig = OpenApiConfig.fromConfig((Config)config);
            Assertions.assertNull((Object)oaiConfig.getConfigValue(TEST_PROPERTY, String.class, () -> null));
        }
        finally {
            System.clearProperty(TEST_PROPERTY);
        }
    }

    @Test
    void testGetStringConfigValuePresent() {
        System.setProperty(TEST_PROPERTY, "  VALUE  \t");
        try {
            Config config = ConfigProvider.getConfig();
            OpenApiConfig oaiConfig = OpenApiConfig.fromConfig((Config)config);
            Assertions.assertEquals((Object)"  VALUE  \t", (Object)oaiConfig.getConfigValue(TEST_PROPERTY, String.class, () -> null));
        }
        finally {
            System.clearProperty(TEST_PROPERTY);
        }
    }
}

