/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public final class Annotations {
    private static final String VALUE = "value";

    private Annotations() {
    }

    static Collection<AnnotationInstance> declaredAnnotation(ClassInfo target) {
        return target.classAnnotations();
    }

    static AnnotationInstance declaredAnnotation(ClassInfo target, DotName name) {
        return target.classAnnotation(name);
    }

    public static Collection<AnnotationInstance> getAnnotations(AnnotationTarget target) {
        if (target == null) {
            return Collections.emptyList();
        }
        switch (target.kind()) {
            case CLASS: {
                return Annotations.declaredAnnotation(target.asClass());
            }
            case FIELD: {
                return target.asField().annotations();
            }
            case METHOD: {
                return target.asMethod().annotations();
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = target.asMethodParameter();
                return parameter.method().annotations().stream().filter(a -> Annotations.targetsMethodParameter(a, parameter.position())).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public static AnnotationInstance getDeclaredAnnotation(AnnotationTarget target, DotName name) {
        AnnotationInstance annotation;
        if (target == null) {
            return null;
        }
        switch (target.kind()) {
            case CLASS: {
                annotation = Annotations.declaredAnnotation(target.asClass(), name);
                break;
            }
            case FIELD: {
                annotation = target.asField().annotations().stream().filter(a -> name.equals((Object)a.name())).filter(a -> target.equals(a.target())).findFirst().orElse(null);
                break;
            }
            case METHOD: {
                annotation = target.asMethod().annotations(name).stream().filter(a -> target.equals(a.target())).findFirst().orElse(null);
                break;
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = target.asMethodParameter();
                annotation = parameter.method().annotations(name).stream().filter(a -> Annotations.targetsMethodParameter(a, parameter.position())).findFirst().orElse(null);
                break;
            }
            case RECORD_COMPONENT: {
                annotation = target.asRecordComponent().annotation(name);
                break;
            }
            default: {
                annotation = null;
            }
        }
        return annotation;
    }

    public static <T> T value(AnnotationInstance annotation) {
        return annotation != null ? (T)Annotations.value(annotation, VALUE) : null;
    }

    public static <T> T value(AnnotationInstance annotation, String name) {
        AnnotationValue value = annotation.value(name);
        if (value == null) {
            return null;
        }
        boolean isArray = AnnotationValue.Kind.ARRAY == value.kind();
        switch (isArray ? value.componentKind() : value.kind()) {
            case BOOLEAN: {
                return (T)(isArray ? value.asBooleanArray() : (boolean[])value.asBoolean());
            }
            case BYTE: {
                return (T)(isArray ? value.asByteArray() : (byte[])value.asByte());
            }
            case CHARACTER: {
                return (T)(isArray ? value.asCharArray() : (char[])Character.valueOf(value.asChar()));
            }
            case CLASS: {
                return (T)(isArray ? value.asClassArray() : value.asClass());
            }
            case DOUBLE: {
                return (T)(isArray ? value.asDoubleArray() : (double[])value.asDouble());
            }
            case ENUM: {
                return (T)(isArray ? value.asEnumArray() : value.asEnum());
            }
            case FLOAT: {
                return (T)(isArray ? value.asFloatArray() : (float[])Float.valueOf(value.asFloat()));
            }
            case INTEGER: {
                return (T)(isArray ? value.asIntArray() : (int[])value.asInt());
            }
            case LONG: {
                return (T)(isArray ? value.asLongArray() : (long[])value.asLong());
            }
            case NESTED: {
                return (T)(isArray ? value.asNestedArray() : value.asNested());
            }
            case SHORT: {
                return (T)(isArray ? value.asShortArray() : (short[])value.asShort());
            }
            case STRING: {
                return (T)(isArray ? value.asStringArray() : value.asString());
            }
        }
        return null;
    }

    public static <T> T value(AnnotationInstance annotation, String name, T defaultValue) {
        T value = Annotations.value(annotation, name);
        return value != null ? value : defaultValue;
    }

    public static <T extends Enum<T>> T enumValue(AnnotationInstance annotation, String propertyName, Class<T> clazz) {
        String value;
        String string = value = annotation != null ? (String)Annotations.value(annotation, propertyName) : null;
        if (value == null) {
            return null;
        }
        return (T)((Enum)Stream.of((Enum[])clazz.getEnumConstants()).filter(c -> c.name().equals(value)).findFirst().orElse(null));
    }

    public static List<AnnotationInstance> getParameterAnnotations(MethodInfo method, short paramPosition) {
        return method.annotations().stream().filter(a -> Annotations.targetsMethodParameter(a, paramPosition)).collect(Collectors.toList());
    }

    public static List<AnnotationInstance> getRepeatableAnnotation(AnnotationTarget target, DotName singleAnnotationName, DotName repeatableAnnotationName) {
        AnnotationInstance[] nestedArray;
        ArrayList<AnnotationInstance> annotations = new ArrayList<AnnotationInstance>();
        AnnotationInstance annotation = Annotations.getAnnotation(target, singleAnnotationName);
        if (annotation != null) {
            annotations.add(annotation);
        }
        if (repeatableAnnotationName != null && (nestedArray = (AnnotationInstance[])Annotations.getAnnotationValue(target, repeatableAnnotationName, VALUE)) != null) {
            Arrays.stream(nestedArray).map(a -> AnnotationInstance.create((DotName)a.name(), (AnnotationTarget)target, (List)a.values())).forEach(annotations::add);
        }
        return annotations;
    }

    public static AnnotationInstance getMethodParameterAnnotation(MethodInfo method, int parameterIndex, DotName annotationName) {
        return method.annotations(annotationName).stream().filter(a -> Annotations.targetsMethodParameter(a, parameterIndex)).findFirst().orElse(null);
    }

    public static AnnotationInstance getMethodParameterAnnotation(MethodInfo method, Type parameterType, DotName annotationName) {
        int parameterIndex = method.parameterTypes().indexOf(parameterType);
        return Annotations.getMethodParameterAnnotation(method, parameterIndex, annotationName);
    }

    public static List<AnnotationInstance> getMethodParameterAnnotations(MethodInfo method, Type parameterType) {
        int parameterIndex = method.parameterTypes().indexOf(parameterType);
        return method.annotations().stream().filter(a -> Annotations.targetsMethodParameter(a, parameterIndex)).collect(Collectors.toList());
    }

    public static boolean hasAnnotation(AnnotationTarget target, Collection<DotName> annotationNames) {
        for (DotName dn : annotationNames) {
            if (!Annotations.hasAnnotation(target, dn)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(AnnotationTarget target, DotName annotationName) {
        if (target == null) {
            return false;
        }
        switch (target.kind()) {
            case CLASS: {
                return Annotations.declaredAnnotation(target.asClass(), annotationName) != null;
            }
            case FIELD: {
                return target.asField().hasAnnotation(annotationName);
            }
            case METHOD: {
                return target.asMethod().hasAnnotation(annotationName);
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = target.asMethodParameter();
                return parameter.method().annotations().stream().filter(a -> Annotations.targetsMethodParameter(a, parameter.position())).anyMatch(a -> a.name().equals((Object)annotationName));
            }
        }
        return false;
    }

    public static AnnotationInstance getAnnotation(AnnotationTarget annotationTarget, DotName annotationName) {
        return Annotations.getAnnotations(annotationTarget).stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    public static AnnotationInstance getAnnotation(AnnotationTarget annotationTarget, Collection<DotName> annotationNames) {
        return Annotations.getAnnotations(annotationTarget).stream().filter(annotation -> annotationNames.contains(annotation.name())).findFirst().orElse(null);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames) {
        return Annotations.getAnnotationValue(target, annotationNames, VALUE, null);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName, String propertyName) {
        return Annotations.getAnnotationValue(target, Arrays.asList(annotationName), propertyName);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames, String propertyName) {
        return Annotations.getAnnotationValue(target, annotationNames, propertyName, null);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames, String propertyName, T defaultValue) {
        AnnotationInstance annotation = Annotations.getAnnotation(target, annotationNames);
        T value = null;
        if (annotation != null) {
            value = Annotations.value(annotation, propertyName);
        }
        return value != null ? value : (T)defaultValue;
    }

    public static <T> T getDeclaredAnnotationValue(AnnotationTarget type, DotName annotationName, String propertyName) {
        AnnotationInstance annotation = Annotations.getDeclaredAnnotation(type, annotationName);
        T value = null;
        if (annotation != null) {
            value = Annotations.value(annotation, propertyName);
        }
        return value;
    }

    public static <T> T getDeclaredAnnotationValue(AnnotationTarget type, DotName annotationName) {
        return Annotations.getDeclaredAnnotationValue(type, annotationName, VALUE);
    }

    static boolean targetsMethodParameter(AnnotationInstance annotation, int position) {
        AnnotationTarget target = annotation.target();
        return target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER && target.asMethodParameter().position() == position;
    }
}

