/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.OpenApiDataObjectScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import java.io.IOException;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class OpenApiDataObjectScannerTest {
    OpenApiDataObjectScanner target;

    OpenApiDataObjectScannerTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
    }

    @ParameterizedTest
    @CsvSource(value={"java.util.stream.DoubleStream, NUMBER,  double", "java.util.stream.IntStream   , INTEGER, int32", "java.util.stream.LongStream  , INTEGER, int64", "java.util.stream.Stream      ,        , "})
    void testStreams(String type, Schema.SchemaType itemType, String itemFormat) throws IOException {
        Index index = Index.of((Class[])new Class[0]);
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)index, Thread.currentThread().getContextClassLoader(), IndexScannerTestBase.emptyConfig());
        Schema out = OpenApiDataObjectScanner.process((AnnotationScannerContext)context, (Type)Type.create((DotName)DotName.createSimple((String)type), (Type.Kind)Type.Kind.CLASS));
        Assertions.assertEquals((Object)Schema.SchemaType.ARRAY, (Object)out.getType());
        Assertions.assertEquals((Object)itemType, (Object)out.getItems().getType());
        Assertions.assertEquals((Object)itemFormat, (Object)out.getItems().getFormat());
    }
}

