/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactoryBuilder;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.IoMessages;
import io.smallrye.openapi.runtime.io.definition.DefinitionReader;
import io.smallrye.openapi.runtime.io.schema.SchemaReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.yaml.snakeyaml.LoaderOptions;

public class OpenApiParser {
    private final JsonNode tree;

    public static final OpenAPI parse(URL url) throws IOException {
        OpenAPI openAPI;
        block11: {
            boolean isYaml;
            String fname = url.getFile();
            if (fname == null) {
                throw IoMessages.msg.noFileName(url.toURI().toString());
            }
            int lidx = fname.lastIndexOf(46);
            if (lidx == -1 || lidx >= fname.length()) {
                throw IoMessages.msg.invalidFileName(url.toURI().toString());
            }
            String ext = fname.substring(lidx + 1);
            boolean isJson = ext.equalsIgnoreCase("json");
            boolean bl = isYaml = ext.equalsIgnoreCase("yaml") || ext.equalsIgnoreCase("yml");
            if (!isJson && !isYaml) {
                throw IoMessages.msg.invalidFileExtension(url.toURI().toString());
            }
            InputStream stream = url.openStream();
            try {
                openAPI = OpenApiParser.parse(stream, isJson ? Format.JSON : Format.YAML);
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
            stream.close();
        }
        return openAPI;
    }

    public static final OpenAPI parse(InputStream stream, Format format, Integer maximumStaticFileSize) throws IOException {
        ObjectMapper mapper;
        if (format == Format.JSON) {
            mapper = new ObjectMapper();
        } else {
            LoaderOptions loaderOptions = new LoaderOptions();
            if (maximumStaticFileSize != null) {
                loaderOptions.setCodePointLimit(maximumStaticFileSize.intValue());
            }
            mapper = new ObjectMapper((JsonFactory)new YAMLFactoryBuilder(new YAMLFactory()).loaderOptions(loaderOptions).build());
        }
        JsonNode tree = mapper.readTree(stream);
        OpenApiParser parser = new OpenApiParser(tree);
        return parser.parse();
    }

    public static final OpenAPI parse(InputStream stream, Format format) throws IOException {
        return OpenApiParser.parse(stream, format, null);
    }

    public static final Schema parseSchema(String schemaJson) {
        JsonNode tree;
        ObjectMapper mapper = new ObjectMapper();
        try {
            tree = mapper.readTree(schemaJson);
        }
        catch (JsonProcessingException e) {
            throw new OpenApiRuntimeException("Exception parsing JSON Schema representation", e);
        }
        return SchemaReader.readSchema(tree);
    }

    public OpenApiParser(JsonNode tree) {
        this.tree = tree;
    }

    private OpenAPI parse() {
        OpenAPIImpl oai = new OpenAPIImpl();
        DefinitionReader.processDefinition(oai, this.tree);
        return oai;
    }
}

