/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.schema;

import io.smallrye.openapi.api.util.ClassLoaderUtil;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.WildcardType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SchemaFactoryTest
extends IndexScannerTestBase {
    SchemaFactoryTest() {
    }

    @Test
    void testResolveAsyncType() {
        Index index = SchemaFactoryTest.indexOf(new Class[0]);
        Type STRING_TYPE = Type.create((DotName)DotName.createSimple((String)String.class.getName()), (Type.Kind)Type.Kind.CLASS);
        ParameterizedType target = ParameterizedType.create((DotName)DotName.createSimple((String)CompletableFuture.class.getName()), (Type[])new Type[]{STRING_TYPE}, null);
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)index, ClassLoaderUtil.getDefaultClassLoader(), SchemaFactoryTest.emptyConfig());
        Type result = SchemaFactory.resolveAsyncType((AnnotationScannerContext)context, (Type)target, Collections.emptyList());
        Assertions.assertEquals((Object)STRING_TYPE, (Object)result);
    }

    @Test
    void testWildcardSchemaIsEmpty() {
        Index index = SchemaFactoryTest.indexOf(new Class[0]);
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)index, ClassLoaderUtil.getDefaultClassLoader(), SchemaFactoryTest.emptyConfig());
        WildcardType type = WildcardType.create(null, (boolean)false);
        Schema result = SchemaFactory.typeToSchema((AnnotationScannerContext)context, (Type)type, null, Collections.emptyList());
        Assertions.assertNull((Object)result.getType());
    }

    @Test
    void testParseSchemaType() {
        for (SchemaType type : SchemaType.values()) {
            if (type == SchemaType.DEFAULT) {
                Assertions.assertNull((Object)SchemaFactory.parseSchemaType((String)type.name()));
                continue;
            }
            Assertions.assertEquals((Object)Schema.SchemaType.valueOf((String)type.name()), (Object)SchemaFactory.parseSchemaType((String)type.name()));
        }
    }
}

