/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.config.ConfigValuePropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.parameters.ParameterImpl;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.json.JSONException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.skyscreamer.jsonassert.JSONAssert;

public class IndexScannerTestBase {
    private static final Logger LOG = Logger.getLogger(IndexScannerTestBase.class);
    static final Pattern PATTERN_CLASS_DOTNAME_COMPONENTIZE = Pattern.compile("([\\.$]|$)");

    @AfterEach
    public void removeSchemaRegistry() {
        SchemaRegistry.remove();
        CurrentScannerInfo.remove();
    }

    protected static String pathOf(Class<?> clazz) {
        return clazz.getName().replace('.', '/').concat(".class");
    }

    protected static void indexDirectory(Indexer indexer, String baseDir) {
        InputStream directoryStream = IndexScannerTestBase.tcclGetResourceAsStream(baseDir);
        BufferedReader reader = new BufferedReader(new InputStreamReader(directoryStream));
        reader.lines().filter(resName -> resName.endsWith(".class")).map(resName -> Paths.get(baseDir, resName)).forEach(path -> IndexScannerTestBase.index(indexer, path.toString()));
    }

    private static InputStream tcclGetResourceAsStream(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    public static Index indexOf(Class<?> ... classes) {
        Indexer indexer = new Indexer();
        for (Class<?> klazz : classes) {
            IndexScannerTestBase.index(indexer, IndexScannerTestBase.pathOf(klazz));
        }
        return indexer.complete();
    }

    protected static void index(Indexer indexer, String resName) {
        try {
            InputStream stream = IndexScannerTestBase.tcclGetResourceAsStream(resName);
            indexer.index(stream);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    protected static DotName componentize(String className) {
        Matcher matcher = PATTERN_CLASS_DOTNAME_COMPONENTIZE.matcher(className);
        String previousDelimiter = null;
        int previousEnd = 0;
        DotName name = null;
        while (matcher.find()) {
            String localName = className.substring(previousEnd, matcher.start());
            boolean innerClass = "$".equals(previousDelimiter);
            name = DotName.createComponentized(name, (String)localName, (boolean)innerClass);
            previousDelimiter = matcher.group();
            previousEnd = matcher.end();
        }
        return name;
    }

    public static void printToConsole(String entityName, Schema schema) throws IOException {
        LOG.debug((Object)IndexScannerTestBase.schemaToString(entityName, schema));
        System.out.println(IndexScannerTestBase.schemaToString(entityName, schema));
    }

    public static void printToConsole(OpenAPI oai) throws IOException {
        LOG.debug((Object)OpenApiSerializer.serialize((OpenAPI)oai, (Format)Format.JSON));
        System.out.println(OpenApiSerializer.serialize((OpenAPI)oai, (Format)Format.JSON));
    }

    public static void verifyMethodAndParamRefsPresent(OpenAPI oai) {
        if (oai.getPaths() != null && oai.getPaths().getPathItems() != null) {
            for (Map.Entry pathItemEntry : oai.getPaths().getPathItems().entrySet()) {
                PathItem pathItem = (PathItem)pathItemEntry.getValue();
                if (pathItem.getOperations() == null) continue;
                for (Map.Entry operationEntry : pathItem.getOperations().entrySet()) {
                    Operation operation = (Operation)operationEntry.getValue();
                    String opRef = operationEntry.getKey() + " " + (String)pathItemEntry.getKey();
                    Assertions.assertNotNull((Object)OperationImpl.getMethodRef((Operation)operation), (String)("methodRef: " + opRef));
                    if (operation.getParameters() == null) continue;
                    for (Parameter parameter : operation.getParameters()) {
                        if (IndexScannerTestBase.isPathMatrixObject(parameter)) continue;
                        String pRef = opRef + ", " + parameter.getIn() + ": " + parameter.getName();
                        Assertions.assertNotNull((Object)ParameterImpl.getParamRef((Parameter)parameter), (String)("paramRef: " + pRef));
                    }
                }
            }
        }
    }

    private static boolean isPathMatrixObject(Parameter parameter) {
        return parameter.getIn() == Parameter.In.PATH && parameter.getStyle() == Parameter.Style.MATRIX && parameter.getSchema() != null && parameter.getSchema().getType() == Schema.SchemaType.OBJECT;
    }

    public static String schemaToString(String entityName, Schema schema) throws IOException {
        HashMap<String, Schema> map = new HashMap<String, Schema>();
        map.put(entityName, schema);
        OpenAPIImpl oai = new OpenAPIImpl();
        ComponentsImpl comp = new ComponentsImpl();
        comp.setSchemas(map);
        oai.setComponents((Components)comp);
        return OpenApiSerializer.serialize((OpenAPI)oai, (Format)Format.JSON);
    }

    public static void assertJsonEquals(String entityName, String expectedResource, Schema actual) throws JSONException, IOException {
        URL resourceUrl = IndexScannerTestBase.class.getResource(expectedResource);
        JSONAssert.assertEquals((String)IndexScannerTestBase.loadResource(resourceUrl), (String)IndexScannerTestBase.schemaToString(entityName, actual), (boolean)true);
    }

    public static void assertJsonEquals(String expectedResource, OpenAPI actual) throws JSONException, IOException {
        URL resourceUrl = IndexScannerTestBase.class.getResource(expectedResource);
        IndexScannerTestBase.assertJsonEquals(resourceUrl, actual);
    }

    public static void assertJsonEquals(URL expectedResourceUrl, OpenAPI actual) throws JSONException, IOException {
        JSONAssert.assertEquals((String)IndexScannerTestBase.loadResource(expectedResourceUrl), (String)OpenApiSerializer.serialize((OpenAPI)actual, (Format)Format.JSON), (boolean)true);
    }

    public static void assertJsonEquals(String expectedResource, Class<?> ... classes) throws IOException, JSONException {
        Index index = IndexScannerTestBase.indexOf(classes);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(IndexScannerTestBase.dynamicConfig(new HashMap<String, String>()), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        IndexScannerTestBase.printToConsole(result);
        IndexScannerTestBase.assertJsonEquals(expectedResource, result);
    }

    public static String loadResource(URL testResource) throws IOException {
        return IOUtils.toString((URL)testResource, (String)"UTF-8");
    }

    public static OpenApiConfig emptyConfig() {
        return IndexScannerTestBase.dynamicConfig(Collections.emptyMap());
    }

    public static OpenApiConfig dynamicConfig(String key, Object value) {
        HashMap<String, String> config = new HashMap<String, String>(1);
        config.put(key, value.toString());
        return IndexScannerTestBase.dynamicConfig(config);
    }

    public static OpenApiConfig failOnDuplicateOperationIdsConfig() {
        return IndexScannerTestBase.dynamicConfig("mp.openapi.extensions.smallrye.duplicateOperationIdBehavior", OpenApiConfig.DuplicateOperationIdBehavior.FAIL.name());
    }

    public static OpenApiConfig dynamicConfig(Map<String, String> properties) {
        SmallRyeConfig config = new SmallRyeConfigBuilder().withSources(new ConfigSource[]{new ConfigValuePropertiesConfigSource(properties, "unit-test", 100)}).build();
        return OpenApiConfig.fromConfig((Config)config);
    }
}

