/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.util.FilterUtil;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiParser;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.json.JSONException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

class FilterUtilTest {
    FilterUtilTest() {
    }

    private static String loadResource(URL testResource) throws IOException {
        return IOUtils.toString((URL)testResource, (String)"UTF-8");
    }

    private static void assertJsonEquals(String expected, String actual) throws JSONException {
        JSONAssert.assertEquals((String)expected, (String)actual, (boolean)true);
    }

    @Test
    void testApplyFilter() throws Exception {
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        URL beforeUrl = FilterUtilTest.class.getResource("filter-before.json");
        URL afterUrl = FilterUtilTest.class.getResource("filter-after.json");
        OpenAPI model = OpenApiParser.parse((URL)beforeUrl);
        OpenApiDocument document = OpenApiDocument.INSTANCE;
        document.reset();
        document.config((OpenApiConfig)openApiConfig);
        document.modelFromReader(model);
        OASFilter f1 = this.filter();
        OASFilter f2 = this.filter();
        OASFilter f3 = new OASFilter(){

            public void filterOpenAPI(OpenAPI openAPI) {
                openAPI.addServer(OASFactory.createServer().url("urn:server3"));
            }
        };
        OASFilter f4 = new OASFilter(){

            public void filterOpenAPI(OpenAPI openAPI) {
                openAPI.addServer(OASFactory.createServer().url("urn:server4"));
            }
        };
        document.filter(f1);
        document.filter(f2);
        document.filter(f3);
        document.filter(f4);
        document.initialize();
        model = document.get();
        String actual = OpenApiSerializer.serialize((OpenAPI)model, (Format)Format.JSON);
        String expected = FilterUtilTest.loadResource(afterUrl);
        FilterUtilTest.assertJsonEquals(expected, actual);
    }

    @Test
    void testCyclicReferencesSafe() {
        Schema schema1 = OASFactory.createSchema();
        Schema schema2 = OASFactory.createSchema();
        Schema schema3 = OASFactory.createSchema();
        schema1.addAllOf(schema2);
        schema2.addAllOf(schema3);
        schema3.addAllOf(schema1);
        Schema schema4 = OASFactory.createSchema();
        schema4.addProperty("prop1", schema1);
        schema4.addProperty("prop4", schema4);
        Schema schema5 = OASFactory.createSchema();
        schema5.setNot(schema5);
        OpenAPI model = OASFactory.createOpenAPI().info(OASFactory.createInfo()).components(OASFactory.createComponents().addSchema("Schema1", schema1).addSchema("Schema2", schema2).addSchema("Schema3", schema3).addSchema("Schema4", schema4).addSchema("Schema5", schema5));
        Assertions.assertDoesNotThrow(() -> FilterUtil.applyFilter((OASFilter)this.filter(), (OpenAPI)model));
    }

    private OASFilter filter() {
        return new OASFilter(){

            public void filterOpenAPI(OpenAPI openAPI) {
                openAPI.getInfo().setLicense(null);
                openAPI.getInfo().setTitle("Updated API Title");
            }

            public Tag filterTag(Tag tag) {
                if (tag.getName().equals("tag-1")) {
                    return null;
                }
                return tag;
            }

            public PathItem filterPathItem(PathItem pathItem) {
                if (pathItem.getRef() != null) {
                    return null;
                }
                return pathItem;
            }

            public Operation filterOperation(Operation operation) {
                if (operation.getTags() != null && operation.getTags().contains("tag-1")) {
                    operation.removeTag("tag-1");
                }
                return operation;
            }
        };
    }
}

