/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.JsonIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public abstract class ModelIO<T, V, A extends V, O extends V, AB, OB> {
    private final IOContext<V, A, O, AB, OB> context;
    protected final DotName annotationName;
    protected final DotName modelName;

    protected ModelIO(IOContext<V, A, O, AB, OB> context, DotName annotationName, DotName modelName) {
        this.context = context;
        this.annotationName = annotationName;
        this.modelName = modelName;
    }

    public JsonIO<V, A, O, AB, OB> jsonIO() {
        return this.context.jsonIO();
    }

    public AnnotationScannerContext scannerContext() {
        return this.context.scannerContext();
    }

    protected void setIfPresent(OB object, String key, Optional<? extends V> valueSource) {
        valueSource.ifPresent(value -> this.jsonIO().set(object, key, value));
    }

    protected void setAllIfPresent(OB object, Optional<? extends O> valueSource) {
        valueSource.ifPresent(value -> this.jsonIO().setAll(object, value));
    }

    protected Optional<OB> optionalJsonObject(Object source) {
        if (source == null) {
            return Optional.empty();
        }
        return Optional.of(this.jsonIO().createObject());
    }

    protected Optional<AB> optionalJsonArray(Object source) {
        if (source == null) {
            return Optional.empty();
        }
        return Optional.of(this.jsonIO().createArray());
    }

    protected static <T> Map.Entry<String, T> entry(String key, T value) {
        return new AbstractMap.SimpleEntry<String, T>(key, value);
    }

    protected <P> P value(AnnotationInstance annotation, String propertyName) {
        return (P)this.scannerContext().annotations().value(annotation, propertyName);
    }

    protected <P> P value(AnnotationInstance annotation, String propertyName, P defaultValue) {
        return this.scannerContext().annotations().value(annotation, propertyName, defaultValue);
    }

    protected <P extends Enum<P>> P enumValue(AnnotationInstance annotation, String propertyName, Class<P> type) {
        return this.scannerContext().annotations().enumValue(annotation, propertyName, type);
    }

    protected <P extends Enum<P>> P enumValue(V value, Class<P> type) {
        String strValue = this.jsonIO().asString(value);
        if (strValue != null) {
            try {
                return Enum.valueOf(type, strValue.toUpperCase(Locale.ROOT));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected Optional<String> getName(AnnotationInstance annotation, String nameProperty) {
        String name = (String)this.value(annotation, nameProperty);
        if (name == null && JandexUtil.isRef(annotation)) {
            name = JandexUtil.nameFromRef(annotation);
        }
        return Optional.ofNullable(name);
    }

    protected Optional<String> getName(AnnotationInstance annotation) {
        return this.getName(annotation, "name");
    }

    protected static <T> Predicate<T> not(Predicate<? super T> predicate) {
        return predicate.negate();
    }

    protected static <T> Collector<Map.Entry<String, T>, ?, Map<String, T>> toLinkedMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new);
    }

    public AnnotationInstance getAnnotation(AnnotationTarget target) {
        return this.scannerContext().annotations().getAnnotation(target, this.annotationName);
    }

    public List<AnnotationInstance> getRepeatableAnnotations(AnnotationTarget target) {
        return this.scannerContext().annotations().getRepeatableAnnotation(target, this.annotationName, Names.containerOf(this.annotationName));
    }

    public boolean hasRepeatableAnnotation(AnnotationTarget target) {
        return this.scannerContext().annotations().hasAnnotation(target, this.annotationName, Names.containerOf(this.annotationName));
    }

    public T read(AnnotationTarget target) {
        return Optional.ofNullable(this.getAnnotation(target)).map(this::read).orElse(null);
    }

    public T read(AnnotationValue annotation) {
        return Optional.ofNullable(annotation).map(AnnotationValue::asNested).map(this::read).orElse(null);
    }

    public abstract T read(AnnotationInstance var1);

    public T readValue(V node) {
        return Optional.ofNullable(node).filter(this.jsonIO()::isObject).map(this.jsonIO()::asObject).map(this::readObject).orElse(null);
    }

    public abstract T readObject(O var1);

    public abstract Optional<O> write(T var1);
}

