/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JacksonJsonIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface JsonIO<V, A extends V, O extends V, AB, OB> {
    public static <V, A extends V, O extends V, AB, OB> JsonIO<V, A, O, AB, OB> newInstance(OpenApiConfig config) {
        JacksonJsonIO jackson = new JacksonJsonIO(config);
        return jackson;
    }

    default public Object parseValue(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String trimmedValue = value.trim();
        switch (trimmedValue.charAt(0)) {
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '[': 
            case '{': {
                try {
                    return this.fromJson(this.fromString(trimmedValue, Format.JSON));
                }
                catch (Exception e) {
                    IoLogging.logger.unparseableJson(trimmedValue);
                    break;
                }
            }
            case 't': {
                return "true".equals(trimmedValue) ? Boolean.TRUE : value;
            }
            case 'f': {
                return "false".equals(trimmedValue) ? Boolean.FALSE : value;
            }
        }
        return value;
    }

    public boolean isArray(V var1);

    public A asArray(V var1);

    public List<V> entries(A var1);

    public boolean isObject(V var1);

    public O asObject(V var1);

    public boolean hasKey(O var1, String var2);

    public Set<Map.Entry<String, V>> properties(O var1);

    public boolean isString(V var1);

    public String asString(V var1);

    default public String getString(V object, String key) {
        if (this.isObject(object)) {
            return this.getJsonString(this.asObject(object), key);
        }
        return null;
    }

    default public Integer getInt(V object, String key) {
        if (this.isObject(object)) {
            return this.getJsonInt(this.asObject(object), key);
        }
        return null;
    }

    default public Boolean getBoolean(V object, String key) {
        if (this.isObject(object)) {
            return this.getJsonBoolean(this.asObject(object), key);
        }
        return null;
    }

    default public BigDecimal getBigDecimal(V object, String key) {
        if (this.isObject(object)) {
            return this.getJsonBigDecimal(this.asObject(object), key);
        }
        return null;
    }

    public Integer getJsonInt(O var1, String var2);

    public String getJsonString(O var1, String var2);

    public Boolean getJsonBoolean(O var1, String var2);

    public BigDecimal getJsonBigDecimal(O var1, String var2);

    public V getValue(O var1, String var2);

    public Optional<A> getArray(O var1, String var2);

    default public <T> Optional<List<T>> getArray(O object, String key, Function<V, T> valueMapper) {
        return this.getArray(object, key).map(this::entries).map(entries -> entries.stream().map(valueMapper).collect(Collectors.toList()));
    }

    public Optional<O> getObject(O var1, String var2);

    default public Optional<V> toJson(Object object) {
        return Optional.ofNullable(this.toJson(object, null));
    }

    public Object fromJson(V var1);

    public V toJson(Object var1, V var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public V fromString(String value, Format format) {
        try (StringReader reader = new StringReader(value);){
            V v = this.fromReader(reader, format);
            return v;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public V fromStream(InputStream stream, Format format) {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            V v = this.fromReader(reader, format);
            return v;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public V fromReader(Reader reader) throws IOException {
        return this.fromReader(reader, Format.YAML);
    }

    public V fromReader(Reader var1, Format var2) throws IOException;

    public String toString(V var1, Format var2);

    public AB createArray();

    public void add(AB var1, V var2);

    public A buildArray(AB var1);

    public OB createObject();

    public void set(OB var1, String var2, V var3);

    public void setAll(OB var1, O var2);

    public O buildObject(OB var1);
}

