/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.ApiLogging;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.JsonIO;
import io.smallrye.openapi.runtime.io.OpenAPIDefinitionIO;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.Type;

public class SmallRyeOpenAPI {
    private final OpenAPI model;
    private final Object jsonModel;
    private final BiFunction<? super Object, Format, String> toString;

    private SmallRyeOpenAPI(OpenAPI model, Object jsonModel, BiFunction<?, Format, String> toString) {
        this.model = model;
        this.jsonModel = jsonModel;
        this.toString = toString;
    }

    public OpenAPI model() {
        return this.model;
    }

    public String toJSON() {
        return this.toString.apply(this.jsonModel, Format.JSON);
    }

    public String toYAML() {
        return this.toString.apply(this.jsonModel, Format.YAML);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final IndexView EMPTY_INDEX = new Indexer().complete();
        private Config config;
        private ClassLoader applicationClassLoader;
        private OpenAPI initialModel;
        private boolean enableModelReader = true;
        private boolean enableStandardStaticFiles = true;
        private Function<String, URL> resourceLocator;
        private Supplier<InputStream> customStaticFile = () -> null;
        private boolean defaultRequiredProperties = true;
        private IndexView index = EMPTY_INDEX;
        private boolean enableAnnotationScan = true;
        private boolean enableUnannotatedPathParameters = false;
        private ClassLoader scannerClassLoader;
        private Predicate<String> scannerFilter = n -> true;
        private Function<Collection<ClassInfo>, String> contextRootResolver = apps -> null;
        private UnaryOperator<Type> typeConverter = UnaryOperator.identity();
        private Function<String, Object> jsonParser = null;
        private Function<String, Schema> schemaParser = null;
        private boolean enableStandardFilter = true;
        private Map<String, OASFilter> filters = new LinkedHashMap<String, OASFilter>();

        private Builder() {
        }

        public Builder withConfig(Config config) {
            this.config = Objects.requireNonNull(config);
            return this;
        }

        public Builder withApplicationClassLoader(ClassLoader classLoader) {
            this.applicationClassLoader = Objects.requireNonNull(classLoader);
            return this;
        }

        public Builder withInitialModel(OpenAPI initialModel) {
            this.initialModel = initialModel;
            return this;
        }

        public Builder enableModelReader(boolean enableModelReader) {
            this.enableModelReader = enableModelReader;
            return this;
        }

        public Builder enableStandardStaticFiles(boolean enableStandardStaticFiles) {
            this.enableStandardStaticFiles = enableStandardStaticFiles;
            return this;
        }

        public Builder enableStandardFilter(boolean enableStandardFilter) {
            this.enableStandardFilter = enableStandardFilter;
            return this;
        }

        public Builder defaultRequiredProperties(boolean defaultRequiredProperties) {
            this.defaultRequiredProperties = defaultRequiredProperties;
            return this;
        }

        public Builder withResourceLocator(Function<String, URL> resourceLocator) {
            this.resourceLocator = resourceLocator;
            return this;
        }

        public Builder withCustomStaticFile(Supplier<InputStream> customStaticFile) {
            this.customStaticFile = Objects.requireNonNull(customStaticFile);
            return this;
        }

        public Builder withIndex(IndexView index) {
            this.index = Objects.requireNonNull(index);
            return this;
        }

        public Builder withContextRootResolver(Function<Collection<ClassInfo>, String> contextRootResolver) {
            this.contextRootResolver = Objects.requireNonNull(contextRootResolver);
            return this;
        }

        public Builder withTypeConverter(UnaryOperator<Type> typeConverter) {
            this.typeConverter = Objects.requireNonNull(typeConverter);
            return this;
        }

        public Builder withJsonParser(Function<String, Object> jsonParser) {
            this.jsonParser = jsonParser;
            return this;
        }

        public Builder withSchemaParser(Function<String, Schema> schemaParser) {
            this.schemaParser = schemaParser;
            return this;
        }

        public Builder enableAnnotationScan(boolean enableAnnotationScan) {
            this.enableAnnotationScan = enableAnnotationScan;
            return this;
        }

        public Builder enableUnannotatedPathParameters(boolean enableUnannotatedPathParameters) {
            this.enableUnannotatedPathParameters = enableUnannotatedPathParameters;
            return this;
        }

        public Builder withScannerClassLoader(ClassLoader scannerClassLoader) {
            this.scannerClassLoader = scannerClassLoader;
            return this;
        }

        public Builder withScannerFilter(Predicate<String> scannerFilter) {
            this.scannerFilter = Objects.requireNonNull(scannerFilter);
            return this;
        }

        public Builder withFilters(Collection<OASFilter> filters) {
            Objects.requireNonNull(filters);
            this.filters.clear();
            filters.forEach(filter -> this.filters.put(filter.getClass().getName(), (OASFilter)filter));
            return this;
        }

        public Builder withFilterNames(Collection<String> filterNames) {
            Objects.requireNonNull(filterNames);
            this.filters.clear();
            filterNames.forEach(filter -> this.filters.put((String)filter, (OASFilter)null));
            return this;
        }

        public Builder addFilter(OASFilter filter) {
            Objects.requireNonNull(filter);
            this.filters.put(filter.getClass().getName(), filter);
            return this;
        }

        public Builder addFilterName(String filterName) {
            Objects.requireNonNull(filterName);
            this.filters.put(filterName, null);
            return this;
        }

        public <V, A extends V, O extends V, AB, OB> SmallRyeOpenAPI build() {
            InputStream customFile;
            ClassLoader appClassLoader = this.applicationClassLoader != null ? this.applicationClassLoader : Thread.currentThread().getContextClassLoader();
            OpenApiConfig buildConfig = OpenApiConfig.fromConfig(Optional.ofNullable(this.config).orElseGet(() -> ConfigProvider.getConfig((ClassLoader)appClassLoader)));
            IOContext io = IOContext.forJson(JsonIO.newInstance(buildConfig));
            OpenAPIDefinitionIO modelIO = new OpenAPIDefinitionIO(io);
            FilteredIndexView filteredIndex = new FilteredIndexView(this.index, buildConfig);
            OpenAPI readerModel = null;
            OpenAPI staticModel = null;
            OpenAPI annotationModel = null;
            OASFilter standardFilter = null;
            if (this.enableModelReader) {
                readerModel = OpenApiProcessor.modelFromReader(buildConfig, appClassLoader, filteredIndex);
                this.debugModel("reader", readerModel);
            }
            if (this.enableStandardStaticFiles) {
                Function<String, URL> loadFn = Optional.ofNullable(this.resourceLocator).orElse(appClassLoader::getResource);
                staticModel = OpenApiProcessor.loadOpenApiStaticFiles(loadFn).stream().map(file -> {
                    OpenAPI openAPI;
                    InputStreamReader reader = new InputStreamReader(file.getContent());
                    try {
                        Object dom = io.jsonIO().fromReader(reader, file.getFormat());
                        OpenAPI fileModel = (OpenAPI)modelIO.readValue(dom);
                        this.debugModel("static file", fileModel);
                        openAPI = fileModel;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new OpenApiRuntimeException("IOException reading " + (Object)((Object)file.getFormat()) + " static file", e);
                        }
                    }
                    ((Reader)reader).close();
                    return openAPI;
                }).reduce(MergeUtil::merge).orElse(null);
            }
            if ((customFile = this.customStaticFile.get()) != null) {
                try (InputStreamReader reader = new InputStreamReader(customFile);){
                    Object dom = io.jsonIO().fromReader(reader);
                    OpenAPI customStaticModel = (OpenAPI)modelIO.readValue(dom);
                    this.debugModel("static file", customStaticModel);
                    staticModel = MergeUtil.merge(customStaticModel, staticModel);
                }
                catch (IOException e2) {
                    throw new OpenApiRuntimeException("IOException reading custom static file", e2);
                }
            }
            if (this.enableAnnotationScan && !buildConfig.scanDisable()) {
                buildConfig.setAllowNakedPathParameter(this.enableUnannotatedPathParameters);
                AnnotationScannerExtension ext = this.newExtension(modelIO);
                AnnotationScannerContext scannerContext = new AnnotationScannerContext(filteredIndex, appClassLoader, Collections.singletonList(ext), false, buildConfig, modelIO, new OpenAPIImpl());
                io.scannerContext(scannerContext);
                Supplier supplier = Optional.ofNullable(this.scannerClassLoader).map(AnnotationScannerFactory::new).orElseGet(() -> new AnnotationScannerFactory(appClassLoader));
                OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(scannerContext, supplier);
                annotationModel = scanner.scan(this.scannerFilter);
                this.debugModel("annotation", annotationModel);
            }
            if (this.enableStandardFilter) {
                standardFilter = OpenApiProcessor.getFilter(buildConfig, appClassLoader, (IndexView)filteredIndex);
            }
            OpenApiDocument doc = OpenApiDocument.newInstance();
            doc.config(buildConfig);
            doc.defaultRequiredProperties(this.defaultRequiredProperties);
            doc.modelFromReader(MergeUtil.merge(this.initialModel, readerModel));
            doc.modelFromStaticFile(staticModel);
            doc.modelFromAnnotations(annotationModel);
            this.filters.entrySet().stream().map(e -> Optional.ofNullable((OASFilter)e.getValue()).orElseGet(() -> OpenApiProcessor.getFilter((String)e.getKey(), appClassLoader, (IndexView)filteredIndex))).forEach(doc::filter);
            if (standardFilter != null && !this.filters.containsKey(standardFilter.getClass().getName())) {
                doc.filter(standardFilter);
            }
            doc.initialize();
            OpenAPI model = doc.get();
            BiFunction<Object, Format, String> toString = io.jsonIO()::toString;
            return new SmallRyeOpenAPI(model, modelIO.write(model).orElse(null), toString);
        }

        private <V, A extends V, O extends V, AB, OB> AnnotationScannerExtension newExtension(final OpenAPIDefinitionIO<V, A, O, AB, OB> modelIO) {
            return new AnnotationScannerExtension(){

                @Override
                public void processScannerApplications(AnnotationScanner scanner, Collection<ClassInfo> applications) {
                    Optional.ofNullable((String)contextRootResolver.apply(applications)).ifPresent(scanner::setContextRoot);
                }

                @Override
                public Type resolveAsyncType(Type type) {
                    return (Type)typeConverter.apply(type);
                }

                @Override
                public Object parseValue(String value) {
                    return Optional.ofNullable(jsonParser).map(parser -> parser.apply(value)).orElseGet(() -> modelIO.jsonIO().parseValue(value));
                }

                @Override
                public Schema parseSchema(String jsonSchema) {
                    return Optional.ofNullable(schemaParser).map(parser -> (Schema)parser.apply(jsonSchema)).orElseGet(() -> {
                        Object schemaModel = modelIO.jsonIO().fromString(jsonSchema, Format.JSON);
                        return (Schema)modelIO.schemas().readValue(schemaModel);
                    });
                }
            };
        }

        private void debugModel(String source, OpenAPI model) {
            if (model == null) {
                return;
            }
            ApiLogging.logger.addingModel(source);
            this.debugMap("callbacks", source, this.getMap(model, Components::getCallbacks));
            this.debugMap("examples", source, this.getMap(model, Components::getExamples));
            this.debugMap("headers", source, this.getMap(model, Components::getHeaders));
            this.debugMap("links", source, this.getMap(model, Components::getLinks));
            this.debugMap("parameters", source, this.getMap(model, Components::getParameters));
            this.debugMap("request bodies", source, this.getMap(model, Components::getRequestBodies));
            this.debugMap("responses", source, this.getMap(model, Components::getResponses));
            this.debugMap("schemas", source, this.getMap(model, Components::getSchemas));
            this.debugMap("security schemes", source, this.getMap(model, Components::getSecuritySchemes));
            this.debugList("servers", source, Optional.ofNullable(model.getServers()));
            this.debugMap("path items", source, Optional.ofNullable(model.getPaths()).map(Paths::getPathItems));
            this.debugList("security", source, Optional.ofNullable(model.getSecurity()));
            this.debugList("tags", source, Optional.ofNullable(model.getTags()));
            this.debugMap("extensions", source, Optional.ofNullable(model.getExtensions()));
        }

        private Optional<Map<String, ?>> getMap(OpenAPI model, Function<Components, Map<String, ?>> extract) {
            return Optional.ofNullable(model.getComponents()).map(extract);
        }

        private void debugMap(String name, String source, Optional<Map<String, ?>> collection) {
            this.debugModel(name, source, collection.map(Map::size));
        }

        private void debugList(String name, String source, Optional<Collection<?>> collection) {
            this.debugModel(name, source, collection.map(Collection::size));
        }

        private void debugModel(String name, String source, Optional<Integer> collection) {
            ApiLogging.logger.addingModel(name, source, collection.map(Object::toString).orElse("<no>"));
        }
    }
}

