/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.JacksonConstants;
import io.smallrye.openapi.api.constants.JaxbConstants;
import io.smallrye.openapi.api.constants.JsonbConstants;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class IgnoreResolver {
    private final AnnotationScannerContext context;
    private final AugmentedIndexView index;
    private final IgnoreAnnotationHandler[] ignoreHandlers;

    public IgnoreResolver(AnnotationScannerContext context) {
        this.context = context;
        this.index = context.getAugmentedIndex();
        this.ignoreHandlers = new IgnoreAnnotationHandler[]{new SchemaHiddenHandler(), new JsonbTransientHandler(), new JsonIgnorePropertiesHandler(), new JsonIgnoreHandler(), new JsonIgnoreTypeHandler(), new TransientIgnoreHandler(), new JaxbAccessibilityHandler()};
    }

    public Visibility isIgnore(AnnotationTarget annotationTarget, AnnotationTarget reference) {
        for (IgnoreAnnotationHandler handler : this.ignoreHandlers) {
            Visibility v = handler.shouldIgnore(annotationTarget, reference);
            if (v == Visibility.UNSET) continue;
            return v;
        }
        return Visibility.UNSET;
    }

    public Visibility getDescendantVisibility(String propertyName, List<ClassInfo> descendants) {
        for (IgnoreAnnotationHandler handler : this.ignoreHandlers) {
            Visibility v = handler.getDescendantVisibility(propertyName, descendants);
            if (v == Visibility.UNSET) continue;
            return v;
        }
        return Visibility.UNSET;
    }

    private boolean valueAsBooleanOrTrue(AnnotationInstance annotation) {
        return Optional.ofNullable(annotation.value()).map(AnnotationValue::asBoolean).orElse(true);
    }

    private static interface IgnoreAnnotationHandler {
        public Visibility shouldIgnore(AnnotationTarget var1, AnnotationTarget var2);

        public List<DotName> getNames();

        default public Visibility getDescendantVisibility(String propertyName, List<ClassInfo> descendants) {
            return Visibility.UNSET;
        }
    }

    private final class SchemaHiddenHandler
    implements IgnoreAnnotationHandler {
        private SchemaHiddenHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            Boolean hidden;
            AnnotationInstance annotationInstance = IgnoreResolver.this.context.annotations().getAnnotation(target, this.getNames());
            if (annotationInstance != null && (hidden = (Boolean)IgnoreResolver.this.context.annotations().value(annotationInstance, "hidden")) != null) {
                return hidden != false ? Visibility.IGNORED : Visibility.EXPOSED;
            }
            return Visibility.UNSET;
        }

        @Override
        public List<DotName> getNames() {
            return Arrays.asList(SchemaConstant.DOTNAME_SCHEMA);
        }
    }

    private final class JsonbTransientHandler
    implements IgnoreAnnotationHandler {
        private JsonbTransientHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            return IgnoreResolver.this.context.annotations().hasAnnotation(target, this.getNames()) ? Visibility.IGNORED : Visibility.UNSET;
        }

        @Override
        public List<DotName> getNames() {
            return JsonbConstants.JSONB_TRANSIENT;
        }
    }

    private final class JsonIgnorePropertiesHandler
    implements IgnoreAnnotationHandler {
        private JsonIgnorePropertiesHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            Visibility visibility = this.declaringClassIgnore(target);
            if (visibility != Visibility.UNSET) {
                return visibility;
            }
            return this.nestingPropertyIgnore(reference, this.propertyName(target));
        }

        private Visibility declaringClassIgnore(AnnotationTarget target) {
            AnnotationInstance declaringClassJIP = IgnoreResolver.this.context.annotations().getAnnotation((AnnotationTarget)TypeUtil.getDeclaringClass(target), this.getNames());
            return this.shouldIgnoreTarget(declaringClassJIP, this.propertyName(target));
        }

        private Visibility nestingPropertyIgnore(AnnotationTarget nesting, String propertyName) {
            if (nesting == null) {
                return Visibility.UNSET;
            }
            AnnotationInstance nestedTypeJIP = IgnoreResolver.this.context.annotations().getAnnotation(nesting, this.getNames());
            return this.shouldIgnoreTarget(nestedTypeJIP, propertyName);
        }

        private String propertyName(AnnotationTarget target) {
            if (target.kind() == AnnotationTarget.Kind.FIELD) {
                return target.asField().name();
            }
            return TypeResolver.propertyName(target.asMethod());
        }

        private Visibility shouldIgnoreTarget(AnnotationInstance jipAnnotation, String targetName) {
            if (jipAnnotation == null || jipAnnotation.value() == null) {
                return Visibility.UNSET;
            }
            if (Arrays.asList(jipAnnotation.value().asStringArray()).contains(targetName)) {
                return Visibility.IGNORED;
            }
            return Visibility.EXPOSED;
        }

        @Override
        public List<DotName> getNames() {
            return Arrays.asList(JacksonConstants.JSON_IGNORE_PROPERTIES);
        }

        @Override
        public Visibility getDescendantVisibility(String propertyName, List<ClassInfo> descendants) {
            for (ClassInfo descendant : descendants) {
                AnnotationInstance declaringClassJIP = IgnoreResolver.this.context.annotations().getAnnotation((AnnotationTarget)descendant, this.getNames());
                Visibility visibility = this.shouldIgnoreTarget(declaringClassJIP, propertyName);
                if (visibility == Visibility.UNSET) continue;
                return visibility;
            }
            return Visibility.UNSET;
        }
    }

    private final class JsonIgnoreHandler
    implements IgnoreAnnotationHandler {
        private JsonIgnoreHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            AnnotationInstance annotationInstance = IgnoreResolver.this.context.annotations().getAnnotation(target, this.getNames());
            if (annotationInstance != null && IgnoreResolver.this.valueAsBooleanOrTrue(annotationInstance)) {
                return Visibility.IGNORED;
            }
            return Visibility.UNSET;
        }

        @Override
        public List<DotName> getNames() {
            return Arrays.asList(JacksonConstants.JSON_IGNORE);
        }
    }

    private final class JsonIgnoreTypeHandler
    implements IgnoreAnnotationHandler {
        private final Set<DotName> ignoredTypes = new LinkedHashSet<DotName>();

        private JsonIgnoreTypeHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            Type classType;
            switch (target.kind()) {
                case FIELD: {
                    classType = target.asField().type();
                    break;
                }
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    if (method.returnType().kind().equals((Object)Type.Kind.VOID)) {
                        if (method.parameterTypes().isEmpty()) {
                            return Visibility.IGNORED;
                        }
                        classType = method.parameterType(0);
                        break;
                    }
                    classType = method.returnType();
                    break;
                }
                default: {
                    return Visibility.UNSET;
                }
            }
            if (classType.kind() == Type.Kind.PRIMITIVE || classType.kind() == Type.Kind.VOID || classType.kind() == Type.Kind.ARRAY && classType.asArrayType().component().kind() == Type.Kind.PRIMITIVE || !IgnoreResolver.this.index.containsClass(classType)) {
                return Visibility.UNSET;
            }
            ClassInfo classInfo = IgnoreResolver.this.index.getClass(classType);
            if (this.ignoredTypes.contains(classInfo.name())) {
                DataObjectLogging.logger.ignoringType(classInfo.name());
                return Visibility.IGNORED;
            }
            AnnotationInstance annotationInstance = IgnoreResolver.this.context.annotations().getAnnotation((AnnotationTarget)classInfo, this.getNames());
            if (annotationInstance != null && IgnoreResolver.this.valueAsBooleanOrTrue(annotationInstance)) {
                DataObjectLogging.logger.ignoringTypeAndAddingToSet(classInfo.name());
                this.ignoredTypes.add(classInfo.name());
                return Visibility.IGNORED;
            }
            return Visibility.UNSET;
        }

        @Override
        public List<DotName> getNames() {
            return Arrays.asList(JacksonConstants.JSON_IGNORE_TYPE);
        }
    }

    private final class TransientIgnoreHandler
    implements IgnoreAnnotationHandler {
        private TransientIgnoreHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            FieldInfo field;
            if (target.kind() == AnnotationTarget.Kind.FIELD && Modifier.isTransient((field = target.asField()).flags())) {
                Boolean hidden;
                AnnotationInstance schemaAnnotation = TypeUtil.getSchemaAnnotation(IgnoreResolver.this.context, target);
                if (schemaAnnotation != null && (hidden = (Boolean)IgnoreResolver.this.context.annotations().value(schemaAnnotation, "hidden")) != null && !hidden.booleanValue()) {
                    return Visibility.EXPOSED;
                }
                return Visibility.IGNORED;
            }
            return Visibility.UNSET;
        }

        @Override
        public List<DotName> getNames() {
            return Arrays.asList(DotName.createSimple((String)TransientIgnoreHandler.class.getName()));
        }
    }

    private final class JaxbAccessibilityHandler
    implements IgnoreAnnotationHandler {
        private JaxbAccessibilityHandler() {
        }

        @Override
        public Visibility shouldIgnore(AnnotationTarget target, AnnotationTarget reference) {
            short flags;
            ClassInfo declaringClass;
            String accessTypeRequired;
            if (this.hasXmlTransient(target)) {
                return Visibility.IGNORED;
            }
            switch (target.kind()) {
                case FIELD: {
                    FieldInfo field = target.asField();
                    accessTypeRequired = "FIELD";
                    declaringClass = field.declaringClass();
                    flags = field.flags();
                    break;
                }
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    accessTypeRequired = "PROPERTY";
                    declaringClass = method.declaringClass();
                    flags = method.flags();
                    break;
                }
                default: {
                    return Visibility.UNSET;
                }
            }
            Visibility result = this.hasXmlTransient((AnnotationTarget)declaringClass) ? Visibility.IGNORED : (this.isXmlExposed(target) ? Visibility.EXPOSED : this.getXmlVisibility(declaringClass, accessTypeRequired, flags));
            return result;
        }

        boolean hasXmlTransient(AnnotationTarget target) {
            return IgnoreResolver.this.context.annotations().hasAnnotation(target, JaxbConstants.XML_TRANSIENT);
        }

        boolean isXmlExposed(AnnotationTarget target) {
            return IgnoreResolver.this.context.annotations().hasAnnotation(target, JaxbConstants.XML_ALL_BINDINGS);
        }

        Visibility getXmlVisibility(ClassInfo declaringClass, String accessTypeRequired, int flags) {
            String xmlAccessType = (String)IgnoreResolver.this.context.annotations().getAnnotationValue((AnnotationTarget)declaringClass, JaxbConstants.XML_ACCESSOR_TYPE);
            if (xmlAccessType == null) {
                return Visibility.UNSET;
            }
            if (accessTypeRequired.equals(xmlAccessType) || "PUBLIC_MEMBER".equals(xmlAccessType) && Modifier.isPublic(flags)) {
                return Visibility.EXPOSED;
            }
            return Visibility.IGNORED;
        }

        @Override
        public List<DotName> getNames() {
            return null;
        }
    }

    public static enum Visibility {
        IGNORED,
        EXPOSED,
        UNSET;

    }
}

