/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import java.io.IOException;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class AnnotationsTest
extends IndexScannerTestBase {
    AnnotationsTest() {
    }

    @ParameterizedTest
    @CsvSource(value={"boolArray, boolean[]", "byteArray, byte[]", "charArray, char[]", "doubleArray, double[]", "floatArray, float[]", "intArray, int[]", "longArray, long[]", "shortArray, short[]", "stringArray, java.lang.String[]", "classArray, org.jboss.jandex.Type[]", "enumArray, java.lang.String[]", "nestedArray, org.jboss.jandex.AnnotationInstance[]"})
    void testGetAnnotationValuesWithEmptyArrays(String valueName, Class<?> expectedType) throws IOException {
        class Bean {
            @AllKinds(boolArray={}, byteArray={}, charArray={}, doubleArray={}, floatArray={}, intArray={}, longArray={}, shortArray={}, stringArray={}, classArray={}, enumArray={}, nestedArray={})
            String target;

            Bean() {
            }
        }
        FilteredIndexView index = new FilteredIndexView((IndexView)Index.of((Class[])new Class[]{Bean.class, AllKinds.class, Nested.class, AnnotationEnum.class}), AnnotationsTest.emptyConfig());
        AnnotationScannerContext context = new AnnotationScannerContext(index, Thread.currentThread().getContextClassLoader(), Collections.emptyList(), AnnotationsTest.emptyConfig(), (OpenAPI)new OpenAPIImpl());
        Object value = context.annotations().getAnnotationValue((AnnotationTarget)index.getClassByName(Bean.class).field("target"), DotName.createSimple(AllKinds.class), valueName);
        Assertions.assertTrue((boolean)expectedType.isInstance(value));
    }

    @ParameterizedTest
    @CsvSource(value={"boolValue, java.lang.Boolean", "byteValue, java.lang.Byte", "charValue, java.lang.Character", "doubleValue, java.lang.Double", "floatValue, java.lang.Float", "intValue, java.lang.Integer", "longValue, java.lang.Long", "shortValue, java.lang.Short", "stringValue, java.lang.String", "classValue, org.jboss.jandex.Type", "enumValue, java.lang.String", "nestedValue, org.jboss.jandex.AnnotationInstance"})
    void testGetAnnotationValuesWithOverrides(String valueName, Class<?> expectedType) throws IOException {
        class Bean {
            @AllKinds(boolValue=false, byteValue=1, charValue=1, doubleValue=1.0, floatValue=1.0f, intValue=1, longValue=1L, shortValue=1, stringValue="Hello", classValue=Type.class, enumValue=AnnotationEnum.VAL2, nestedValue=@Nested(value="World"))
            String target;

            Bean() {
            }
        }
        FilteredIndexView index = new FilteredIndexView((IndexView)Index.of((Class[])new Class[]{Bean.class, AllKinds.class, Nested.class, AnnotationEnum.class}), AnnotationsTest.emptyConfig());
        AnnotationScannerContext context = new AnnotationScannerContext(index, Thread.currentThread().getContextClassLoader(), Collections.emptyList(), AnnotationsTest.emptyConfig(), (OpenAPI)new OpenAPIImpl());
        Object value = context.annotations().getAnnotationValue((AnnotationTarget)index.getClassByName(Bean.class).field("target"), DotName.createSimple(AllKinds.class), valueName);
        Assertions.assertTrue((boolean)expectedType.isInstance(value));
    }

    @Test
    void testComposedAnnotation() throws IOException {
        class Bean {
            @AllKindsComposed
            String target;

            Bean() {
            }
        }
        FilteredIndexView index = new FilteredIndexView((IndexView)Index.of((Class[])new Class[]{Bean.class, AllKinds.class, AllKinds.List.class, Nested.class, AnnotationEnum.class, AllKindsComposed.class, Retention.class, Repeatable.class}), AnnotationsTest.emptyConfig());
        AnnotationScannerContext context = new AnnotationScannerContext(index, Thread.currentThread().getContextClassLoader(), Collections.emptyList(), AnnotationsTest.emptyConfig(), (OpenAPI)new OpenAPIImpl());
        List annotations = context.annotations().getRepeatableAnnotation((AnnotationTarget)index.getClassByName(Bean.class).field("target"), DotName.createSimple(AllKinds.class), DotName.createSimple(AllKinds.List.class));
        Assertions.assertEquals((int)2, (int)annotations.size());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Repeatable(value=List.class)
    static @interface AllKinds {
        public boolean boolValue() default true;

        public boolean[] boolArray() default {};

        public byte byteValue() default 0;

        public byte[] byteArray() default {};

        public char charValue() default 0;

        public char[] charArray() default {};

        public double doubleValue() default 0.0;

        public double[] doubleArray() default {};

        public float floatValue() default 0.0f;

        public float[] floatArray() default {};

        public int intValue() default 0;

        public int[] intArray() default {};

        public long longValue() default 0L;

        public long[] longArray() default {};

        public short shortValue() default 0;

        public short[] shortArray() default {};

        public String stringValue() default "";

        public String[] stringArray() default {};

        public Class<?> classValue() default Object.class;

        public Class<?>[] classArray() default {};

        public AnnotationEnum enumValue() default AnnotationEnum.VAL1;

        public AnnotationEnum[] enumArray() default {};

        public Nested nestedValue() default @Nested(value="");

        public Nested[] nestedArray() default {};

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public AllKinds[] value();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Nested {
        public String value();
    }

    static enum AnnotationEnum {
        VAL1,
        VAL2;

    }

    @AllKinds.List(value={@AllKinds(boolArray={}, byteArray={}, charArray={}, doubleArray={}, floatArray={}, intArray={}, longArray={}, shortArray={}, stringArray={}, classArray={}, enumArray={}, nestedArray={}), @AllKinds(boolValue=false, byteValue=1, charValue=1, doubleValue=1.0, floatValue=1.0f, intValue=1, longValue=1L, shortValue=1, stringValue="Hello", classValue=Type.class, enumValue=AnnotationEnum.VAL2, nestedValue=@Nested(value="World"))})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface AllKindsComposed {
    }
}

