/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class PropertyNamingStrategyTest
extends IndexScannerTestBase {
    PropertyNamingStrategyTest() {
    }

    @Test
    void testSnakeCase() throws Exception {
        Index index = PropertyNamingStrategyTest.indexOf(NameStrategyBean1.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(PropertyNamingStrategyTest.dynamicConfig("mp.openapi.extensions.smallrye.property-naming-strategy", "com.fasterxml.jackson.databind.PropertyNamingStrategies$SnakeCaseStrategy"), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        PropertyNamingStrategyTest.printToConsole(result);
        PropertyNamingStrategyTest.assertJsonEquals("components.schemas.name-strategy-snake.json", result);
    }

    @Test
    void testJacksonNamingIgnoresConfig() throws Exception {
        Index index = PropertyNamingStrategyTest.indexOf(NameStrategyBean2.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(PropertyNamingStrategyTest.dynamicConfig("mp.openapi.extensions.smallrye.property-naming-strategy", "com.fasterxml.jackson.databind.PropertyNamingStrategies$SnakeCaseStrategy"), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        PropertyNamingStrategyTest.printToConsole(result);
        PropertyNamingStrategyTest.assertJsonEquals("components.schemas.name-strategy-ignored.json", result);
    }

    @Test
    void testJacksonNamingOverridesConfig() throws Exception {
        Index index = PropertyNamingStrategyTest.indexOf(NameStrategyKebab.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(PropertyNamingStrategyTest.dynamicConfig("mp.openapi.extensions.smallrye.property-naming-strategy", "com.fasterxml.jackson.databind.PropertyNamingStrategies$SnakeCaseStrategy"), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        PropertyNamingStrategyTest.printToConsole(result);
        PropertyNamingStrategyTest.assertJsonEquals("components.schemas.name-strategy-kebab.json", result);
    }

    @Test
    void testInvalidNamingStrategyClass() throws Exception {
        Index index = PropertyNamingStrategyTest.indexOf(NameStrategyKebab.class);
        OpenApiConfig config = PropertyNamingStrategyTest.dynamicConfig("mp.openapi.extensions.smallrye.property-naming-strategy", "com.fasterxml.jackson.databind.PropertyNamingStrategies$InvalidStrategy");
        Assertions.assertThrows(OpenApiRuntimeException.class, () -> new OpenApiAnnotationScanner(config, (IndexView)index));
    }

    @Test
    void testNoValidTranslationMethods() throws Exception {
        Index index = PropertyNamingStrategyTest.indexOf(NameStrategyKebab.class);
        OpenApiConfig config = PropertyNamingStrategyTest.dynamicConfig("mp.openapi.extensions.smallrye.property-naming-strategy", NoValidTranslationMethods.class.getName());
        Assertions.assertThrows(OpenApiRuntimeException.class, () -> new OpenApiAnnotationScanner(config, (IndexView)index));
    }

    @Test
    void testInvalidPropertyNameTranslationAttempt() throws Exception {
        Index index = PropertyNamingStrategyTest.indexOf(NameStrategyBean3.class);
        OpenApiConfig config = PropertyNamingStrategyTest.dynamicConfig("mp.openapi.extensions.smallrye.property-naming-strategy", TranslationThrowsException.class.getName());
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(config, (IndexView)index);
        Assertions.assertThrows(OpenApiRuntimeException.class, () -> scanner.scan(new String[0]));
    }

    @ParameterizedTest(name="testJsonbConstantStrategy-{0}")
    @CsvSource(value={"IDENTITY, simpleStringOne|anotherField|Y|z", "LOWER_CASE_WITH_DASHES, simple-string-one|another-field|y|z", "LOWER_CASE_WITH_UNDERSCORES, simple_string_one|another_field|y|z", "UPPER_CAMEL_CASE, SimpleStringOne|AnotherField|Y|Z", "UPPER_CAMEL_CASE_WITH_SPACES, Simple String One|Another Field|Y|Z", "CASE_INSENSITIVE, simpleStringOne|anotherField|Y|z"})
    void testJsonbConstantStrategy(String strategy, String expectedNames) throws Exception {
        Index index = PropertyNamingStrategyTest.indexOf(NameStrategyBean3.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(PropertyNamingStrategyTest.dynamicConfig("mp.openapi.extensions.smallrye.property-naming-strategy", strategy), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        PropertyNamingStrategyTest.printToConsole(result);
        TreeSet<String> expectedNameSet = new TreeSet<String>(Arrays.asList(expectedNames.split("\\|")));
        Map schemas = result.getComponents().getSchemas();
        org.eclipse.microprofile.openapi.models.media.Schema schema = (org.eclipse.microprofile.openapi.models.media.Schema)schemas.get(NameStrategyBean3.class.getSimpleName());
        Assertions.assertEquals((int)expectedNameSet.size(), (int)schema.getProperties().size());
        Assertions.assertEquals(expectedNameSet, schema.getProperties().keySet());
    }

    @Schema
    static class NameStrategyBean1 {
        String simpleStringValue;
        @Schema(name="another-string", description="Customize name locally")
        String anotherStringValue;
        @Schema(maximum="10", description="Schema present, but name defaults to global config")
        int simpleIntegerValue;

        NameStrategyBean1() {
        }
    }

    @Schema
    @JsonNaming
    static class NameStrategyBean2 {
        String simpleString1;
        Integer anotherField;

        NameStrategyBean2() {
        }
    }

    @Schema
    @JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
    static class NameStrategyKebab {
        String simpleStringOne;
        Integer anotherField;

        NameStrategyKebab() {
        }
    }

    public static class NoValidTranslationMethods {
        public String translate() {
            return null;
        }

        public String translate(String v1, String v2) {
            return null;
        }

        public String translateValue(int v1) {
            return String.valueOf(v1);
        }
    }

    @Schema
    static class NameStrategyBean3 {
        String simpleStringOne;
        Integer anotherField;
        BigDecimal Y;
        double z;

        NameStrategyBean3() {
        }
    }

    public static class TranslationThrowsException {
        public String translate(String value) {
            throw new IllegalArgumentException("dummy");
        }
    }
}

