/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.spi;

import io.smallrye.openapi.api.models.info.LicenseImpl;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OASFactoryResolverImplTest {
    OASFactoryResolverImplTest() {
    }

    @Test
    void testCreateObject_All() {
        Class[] modelClasses;
        for (Class modelClass : modelClasses = new Class[]{APIResponse.class, APIResponses.class, Callback.class, Components.class, Contact.class, Content.class, Discriminator.class, Encoding.class, Example.class, ExternalDocumentation.class, Header.class, Info.class, License.class, Link.class, MediaType.class, OAuthFlow.class, OAuthFlows.class, OpenAPI.class, Operation.class, Parameter.class, PathItem.class, Paths.class, RequestBody.class, Schema.class, SecurityRequirement.class, SecurityScheme.class, Server.class, ServerVariable.class, Tag.class, XML.class}) {
            Constructible object = OASFactory.createObject((Class)modelClass);
            Assertions.assertNotNull((Object)object);
        }
    }

    @Test
    void testCreateObject_License() {
        License license = ((License)OASFactory.createObject(License.class)).name("Test License").url("urn:test-url");
        Assertions.assertNotNull((Object)license);
        Assertions.assertEquals(LicenseImpl.class, license.getClass());
        Assertions.assertEquals((Object)"Test License", (Object)license.getName());
        Assertions.assertEquals((Object)"urn:test-url", (Object)license.getUrl());
    }

    @Test
    void testCreateObject_RTE() {
        Class<String> c = String.class;
        try {
            OASFactory.createObject(c);
            Assertions.fail((String)"Expected a runtime error.");
        }
        catch (RuntimeException e) {
            Assertions.assertEquals((Object)"SROAP09000: Class 'java.lang.String' is not Constructible.", (Object)e.getMessage());
        }
    }
}

