/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.constants.OpenApiConstants;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;

public class OpenApiConfigImpl
implements OpenApiConfig {
    private static final Optional<String[]> UNSET = Optional.of(new String[0]);
    private Config config;
    private String modelReader;
    private String filter;
    private Boolean scanDisable;
    private Set<String> scanPackages;
    private Set<String> scanClasses;
    private Set<String> scanExcludePackages;
    private Set<String> scanExcludeClasses;
    private Boolean scanBeanValidation;
    private Set<String> servers;
    private Boolean scanDependenciesDisable;
    private Set<String> scanDependenciesJars;
    private Boolean arrayReferencesEnable;
    private String customSchemaRegistryClass;
    private Boolean applicationPathDisable;
    private Boolean privatePropertiesEnable;
    private String propertyNamingStrategy;
    private Boolean sortedPropertiesEnable;
    private Map<String, String> schemas;
    private String version;
    private String infoTitle;
    private String infoVersion;
    private String infoDescription;
    private String infoTermsOfService;
    private String infoContactEmail;
    private String infoContactName;
    private String infoContactUrl;
    private String infoLicenseName;
    private String infoLicenseUrl;
    private OpenApiConfig.OperationIdStrategy operationIdStrategy;
    private Set<String> scanProfiles;
    private Set<String> scanExcludeProfiles;
    private Boolean removeUnusedSchemas;
    private Optional<String[]> defaultProduces = UNSET;
    private Optional<String[]> defaultConsumes = UNSET;
    private Optional<Boolean> allowNakedPathParameter = Optional.empty();

    public static OpenApiConfig fromConfig(Config config) {
        return new OpenApiConfigImpl(config);
    }

    public OpenApiConfigImpl(Config config) {
        this.config = config;
    }

    protected Config getConfig() {
        return this.config;
    }

    @Override
    public String modelReader() {
        if (this.modelReader == null) {
            this.modelReader = this.getStringConfigValue("mp.openapi.model.reader");
        }
        return this.modelReader;
    }

    @Override
    public String filter() {
        if (this.filter == null) {
            this.filter = this.getStringConfigValue("mp.openapi.filter");
        }
        return this.filter;
    }

    @Override
    public boolean scanDisable() {
        if (this.scanDisable == null) {
            this.scanDisable = this.getConfig().getOptionalValue("mp.openapi.scan.disable", Boolean.class).orElse(false);
        }
        return this.scanDisable;
    }

    @Override
    public Set<String> scanPackages() {
        if (this.scanPackages == null) {
            this.scanPackages = this.getConfig().getOptionalValue("mp.openapi.scan.packages", String.class).map(this::asCsvSet).orElseGet(Collections::emptySet);
        }
        return this.scanPackages;
    }

    @Override
    public Set<String> scanClasses() {
        if (this.scanClasses == null) {
            this.scanClasses = this.getConfig().getOptionalValue("mp.openapi.scan.classes", String.class).map(this::asCsvSet).orElseGet(Collections::emptySet);
        }
        return this.scanClasses;
    }

    @Override
    public Set<String> scanExcludePackages() {
        if (this.scanExcludePackages == null) {
            this.scanExcludePackages = this.getConfig().getOptionalValue("mp.openapi.scan.exclude.packages", String.class).map(this::asCsvSet).orElseGet(HashSet::new);
            this.scanExcludePackages.addAll(OpenApiConstants.NEVER_SCAN_PACKAGES);
        }
        return this.scanExcludePackages;
    }

    @Override
    public Set<String> scanExcludeClasses() {
        if (this.scanExcludeClasses == null) {
            this.scanExcludeClasses = this.getConfig().getOptionalValue("mp.openapi.scan.exclude.classes", String.class).map(this::asCsvSet).orElseGet(HashSet::new);
            this.scanExcludeClasses.addAll(OpenApiConstants.NEVER_SCAN_CLASSES);
        }
        return this.scanExcludeClasses;
    }

    @Override
    public boolean scanBeanValidation() {
        if (this.scanBeanValidation == null) {
            this.scanBeanValidation = this.getConfig().getOptionalValue("mp.openapi.scan.beanvalidation", Boolean.class).orElse(Boolean.TRUE);
        }
        return this.scanBeanValidation;
    }

    @Override
    public Set<String> servers() {
        if (this.servers == null) {
            String theServers = this.getStringConfigValue("mp.openapi.servers");
            this.servers = this.asCsvSet(theServers);
        }
        return this.servers;
    }

    @Override
    public Set<String> pathServers(String path) {
        String pathServers = this.getStringConfigValue("mp.openapi.servers.path." + path);
        return this.asCsvSet(pathServers);
    }

    @Override
    public Set<String> operationServers(String operationId) {
        String opServers = this.getStringConfigValue("mp.openapi.servers.operation." + operationId);
        return this.asCsvSet(opServers);
    }

    @Override
    public boolean scanDependenciesDisable() {
        if (this.scanDependenciesDisable == null) {
            this.scanDependenciesDisable = this.getConfig().getOptionalValue("mp.openapi.extensions.smallrye.scan-dependencies.disable", Boolean.class).orElse(this.getConfig().getOptionalValue("mp.openapi.extensions.scan-dependencies.disable", Boolean.class).orElse(false));
        }
        return this.scanDependenciesDisable;
    }

    @Override
    public Set<String> scanDependenciesJars() {
        if (this.scanDependenciesJars == null) {
            String classes = this.getStringConfigValue("mp.openapi.extensions.smallrye.scan-dependencies.jars");
            if (classes == null) {
                classes = this.getStringConfigValue("mp.openapi.extensions.scan-dependencies.jars");
            }
            this.scanDependenciesJars = this.asCsvSet(classes);
        }
        return this.scanDependenciesJars;
    }

    @Override
    public boolean arrayReferencesEnable() {
        if (this.arrayReferencesEnable == null) {
            this.arrayReferencesEnable = this.getConfig().getOptionalValue("mp.openapi.extensions.smallrye.array-references.enable", Boolean.class).orElse(true);
        }
        return this.arrayReferencesEnable;
    }

    @Override
    public String customSchemaRegistryClass() {
        if (this.customSchemaRegistryClass == null) {
            this.customSchemaRegistryClass = this.getStringConfigValue("mp.openapi.extensions.smallrye.custom-schema-registry.class");
            if (this.customSchemaRegistryClass == null) {
                this.customSchemaRegistryClass = this.getStringConfigValue("mp.openapi.extensions.custom-schema-registry.class");
            }
        }
        return this.customSchemaRegistryClass;
    }

    @Override
    public boolean applicationPathDisable() {
        if (this.applicationPathDisable == null) {
            this.applicationPathDisable = this.getConfig().getOptionalValue("mp.openapi.extensions.smallrye.application-path.disable", Boolean.class).orElse(this.getConfig().getOptionalValue("mp.openapi.extensions.application-path.disable", Boolean.class).orElse(false));
        }
        return this.applicationPathDisable;
    }

    @Override
    public boolean privatePropertiesEnable() {
        if (this.privatePropertiesEnable == null) {
            this.privatePropertiesEnable = this.getConfig().getOptionalValue("mp.openapi.extensions.smallrye.private-properties.enable", Boolean.class).orElse(OpenApiConfig.super.privatePropertiesEnable());
        }
        return this.privatePropertiesEnable;
    }

    @Override
    public String propertyNamingStrategy() {
        if (this.propertyNamingStrategy == null) {
            this.propertyNamingStrategy = this.getConfig().getOptionalValue("mp.openapi.extensions.smallrye.property-naming-strategy", String.class).orElse(OpenApiConfig.super.propertyNamingStrategy());
        }
        return this.propertyNamingStrategy;
    }

    @Override
    public boolean sortedPropertiesEnable() {
        if (this.sortedPropertiesEnable == null) {
            this.sortedPropertiesEnable = this.getConfig().getOptionalValue("mp.openapi.extensions.smallrye.sorted-properties.enable", Boolean.class).orElse(OpenApiConfig.super.sortedPropertiesEnable());
        }
        return this.sortedPropertiesEnable;
    }

    @Override
    public Map<String, String> getSchemas() {
        if (this.schemas == null) {
            this.schemas = StreamSupport.stream(this.config.getPropertyNames().spliterator(), false).filter(name -> name.startsWith("mp.openapi.schema.") || name.startsWith("MP_OPENAPI_SCHEMA_")).collect(Collectors.toMap(name -> name.substring("mp.openapi.schema.".length()), name -> (String)this.config.getValue(name, String.class)));
        }
        return this.schemas;
    }

    @Override
    public String getOpenApiVersion() {
        if (this.version == null) {
            this.version = this.getStringConfigValue("mp.openapi.extensions.smallrye.openapi");
        }
        return this.version;
    }

    @Override
    public String getInfoTitle() {
        if (this.infoTitle == null) {
            this.infoTitle = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.title");
        }
        return this.infoTitle;
    }

    @Override
    public String getInfoVersion() {
        if (this.infoVersion == null) {
            this.infoVersion = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.version");
        }
        return this.infoVersion;
    }

    @Override
    public String getInfoDescription() {
        if (this.infoDescription == null) {
            this.infoDescription = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.description");
        }
        return this.infoDescription;
    }

    @Override
    public String getInfoTermsOfService() {
        if (this.infoTermsOfService == null) {
            this.infoTermsOfService = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.termsOfService");
        }
        return this.infoTermsOfService;
    }

    @Override
    public String getInfoContactEmail() {
        if (this.infoContactEmail == null) {
            this.infoContactEmail = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.contact.email");
        }
        return this.infoContactEmail;
    }

    @Override
    public String getInfoContactName() {
        if (this.infoContactName == null) {
            this.infoContactName = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.contact.name");
        }
        return this.infoContactName;
    }

    @Override
    public String getInfoContactUrl() {
        if (this.infoContactUrl == null) {
            this.infoContactUrl = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.contact.url");
        }
        return this.infoContactUrl;
    }

    @Override
    public String getInfoLicenseName() {
        if (this.infoLicenseName == null) {
            this.infoLicenseName = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.license.name");
        }
        return this.infoLicenseName;
    }

    @Override
    public String getInfoLicenseUrl() {
        if (this.infoLicenseUrl == null) {
            this.infoLicenseUrl = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.license.url");
        }
        return this.infoLicenseUrl;
    }

    @Override
    public OpenApiConfig.OperationIdStrategy getOperationIdStrategy() {
        String strategy;
        if (this.operationIdStrategy == null && (strategy = this.getStringConfigValue("mp.openapi.extensions.smallrye.operationIdStrategy")) != null) {
            return OpenApiConfig.OperationIdStrategy.valueOf(strategy);
        }
        return null;
    }

    @Override
    public Optional<String[]> getDefaultProduces() {
        if (this.defaultProduces == UNSET) {
            this.defaultProduces = this.getDefaultContentType("mp.openapi.extensions.smallrye.defaultProduces");
        }
        return this.defaultProduces;
    }

    @Override
    public Optional<Boolean> allowNakedPathParameter() {
        return this.allowNakedPathParameter;
    }

    @Override
    public void doAllowNakedPathParameter() {
        this.allowNakedPathParameter = Optional.of(true);
    }

    public void setAllowNakedPathParameter(Boolean allowNakedPathParameter) {
        this.allowNakedPathParameter = Optional.ofNullable(allowNakedPathParameter);
    }

    @Override
    public Optional<String[]> getDefaultConsumes() {
        if (this.defaultConsumes == UNSET) {
            this.defaultConsumes = this.getDefaultContentType("mp.openapi.extensions.smallrye.defaultConsumes");
        }
        return this.defaultConsumes;
    }

    @Override
    public Set<String> getScanProfiles() {
        if (this.scanProfiles == null) {
            String classes = this.getStringConfigValue("mp.openapi.extensions.smallrye.scan.profiles");
            if (classes == null) {
                classes = this.getStringConfigValue("mp.openapi.extensions.smallrye.scan.profiles");
            }
            this.scanProfiles = this.asCsvSet(classes);
        }
        return this.scanProfiles;
    }

    @Override
    public Set<String> getScanExcludeProfiles() {
        if (this.scanExcludeProfiles == null) {
            String classes = this.getStringConfigValue("mp.openapi.extensions.smallrye.scan.exclude.profiles");
            if (classes == null) {
                classes = this.getStringConfigValue("mp.openapi.extensions.smallrye.scan.exclude.profiles");
            }
            this.scanExcludeProfiles = this.asCsvSet(classes);
        }
        return this.scanExcludeProfiles;
    }

    @Override
    public boolean removeUnusedSchemas() {
        if (this.removeUnusedSchemas == null) {
            this.removeUnusedSchemas = this.getConfig().getOptionalValue("mp.openapi.extensions.smallrye.remove-unused-schemas.enable", Boolean.class).orElse(OpenApiConfig.super.removeUnusedSchemas());
        }
        return this.removeUnusedSchemas;
    }

    String getStringConfigValue(String key) {
        return this.getConfig().getOptionalValue(key, String.class).map(v -> "".equals(v.trim()) ? null : v).orElse(null);
    }

    Optional<String[]> getDefaultContentType(String key) {
        return this.getConfig().getOptionalValue(key, String[].class);
    }
}

