/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.LogCapture;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.ScannerLogging;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.RegisterExtension;

class SchemaPropertyNegativeTest
extends IndexScannerTestBase {
    @RegisterExtension
    public LogCapture logs = new LogCapture(ScannerLogging.class.getPackage().getName());

    SchemaPropertyNegativeTest() {
    }

    @BeforeEach
    public void beforeEach(TestInfo testInfo) {
        System.out.println(testInfo.getDisplayName());
    }

    @Test
    void testClassSchemaPropertyBlankName() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(BlankNameTest.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-blankname.json", result);
    }

    @Test
    void testClassSchemaPropertyDuplicateName() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(DuplicateNameTest.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-duplicatename.json", result);
    }

    @Test
    void testClassSchemaPropertyNegativeMultipleOf() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(NegativeMultipleOf.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-negativemultipleof.json", result);
    }

    @Test
    void testClassSchemaPropertyMaximumNotNumber() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(MaximumNotNumber.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-maximumnotnumber.json", result);
    }

    @Test
    void testClassSchemaPropertyMinimumNotNumber() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(MinimumNotNumber.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-minimumnotnumber.json", result);
    }

    @Test
    void testClassSchemaPropertyMinLengthNegative() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(MinLengthNegative.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-minlengthnegative.json", result);
    }

    @Test
    void testClassSchemaPropertyMaxLengthNegative() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(MaxLengthNegative.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-maxlengthnegative.json", result);
    }

    @Test
    void testClassSchemaPropertyPatternInvalid() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(PatternInvalid.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-patterninvalid.json", result);
    }

    @Test
    void testClassSchemaPropertyMaxPropertiesNegative() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(MaxPropertiesNegative.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-maxpropertiesnegative.json", result);
    }

    @Test
    void testClassSchemaPropertyMinPropertiesNegative() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(MinPropertiesNegative.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-minpropertiesnegative.json", result);
    }

    @Test
    void testClassSchemaPropertyRefWithOtherProps() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(RefWithOtherProps.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-refwithotherprops.json", result);
    }

    @Test
    void testClassSchemaPropertyDefaultValueWrongType() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(DefaultValueWrongType.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-defaultvaluewrongtype.json", result);
    }

    @Test
    void testClassSchemaPropertyMaxItemsNegative() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(MaxItemsNegative.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-maxitemsnegative.json", result);
    }

    @Test
    void testClassSchemaPropertyMinItemsNegative() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(MinItemsNegative.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-minitemsnegative.json", result);
    }

    @Test
    void testClassSchemaPropertyImplementationMissing() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(ImplementationMissing.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-implementationmissing.json", result);
    }

    @Test
    void testClassSchemaPropertyNotMissing() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(NotMissing.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-notmissing.json", result);
        String expectedMessage = String.format("Could not find schema class in index: %s", MissingClass.class.getName());
        LogRecord record = this.logs.assertLogContaining(expectedMessage);
        Assertions.assertEquals((Object)Level.WARNING, (Object)record.getLevel());
    }

    @Test
    void testClassSchemaPropertyOneOfMissing() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(OneOfMissing.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-oneofmissing.json", result);
        String expectedMessage = String.format("Could not find schema class in index: %s", MissingClass.class.getName());
        LogRecord record = this.logs.assertLogContaining(expectedMessage);
        Assertions.assertEquals((Object)Level.WARNING, (Object)record.getLevel());
    }

    @Test
    void testClassSchemaPropertyAnyOfMissing() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(AnyOfMissing.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-anyofmissing.json", result);
        String expectedMessage = String.format("Could not find schema class in index: %s", MissingClass.class.getName());
        LogRecord record = this.logs.assertLogContaining(expectedMessage);
        Assertions.assertEquals((Object)Level.WARNING, (Object)record.getLevel());
    }

    @Test
    void testClassSchemaPropertyAllOfMissing() throws Exception {
        Index index = SchemaPropertyNegativeTest.indexOf(AllOfMissing.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyNegativeTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyNegativeTest.printToConsole(result);
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-allofmissing.json", result);
        String expectedMessage = String.format("Could not find schema class in index: %s", MissingClass.class.getName());
        LogRecord record = this.logs.assertLogContaining(expectedMessage);
        Assertions.assertEquals((Object)Level.WARNING, (Object)record.getLevel());
    }

    @Schema(properties={@SchemaProperty(name="test", allOf={MissingClass.class})})
    static class AllOfMissing {
        AllOfMissing() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", anyOf={MissingClass.class})})
    static class AnyOfMissing {
        AnyOfMissing() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", oneOf={MissingClass.class})})
    static class OneOfMissing {
        OneOfMissing() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", not=MissingClass.class)})
    static class NotMissing {
        NotMissing() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", implementation=MissingClass.class)})
    static class ImplementationMissing {
        ImplementationMissing() {
        }
    }

    static class MissingClass {
        public String example;

        MissingClass() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.ARRAY, minItems=-2)})
    static class MinItemsNegative {
        MinItemsNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.ARRAY, maxItems=-2)})
    static class MaxItemsNegative {
        MaxItemsNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.INTEGER, defaultValue="foo")})
    static class DefaultValueWrongType {
        DefaultValueWrongType() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.STRING, ref="foobar")})
    static class RefWithOtherProps {
        RefWithOtherProps() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.OBJECT, minProperties=-2)})
    static class MinPropertiesNegative {
        MinPropertiesNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.OBJECT, maxProperties=-2)})
    static class MaxPropertiesNegative {
        MaxPropertiesNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.STRING, pattern="(invalid")})
    static class PatternInvalid {
        PatternInvalid() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.STRING, maxLength=-2)})
    static class MaxLengthNegative {
        MaxLengthNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.STRING, minLength=-2)})
    static class MinLengthNegative {
        MinLengthNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.INTEGER, minimum="foo")})
    static class MinimumNotNumber {
        MinimumNotNumber() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.INTEGER, maximum="foo")})
    static class MaximumNotNumber {
        MaximumNotNumber() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.INTEGER, multipleOf=-2.0)})
    static class NegativeMultipleOf {
        NegativeMultipleOf() {
        }
    }

    @Schema(properties={@SchemaProperty(name="foo", type=SchemaType.STRING, defaultValue="5"), @SchemaProperty(name="foo", type=SchemaType.INTEGER)})
    static class DuplicateNameTest {
        DuplicateNameTest() {
        }
    }

    @Schema(properties={@SchemaProperty(name="", type=SchemaType.STRING)})
    static class BlankNameTest {
        BlankNameTest() {
        }
    }
}

