/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FilteredIndexViewTest {
    FilteredIndexViewTest() {
    }

    @Test
    void testAcceptsEmptyConfig() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
    }

    @Test
    void testAccepts_IncludedClass_ExcludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "com.example.pkgA.MyBean,com.example.pkgA.MyClass");
        properties.put("mp.openapi.scan.exclude.packages", "com.example.pkgA");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
    }

    @Test
    void testAccepts_ExcludedClass_IncludedClassPattern() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "^(?:com.example.pkgA.My.*)$");
        properties.put("mp.openapi.scan.exclude.classes", "com.example.pkgA.MyImpl");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    void testAccepts_IncludedClassPattern_ExcludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "^(?:com.example.pkgA.My.*)$");
        properties.put("mp.openapi.scan.exclude.packages", "com.example.pkgA");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    void testAccepts_ExcludedSimpleClassPattern_NotIncludedClassMatch() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.exclude.classes", "example.pkgA.MyImpl$");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    void testAccepts_ExcludedSimpleClassPattern_IncludedClassShorterMatch() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "(?:pkgA.My.*)$");
        properties.put("mp.openapi.scan.exclude.classes", "example.pkgA.MyImpl$");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    void testAccepts_ExcludedSimpleClassPattern_IncludedClassLongerMatch() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "(?:example.pkgA.My.*)$");
        properties.put("mp.openapi.scan.exclude.classes", "pkgA.MyImpl$");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    void testAccepts_IncludedSimpleClassPattern_ExcludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "(?:pkgA.My(Bean|Class))$");
        properties.put("mp.openapi.scan.exclude.packages", "com.example.pkgA");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    void testAccepts_IncludedSimpleClassPattern_ExcludedPackagePrefix() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "(?:pkgA.My(Bean|Class))$");
        properties.put("mp.openapi.scan.exclude.packages", "com.example");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    void testAccepts_IncludedSimpleClassPattern_ExcludedPackagePattern() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "(?:pkgA.MyBean)$");
        properties.put("mp.openapi.scan.exclude.packages", "example.pkg[AB]$");
        properties.put("mp.openapi.scan.packages", "^(com|org).example");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"org.example.pkgB.MyImpl")));
    }

    @Test
    void testAccepts_IncludedSimpleClassPattern_ExcludedSimpleClass() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "Resource$");
        properties.put("mp.openapi.scan.exclude.classes", "BarResource");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.FooResource")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.BarResource")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.BazDataObject")));
    }

    @Test
    void testAccepts_ExcludedPackageOverridesIncludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.packages", "com.example");
        properties.put("mp.openapi.scan.exclude.packages", "com.example");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.TopLevelClass")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    void testAccepts_IncludedPackagePatternEndAnchor() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.packages", "example.pkgA$");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.pkgB.MyImpl")));
    }

    @Test
    void testAccepts_IncludedPackageOverridesExcludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.packages", "com.example.pkgA");
        properties.put("mp.openapi.scan.exclude.packages", "com.example");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.TopLevelClass")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    void testAccepts_IncludedPackageExcludesOtherPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.packages", "com.example.pkgA");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgB.MyImpl")));
    }

    @Test
    void testAccepts_IncludedClassesImpliesOtherClassesExcluded() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "^com.example.pkgA.My(Bean|Class)$");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgB.MyImpl")));
    }

    @Test
    void testAccepts_IncludedPackageAroundExcludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.packages", "org.example.a, org.example.a.b.c");
        properties.put("mp.openapi.scan.exclude.packages", "org.example.a.b");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"org.example.a.MyClassA")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"org.example.a.b.MyClassB")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"org.example.a.b.c.MyClassC")));
    }

    @Test
    void testAccepts_ExcludedPackageAroundIncludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.packages", "org.example.a.b");
        properties.put("mp.openapi.scan.exclude.packages", "org.example.a, org.example.a.b.c");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"org.example.a.MyClassA")));
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"org.example.a.b.MyClassB")));
        Assertions.assertFalse((boolean)view.accepts(DotName.createSimple((String)"org.example.a.b.c.MyClassC")));
    }

    @Test
    void testAccepts_EmptyPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assertions.assertTrue((boolean)view.accepts(DotName.createSimple((String)"int")));
    }

    @Test
    void testGetAnnotationsWithRepeatable() {
        class Target {
            Target() {
            }

            @APIResponses(value={@APIResponse, @APIResponse})
            void test1(@Parameter String value1, @Parameter String value2) {
            }

            @APIResponse
            void test2(@Parameter String value1, @Parameter String value2) {
            }
        }
        AugmentedIndexView index = AugmentedIndexView.augment((IndexView)IndexScannerTestBase.indexOf(APIResponse.class, APIResponses.class, Parameter.class, Target.class));
        OpenApiConfig config = IndexScannerTestBase.emptyConfig();
        FilteredIndexView view = new FilteredIndexView((IndexView)index, config);
        Collection container = view.getAnnotationsWithRepeatable(DotName.createSimple((String)APIResponses.class.getName()), (IndexView)index);
        Assertions.assertEquals((int)1, (int)container.size());
        Collection responses = view.getAnnotationsWithRepeatable(DotName.createSimple((String)APIResponse.class.getName()), (IndexView)index);
        Assertions.assertEquals((int)3, (int)responses.size());
        Collection params = view.getAnnotationsWithRepeatable(DotName.createSimple((String)Parameter.class.getName()), (IndexView)index);
        Assertions.assertEquals((int)4, (int)params.size());
    }
}

