/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.parameters.ParameterImpl;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.MethodInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class AbstractAnnotationScannerTest {
    AbstractAnnotationScannerTest() {
    }

    @Test
    void testMakePath() {
        String path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"", "", ""});
        Assertions.assertEquals((Object)"/", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"/", "/"});
        Assertions.assertEquals((Object)"/", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"", "/bookings"});
        Assertions.assertEquals((Object)"/bookings", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"/api", "/bookings"});
        Assertions.assertEquals((Object)"/api/bookings", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"api", "bookings"});
        Assertions.assertEquals((Object)"/api/bookings", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"/", "/bookings", "{id}"});
        Assertions.assertEquals((Object)"/bookings/{id}", (Object)path);
    }

    @Test
    void testNoConfiguredProfile() {
        OpenApiConfig config = new OpenApiConfig(){};
        OperationImpl operation = new OperationImpl();
        operation.setExtensions(Collections.singletonMap("x-smallrye-profile-external", ""));
        boolean result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertTrue((boolean)result);
        Assertions.assertEquals((int)0, (int)operation.getExtensions().size());
    }

    @Test
    void testConfiguredIncludeProfile() {
        OpenApiConfig config = new OpenApiConfig(){

            public Set<String> getScanProfiles() {
                return Collections.singleton("external");
            }
        };
        OperationImpl operation = new OperationImpl();
        boolean result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertFalse((boolean)result);
        operation.setExtensions(Collections.singletonMap("x-smallrye-profile-external", ""));
        result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertTrue((boolean)result);
        Assertions.assertEquals((int)0, (int)operation.getExtensions().size());
    }

    @Test
    void testConfiguredExcludeProfile() {
        OpenApiConfig config = new OpenApiConfig(){

            public Set<String> getScanExcludeProfiles() {
                return Collections.singleton("external");
            }
        };
        OperationImpl operation = new OperationImpl();
        boolean result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertTrue((boolean)result);
        operation.setExtensions(Collections.singletonMap("x-smallrye-profile-external", ""));
        result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertFalse((boolean)result);
        Assertions.assertEquals((int)0, (int)operation.getExtensions().size());
    }

    @ParameterizedTest
    @CsvSource(value={"true,  p1, p1, PATH, true", "true,  p1, p1,     , false", "true,  p1, p2, PATH, false", "false, p1, p2,     , false", "true,  p1,   , PATH, false", "false, p1,   ,     , false", "     , p1, p1, PATH, false"})
    void testDefaultIsPathParameter(Boolean allowNaked, String searchParamName, String paramName, Parameter.In paramIn, boolean expectedResult) {
        OpenApiConfigImpl config = (OpenApiConfigImpl)IndexScannerTestBase.emptyConfig();
        config.setAllowNakedPathParameter(allowNaked);
        ResourceParameters params = new ResourceParameters();
        params.setOperationParameters(Arrays.asList(new ParameterImpl().name(paramName).in(paramIn)));
        DummyAnnotationScanner scanner = new DummyAnnotationScanner();
        AnnotationScannerContext context = new AnnotationScannerContext(null, Thread.currentThread().getContextClassLoader(), (OpenApiConfig)config);
        Assertions.assertEquals((Object)expectedResult, (Object)scanner.isPathParameter(context, searchParamName, params));
    }

    static final class DummyAnnotationScanner
    extends AbstractAnnotationScanner {
        DummyAnnotationScanner() {
        }

        public String getName() {
            return "Dummy";
        }

        public OpenAPI scan(AnnotationScannerContext annotationScannerContext, OpenAPI oai) {
            return oai;
        }

        public boolean isAsyncResponse(MethodInfo method) {
            return false;
        }

        public boolean isPostMethod(MethodInfo method) {
            return false;
        }

        public boolean isDeleteMethod(MethodInfo method) {
            return false;
        }

        public boolean containsScannerAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
            return false;
        }
    }
}

