/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import test.io.smallrye.openapi.runtime.scanner.dataobject.AbstractAnimal;
import test.io.smallrye.openapi.runtime.scanner.dataobject.Canine;
import test.io.smallrye.openapi.runtime.scanner.dataobject.Feline;
import test.io.smallrye.openapi.runtime.scanner.dataobject.JacksonPropertyOrderCustomName;
import test.io.smallrye.openapi.runtime.scanner.dataobject.JacksonPropertyOrderDefault;
import test.io.smallrye.openapi.runtime.scanner.dataobject.Lizard;
import test.io.smallrye.openapi.runtime.scanner.dataobject.NonJavaBeanAccessorProperty;
import test.io.smallrye.openapi.runtime.scanner.dataobject.NonJavaBeanMutatorProperty;
import test.io.smallrye.openapi.runtime.scanner.dataobject.OneSidedParent;
import test.io.smallrye.openapi.runtime.scanner.dataobject.OneSidedProperties;
import test.io.smallrye.openapi.runtime.scanner.dataobject.Reptile;
import test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.MySchema;
import test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.XmlAccessTypePropertyOnly;
import test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.XmlAccessTypePublicMember;
import test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.XmlTransientField;
import test.io.smallrye.openapi.runtime.scanner.dataobject.javax.Cat;
import test.io.smallrye.openapi.runtime.scanner.dataobject.javax.Dog;
import test.io.smallrye.openapi.runtime.scanner.dataobject.javax.JaxbCustomPropertyOrder;
import test.io.smallrye.openapi.runtime.scanner.dataobject.javax.XmlAccessTypeFieldOnly;
import test.io.smallrye.openapi.runtime.scanner.dataobject.javax.XmlTransientClass;

class TypeResolverTests
extends IndexScannerTestBase {
    TypeResolverTests() {
    }

    private Map<String, TypeResolver> getProperties(Class<?> leafClass, OpenApiConfig config, Class<?> ... indexClasses) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)TypeResolverTests.indexOf(indexClasses), loader, config);
        ClassInfo leafKlazz = context.getIndex().getClassByName(TypeResolverTests.componentize(leafClass.getName()));
        Type leaf = Type.create((DotName)leafKlazz.name(), (Type.Kind)Type.Kind.CLASS);
        return TypeResolver.getAllFields((AnnotationScannerContext)context, (Type)leaf, (ClassInfo)leafKlazz, null);
    }

    private Map<String, TypeResolver> getProperties(Class<?> leafClass, Class<?> ... indexClasses) {
        return this.getProperties(leafClass, TypeResolverTests.emptyConfig(), indexClasses);
    }

    @Test
    void testJavaxAnnotatedMethodOverridesParentSchema() {
        Map<String, TypeResolver> properties = this.getProperties(Cat.class, AbstractAnimal.class, Feline.class, Cat.class);
        this.testAnnotatedMethodOverridesParentSchema(properties);
    }

    @Test
    void testJakartaAnnotatedMethodOverridesParentSchema() {
        Map<String, TypeResolver> properties = this.getProperties(test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.Cat.class, AbstractAnimal.class, Feline.class, test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.Cat.class);
        this.testAnnotatedMethodOverridesParentSchema(properties);
    }

    void testAnnotatedMethodOverridesParentSchema(Map<String, TypeResolver> properties) {
        TypeResolver resolver = properties.get("type");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)resolver.getAnnotationTarget().kind());
        AnnotationInstance schema = TypeUtil.getSchemaAnnotation((AnnotationTarget)resolver.getAnnotationTarget());
        Assertions.assertEquals((Object)"type", (Object)schema.value("name").asString());
        Assertions.assertEquals((Object)false, (Object)schema.value("required").asBoolean());
        Assertions.assertEquals((Object)"Cat", (Object)schema.value("example").asString());
        Assertions.assertArrayEquals((Object[])new String[]{"age", "type", "name", "extinct"}, (Object[])properties.values().stream().map(TypeResolver::getPropertyName).toArray());
    }

    @Test
    void testJavaxAnnotatedFieldsOverridesInterfaceSchema() {
        Map<String, TypeResolver> properties = this.getProperties(Cat.class, AbstractAnimal.class, Feline.class, Cat.class);
        this.testAnnotatedFieldsOverridesInterfaceSchema(properties);
    }

    @Test
    void testJakartaAnnotatedFieldsOverridesInterfaceSchema() {
        Map<String, TypeResolver> properties = this.getProperties(test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.Cat.class, AbstractAnimal.class, Feline.class, test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.Cat.class);
        this.testAnnotatedFieldsOverridesInterfaceSchema(properties);
    }

    void testAnnotatedFieldsOverridesInterfaceSchema(Map<String, TypeResolver> properties) {
        TypeResolver resolver = properties.get("name");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.FIELD, (Object)resolver.getAnnotationTarget().kind());
        AnnotationInstance schema = TypeUtil.getSchemaAnnotation((AnnotationTarget)resolver.getAnnotationTarget());
        Assertions.assertEquals((Object)true, (Object)schema.value("required").asBoolean());
        Assertions.assertEquals((Object)"Felix", (Object)schema.value("example").asString());
    }

    @Test
    void testJavaxAnnotatedInterfaceMethodOverridesImplMethod() {
        Map<String, TypeResolver> properties = this.getProperties(Dog.class, AbstractAnimal.class, Canine.class, Dog.class);
        this.testAnnotatedInterfaceMethodOverridesImplMethod(properties);
    }

    @Test
    void testJakartaAnnotatedInterfaceMethodOverridesImplMethod() {
        Map<String, TypeResolver> properties = this.getProperties(test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.Dog.class, AbstractAnimal.class, Canine.class, test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.Dog.class);
        this.testAnnotatedInterfaceMethodOverridesImplMethod(properties);
    }

    void testAnnotatedInterfaceMethodOverridesImplMethod(Map<String, TypeResolver> properties) {
        Assertions.assertEquals((int)5, (int)properties.size());
        TypeResolver resolver = properties.get("name");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)resolver.getAnnotationTarget().kind());
        AnnotationInstance schema = TypeUtil.getSchemaAnnotation((AnnotationTarget)resolver.getAnnotationTarget());
        Assertions.assertEquals((Object)"c_name", (Object)schema.value("name").asString());
        Assertions.assertEquals((int)50, (int)schema.value("maxLength").asInt());
        Assertions.assertEquals((Object)"The name of the canine", (Object)schema.value("description").asString());
        Assertions.assertArrayEquals((Object[])new String[]{"age", "type", "c_name", "bark", "extinct"}, (Object[])properties.values().stream().map(TypeResolver::getPropertyName).toArray());
    }

    @Test
    void testAnnotatedInterfaceMethodOverridesStaticField() {
        Map<String, TypeResolver> properties = this.getProperties(Lizard.class, AbstractAnimal.class, Reptile.class, Lizard.class);
        TypeResolver resolver = properties.get("scaleColor");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)resolver.getAnnotationTarget().kind());
        AnnotationInstance schema = TypeUtil.getSchemaAnnotation((AnnotationTarget)resolver.getAnnotationTarget());
        Assertions.assertEquals((Object)"scaleColor", (Object)schema.value("name").asString());
        Assertions.assertNull((Object)schema.value("deprecated"));
        Assertions.assertEquals((Object)"The color of a reptile's scales", (Object)schema.value("description").asString());
        TypeResolver ageResolver = properties.get("age");
        Assertions.assertEquals((Object)Type.Kind.CLASS, (Object)ageResolver.getUnresolvedType().kind());
        Assertions.assertEquals((Object)DotName.createSimple((String)String.class.getName()), (Object)ageResolver.getUnresolvedType().name());
    }

    @Test
    void testJavaxBareInterface() {
        Map<String, TypeResolver> properties = this.getProperties(test.io.smallrye.openapi.runtime.scanner.dataobject.javax.MySchema.class, test.io.smallrye.openapi.runtime.scanner.dataobject.javax.MySchema.class);
        this.testBareInterface(properties);
    }

    @Test
    void testJakartaBareInterface() {
        Map<String, TypeResolver> properties = this.getProperties(MySchema.class, MySchema.class);
        this.testBareInterface(properties);
    }

    void testBareInterface(Map<String, TypeResolver> properties) {
        Assertions.assertEquals((int)3, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        Assertions.assertEquals((Object)"field1", (Object)iter.next().getKey());
        Assertions.assertEquals((Object)"field3", (Object)iter.next().getKey());
        Assertions.assertEquals((Object)"field2", (Object)iter.next().getKey());
        TypeResolver field1 = properties.get("field1");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)field1.getAnnotationTarget().kind());
        AnnotationInstance schema1 = TypeUtil.getSchemaAnnotation((AnnotationTarget)field1.getAnnotationTarget());
        Assertions.assertEquals((int)1, (int)schema1.values().size());
        Assertions.assertEquals((Object)true, (Object)schema1.value("required").asBoolean());
        TypeResolver field2 = properties.get("field2");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)field1.getAnnotationTarget().kind());
        AnnotationInstance schema2 = TypeUtil.getSchemaAnnotation((AnnotationTarget)field2.getAnnotationTarget());
        Assertions.assertEquals((int)1, (int)schema2.values().size());
        Assertions.assertEquals((Object)"anotherField", (Object)schema2.value("name").asString());
        TypeResolver field3 = properties.get("field3");
        Assertions.assertEquals((Object)AnnotationTarget.Kind.METHOD, (Object)field3.getAnnotationTarget().kind());
        AnnotationInstance schema3 = TypeUtil.getSchemaAnnotation((AnnotationTarget)field3.getAnnotationTarget());
        Assertions.assertNull((Object)schema3);
    }

    @Test
    void testJacksonPropertyOrderDefault() {
        Map<String, TypeResolver> properties = this.getProperties(JacksonPropertyOrderDefault.class, JacksonPropertyOrderDefault.class);
        Assertions.assertEquals((int)4, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        Assertions.assertEquals((Object)"comment", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"theName", (Object)iter.next().getValue().getPropertyName());
    }

    @Test
    void testJacksonPropertyOrderCustomName() {
        Map<String, TypeResolver> properties = this.getProperties(JacksonPropertyOrderCustomName.class, JacksonPropertyOrderCustomName.class);
        Assertions.assertEquals((int)4, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        Assertions.assertEquals((Object)"theName", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"comment2ActuallyFirst", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"comment", (Object)iter.next().getValue().getPropertyName());
    }

    @Test
    void testJavaxJaxbCustomPropertyOrder() {
        Map<String, TypeResolver> properties = this.getProperties(JaxbCustomPropertyOrder.class, JaxbCustomPropertyOrder.class);
        this.testJaxbCustomPropertyOrder(properties);
    }

    @Test
    void testJakartaJaxbCustomPropertyOrder() {
        Map<String, TypeResolver> properties = this.getProperties(test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.JaxbCustomPropertyOrder.class, test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.JaxbCustomPropertyOrder.class);
        this.testJaxbCustomPropertyOrder(properties);
    }

    void testJaxbCustomPropertyOrder(Map<String, TypeResolver> properties) {
        Assertions.assertEquals((int)4, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        Assertions.assertEquals((Object)"comment", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"name2", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"name", (Object)iter.next().getValue().getPropertyName());
        Assertions.assertEquals((Object)"comment2", (Object)iter.next().getValue().getPropertyName());
    }

    @Test
    void testNonJavaBeansPropertyAccessor() {
        Map<String, TypeResolver> properties = this.getProperties(NonJavaBeanAccessorProperty.class, NonJavaBeanAccessorProperty.class);
        Assertions.assertEquals((int)1, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"name", (Object)property.getPropertyName());
        Assertions.assertEquals((Object)property.getReadMethod(), (Object)property.getAnnotationTarget());
        Assertions.assertEquals((Object)"Name of the property", (Object)TypeUtil.getAnnotationValue((AnnotationTarget)property.getAnnotationTarget(), (DotName)SchemaConstant.DOTNAME_SCHEMA, (String)"title"));
    }

    @Test
    void testNonJavaBeansPropertyMutator() {
        Map<String, TypeResolver> properties = this.getProperties(NonJavaBeanMutatorProperty.class, NonJavaBeanMutatorProperty.class);
        Assertions.assertEquals((int)1, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"name", (Object)property.getPropertyName());
        Assertions.assertEquals((Object)property.getWriteMethod(), (Object)property.getAnnotationTarget());
        Assertions.assertEquals((Object)"Name of the property", (Object)TypeUtil.getAnnotationValue((AnnotationTarget)property.getAnnotationTarget(), (DotName)SchemaConstant.DOTNAME_SCHEMA, (String)"title"));
    }

    @Test
    void testOneSidedPropertiesHidden() {
        Map<String, TypeResolver> properties = this.getProperties(OneSidedProperties.class, OneSidedProperties.class, OneSidedParent.class);
        Assertions.assertEquals((int)5, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver parentProp1 = iter.next().getValue();
        Assertions.assertEquals((Object)"parentProp1", (Object)parentProp1.getPropertyName());
        Assertions.assertTrue((boolean)parentProp1.isIgnored());
        TypeResolver parentProp2 = iter.next().getValue();
        Assertions.assertEquals((Object)"parentProp2", (Object)parentProp2.getPropertyName());
        Assertions.assertTrue((boolean)parentProp2.isIgnored());
        TypeResolver prop1 = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1", (Object)prop1.getPropertyName());
        Assertions.assertFalse((boolean)prop1.isIgnored());
        TypeResolver prop2 = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2", (Object)prop2.getPropertyName());
        Assertions.assertFalse((boolean)prop2.isIgnored());
        TypeResolver prop3 = iter.next().getValue();
        Assertions.assertEquals((Object)"prop3", (Object)prop3.getPropertyName());
        Assertions.assertFalse((boolean)prop3.isIgnored());
    }

    @Test
    void testJavaxXmlAccessTransientField() {
        Map<String, TypeResolver> properties = this.getProperties(test.io.smallrye.openapi.runtime.scanner.dataobject.javax.XmlTransientField.class, test.io.smallrye.openapi.runtime.scanner.dataobject.javax.XmlTransientField.class);
        this.testXmlAccessTransientField(properties);
    }

    @Test
    void testJakartaXmlAccessTransientField() {
        Map<String, TypeResolver> properties = this.getProperties(XmlTransientField.class, XmlTransientField.class);
        this.testXmlAccessTransientField(properties);
    }

    void testXmlAccessTransientField(Map<String, TypeResolver> properties) {
        Assertions.assertEquals((int)2, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1Field", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2Field", (Object)property.getPropertyName());
        Assertions.assertFalse((boolean)property.isIgnored());
    }

    @Test
    void testJavaxXmlAccessTransientClass() {
        Map<String, TypeResolver> properties = this.getProperties(XmlTransientClass.class, XmlTransientClass.class);
        this.testXmlAccessTransientClass(properties);
    }

    @Test
    void testJakartaXmlAccessTransientClass() {
        Map<String, TypeResolver> properties = this.getProperties(test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.XmlTransientClass.class, test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.XmlTransientClass.class);
        this.testXmlAccessTransientClass(properties);
    }

    void testXmlAccessTransientClass(Map<String, TypeResolver> properties) {
        Assertions.assertEquals((int)3, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1Field", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2Field", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop3Property", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
    }

    @Test
    void testJavaxXmlAccessPublicMember() {
        Map<String, TypeResolver> properties = this.getProperties(test.io.smallrye.openapi.runtime.scanner.dataobject.javax.XmlAccessTypePublicMember.class, test.io.smallrye.openapi.runtime.scanner.dataobject.javax.XmlAccessTypePublicMember.class);
        this.testXmlAccessPublicMember(properties);
    }

    @Test
    void testJakartaXmlAccessPublicMember() {
        Map<String, TypeResolver> properties = this.getProperties(XmlAccessTypePublicMember.class, XmlAccessTypePublicMember.class);
        this.testXmlAccessPublicMember(properties);
    }

    void testXmlAccessPublicMember(Map<String, TypeResolver> properties) {
        Assertions.assertEquals((int)3, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1Field", (Object)property.getPropertyName());
        Assertions.assertFalse((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2Field", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop3Property", (Object)property.getPropertyName());
        Assertions.assertFalse((boolean)property.isIgnored());
    }

    @Test
    void testJavaxXmlAccessTypeFieldOnly() {
        Map<String, TypeResolver> properties = this.getProperties(XmlAccessTypeFieldOnly.class, XmlAccessTypeFieldOnly.class);
        this.testXmlAccessTypeFieldOnly(properties);
    }

    @Test
    void testJakartaXmlAccessTypeFieldOnly() {
        Map<String, TypeResolver> properties = this.getProperties(test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.XmlAccessTypeFieldOnly.class, test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.XmlAccessTypeFieldOnly.class);
        this.testXmlAccessTypeFieldOnly(properties);
    }

    void testXmlAccessTypeFieldOnly(Map<String, TypeResolver> properties) {
        Assertions.assertEquals((int)2, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1Field", (Object)property.getPropertyName());
        Assertions.assertFalse((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2Property", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
    }

    @Test
    void testJavaxXmlAccessTypePropertyOnly() {
        Map<String, TypeResolver> properties = this.getProperties(test.io.smallrye.openapi.runtime.scanner.dataobject.javax.XmlAccessTypePropertyOnly.class, test.io.smallrye.openapi.runtime.scanner.dataobject.javax.XmlAccessTypePropertyOnly.class);
        this.testXmlAccessTypePropertyOnly(properties);
    }

    @Test
    void testJakartaXmlAccessTypePropertyOnly() {
        Map<String, TypeResolver> properties = this.getProperties(XmlAccessTypePropertyOnly.class, XmlAccessTypePropertyOnly.class);
        this.testXmlAccessTypePropertyOnly(properties);
    }

    void testXmlAccessTypePropertyOnly(Map<String, TypeResolver> properties) {
        Assertions.assertEquals((int)2, (int)properties.size());
        Iterator<Map.Entry<String, TypeResolver>> iter = properties.entrySet().iterator();
        TypeResolver property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop2Field", (Object)property.getPropertyName());
        Assertions.assertTrue((boolean)property.isIgnored());
        property = iter.next().getValue();
        Assertions.assertEquals((Object)"prop1Property", (Object)property.getPropertyName());
        Assertions.assertFalse((boolean)property.isIgnored());
    }

    @Test
    void testPrivatePropertyHidden() {
        class Test {
            private String field1;
            public String field2;
            protected String field3;
            String field4;

            Test() {
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)4, (int)properties.size());
        Assertions.assertTrue((boolean)properties.get("field1").isIgnored());
        Assertions.assertFalse((boolean)properties.get("field2").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field3").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field4").isIgnored());
    }

    @Test
    void testPrivatePropertyExposedWithSchema() {
        class Test {
            @Schema(hidden=false)
            private String field1;
            public String field2;
            @Schema(hidden=false)
            protected String field3;
            @Schema(hidden=false)
            String field4;

            Test() {
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)4, (int)properties.size());
        Assertions.assertFalse((boolean)properties.get("field1").isIgnored());
        Assertions.assertFalse((boolean)properties.get("field2").isIgnored());
        Assertions.assertFalse((boolean)properties.get("field3").isIgnored());
        Assertions.assertFalse((boolean)properties.get("field4").isIgnored());
    }

    @Test
    void testPublicPropertyHiddenWithSchema() {
        class Test {
            private String field1;
            @Schema(hidden=true)
            public String field2;
            protected String field3;
            String field4;

            Test() {
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)4, (int)properties.size());
        Assertions.assertTrue((boolean)properties.get("field1").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field2").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field3").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field4").isIgnored());
    }

    @Test
    void testPrivatePropertyVisibleWithPublicGetter() {
        class Test {
            private String field1;
            public String field2;
            protected String field3;
            String field4;

            Test() {
            }

            public String getField1() {
                return this.field1;
            }

            public String getField3() {
                return this.field3;
            }

            public String getField4() {
                return this.field4;
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)4, (int)properties.size());
        Assertions.assertFalse((boolean)properties.get("field1").isIgnored());
        Assertions.assertFalse((boolean)properties.get("field2").isIgnored());
        Assertions.assertFalse((boolean)properties.get("field3").isIgnored());
        Assertions.assertFalse((boolean)properties.get("field4").isIgnored());
    }

    @Test
    void testPrivatePropertyHiddenWithPrivateGetter() {
        class Test {
            private String field1;
            private String field2;
            private String field3;
            private String field4;

            Test() {
            }

            public String getField1() {
                return this.field1;
            }

            private String getField2() {
                return this.field2;
            }

            protected String getField3() {
                return this.field3;
            }

            String getField4() {
                return this.field4;
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)4, (int)properties.size());
        Assertions.assertFalse((boolean)properties.get("field1").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field2").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field3").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field4").isIgnored());
    }

    @Test
    void testPrivatePropertyHiddenWithPrivateGetterAndMissingField() {
        class Test {
            private String field1;

            Test() {
            }

            public String getField1() {
                return this.field1;
            }

            private String getField2() {
                return "field2";
            }

            protected String getField3() {
                return "field3";
            }

            String getField4() {
                return "field4";
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.private-properties.enable", false), Test.class);
        Assertions.assertEquals((int)4, (int)properties.size());
        Assertions.assertFalse((boolean)properties.get("field1").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field2").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field3").isIgnored());
        Assertions.assertTrue((boolean)properties.get("field4").isIgnored());
    }

    @Test
    void testSingleCharacterPropertyName() {
        class Test {
            private boolean b;

            Test() {
            }

            public boolean isB() {
                return this.b;
            }

            public void setB(boolean b) {
                this.b = b;
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, TypeResolverTests.emptyConfig(), Test.class);
        Assertions.assertEquals((int)1, (int)properties.size());
        Assertions.assertEquals((Object)"b", (Object)properties.keySet().iterator().next());
    }

    @ParameterizedTest
    @CsvSource(value={"false, c, b, a", "true, a, b, c"})
    void testSortedPropertyNames(boolean unsortedEnabled, String first, String second, String third) {
        OpenApiConfig config = TypeResolverTests.dynamicConfig("mp.openapi.extensions.smallrye.sorted-properties.enable", unsortedEnabled);
        class Test {
            int c;
            int b;
            int a;

            Test() {
            }
        }
        Map<String, TypeResolver> properties = this.getProperties(Test.class, config, Test.class);
        Assertions.assertEquals((int)3, (int)properties.size());
        Iterator<String> keys = properties.keySet().iterator();
        Assertions.assertEquals((Object)first, (Object)keys.next());
        Assertions.assertEquals((Object)second, (Object)keys.next());
        Assertions.assertEquals((Object)third, (Object)keys.next());
    }
}

