/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Test;

class SchemaPropertyTest
extends IndexScannerTestBase {
    SchemaPropertyTest() {
    }

    @Test
    void testClassSchemaPropertyMergesWithFieldSchemas() throws Exception {
        Index index = SchemaPropertyTest.indexOf(Reptile.class, Lizard.class, Snake.class, Turtle.class, LengthUnits.class);
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(SchemaPropertyTest.emptyConfig(), (IndexView)index);
        OpenAPI result = scanner.scan(new String[0]);
        SchemaPropertyTest.printToConsole(result);
        SchemaPropertyTest.assertJsonEquals("components.schemas.schemaproperty-merge.json", result);
    }

    @Schema(allOf={Reptile.class, Turtle.class})
    static class Turtle
    extends Reptile {
        String shellPattern;

        Turtle() {
        }
    }

    @Schema(allOf={Reptile.class, Snake.class}, properties={@SchemaProperty(name="lengthUnits", defaultValue="CM")})
    static class Snake
    extends Reptile {
        int length;
        @Schema(description="The units of measure for length", defaultValue="MM")
        LengthUnits lengthUnits;

        Snake() {
        }
    }

    @Schema(allOf={Reptile.class, Lizard.class}, properties={@SchemaProperty(name="color", description="The color of the lizard")})
    static class Lizard
    extends Reptile {
        @Schema(defaultValue="GREEN", deprecated=false)
        String color;

        Lizard() {
        }
    }

    @Schema(name="LengthUnitsEnum")
    static enum LengthUnits {
        CM,
        MM,
        IN;

    }

    @Schema(discriminatorProperty="type", discriminatorMapping={@DiscriminatorMapping(value="lizard", schema=Lizard.class), @DiscriminatorMapping(value="snake", schema=Snake.class), @DiscriminatorMapping(value="turtle", schema=Turtle.class)})
    static abstract class Reptile {
        @Schema(required=true)
        private String type;

        Reptile() {
        }
    }
}

