/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiParser;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import org.apache.commons.io.IOUtils;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.json.JSONException;
import org.junit.jupiter.api.Test;
import org.skyscreamer.jsonassert.JSONAssert;

class MergeUtilTest {
    MergeUtilTest() {
    }

    private static String loadResource(URL testResource) throws IOException {
        return IOUtils.toString((URL)testResource, (String)"UTF-8");
    }

    private static void assertJsonEquals(String expected, String actual) throws JSONException {
        JSONAssert.assertEquals((String)expected, (String)actual, (boolean)true);
    }

    private static void doTest(String resource1, String resource2, String expected) throws IOException, ParseException, JSONException {
        URL resource1Url = MergeUtilTest.class.getResource(resource1);
        URL resource2Url = MergeUtilTest.class.getResource(resource2);
        URL expectedUrl = MergeUtilTest.class.getResource(expected);
        String expectedContent = MergeUtilTest.loadResource(expectedUrl);
        OpenAPI resource1Model = OpenApiParser.parse((URL)resource1Url);
        OpenAPI resource2Model = OpenApiParser.parse((URL)resource2Url);
        OpenAPI actualModel = MergeUtil.merge((OpenAPI)resource1Model, (OpenAPI)resource2Model);
        String actual = OpenApiSerializer.serialize((OpenAPI)actualModel, (Format)Format.JSON);
        MergeUtilTest.assertJsonEquals(expectedContent, actual);
    }

    @Test
    void testMerge_Info() throws IOException, ParseException, JSONException {
        MergeUtilTest.doTest("_info/info1.json", "_info/info2.json", "_info/merged.json");
    }

    @Test
    void testMerge_Extensions() throws IOException, ParseException, JSONException {
        MergeUtilTest.doTest("_extensions/extensions1.json", "_extensions/extensions2.json", "_extensions/merged.json");
    }

    @Test
    void testMerge_Tags() throws IOException, ParseException, JSONException {
        MergeUtilTest.doTest("_tags/tags1.json", "_tags/tags2.json", "_tags/merged.json");
    }

    @Test
    void testMerge_Servers() throws IOException, ParseException, JSONException {
        MergeUtilTest.doTest("_servers/servers1.json", "_servers/servers2.json", "_servers/merged.json");
    }

    @Test
    void testMerge_PathDocs() throws IOException, ParseException, JSONException {
        MergeUtilTest.doTest("_pathDocs/path1.json", "_pathDocs/path2.json", "_pathDocs/merged.json");
    }

    @Test
    void testMerge_PathDefault() throws IOException, ParseException, JSONException {
        MergeUtilTest.doTest("_pathDefault/pathDefault1.json", "_pathDefault/pathDefault2.json", "_pathDefault/merged.json");
    }

    @Test
    void testMerge_Callbacks() throws IOException, ParseException, JSONException {
        MergeUtilTest.doTest("_callbacks/callbacks1.json", "_callbacks/callbacks2.json", "_callbacks/merged.json");
    }

    @Test
    void testMerge_Security() throws IOException, ParseException, JSONException {
        MergeUtilTest.doTest("_security/security1.json", "_security/security2.json", "_security/merged.json");
    }

    @Test
    void testMerge_OperationTags() throws IOException, ParseException, JSONException {
        MergeUtilTest.doTest("_opTags/opTags1.json", "_opTags/opTags2.json", "_opTags/merged.json");
    }

    @Test
    void testMerge_EmptyQueryParam() throws IOException, ParseException, JSONException {
        MergeUtilTest.doTest("_pathEmpty/pathEmpty1.json", "_pathEmpty/pathEmpty2.json", "_pathEmpty/merged.json");
    }
}

