/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import test.io.smallrye.openapi.runtime.scanner.dataobject.jakarta.BVTestContainer;

class BeanValidationScannerTest
extends IndexScannerTestBase {
    BeanValidationScanner testTarget;
    Set<String> methodsInvoked = new LinkedHashSet<String>();
    Schema schema;
    ClassInfo javaxTargetClass;
    ClassInfo jakartaTargetClass;

    BeanValidationScannerTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.testTarget = BeanValidationScanner.INSTANCE;
        Index javaxIndex = BeanValidationScannerTest.indexOf(test.io.smallrye.openapi.runtime.scanner.dataobject.javax.BVTestContainer.class);
        Index jakartaIndex = BeanValidationScannerTest.indexOf(BVTestContainer.class);
        this.methodsInvoked.clear();
        this.schema = new SchemaImpl();
        this.javaxTargetClass = javaxIndex.getClassByName(BeanValidationScannerTest.componentize(test.io.smallrye.openapi.runtime.scanner.dataobject.javax.BVTestContainer.class.getName()));
        this.jakartaTargetClass = jakartaIndex.getClassByName(BeanValidationScannerTest.componentize(BVTestContainer.class.getName()));
    }

    Schema proxySchema(final Schema schema, final Set<String> methodsInvoked) {
        Schema schemaProxy = (Schema)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Schema.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                methodsInvoked.add(method.getName());
                return method.invoke((Object)schema, args);
            }
        });
        return schemaProxy;
    }

    BeanValidationScanner.RequirementHandler requirementHandler(Schema parentSchema) {
        return (target, name) -> {
            List requiredProperties = parentSchema.getRequired();
            if (requiredProperties == null || !requiredProperties.contains(name)) {
                parentSchema.addRequired(name);
            }
        };
    }

    BeanValidationScanner.RequirementHandler requirementHandlerFail() {
        return (target, name) -> Assertions.fail((String)"Unexpected call to handler");
    }

    @Test
    void testJavaxNullSchemaIgnored() {
        BeanValidationScanner.applyConstraints((AnnotationTarget)this.javaxTargetClass, (Schema)this.proxySchema(this.schema, this.methodsInvoked), null, null);
        Assertions.assertArrayEquals((Object[])new String[]{"getType"}, (Object[])this.methodsInvoked.toArray(), (String)"Unexpected methods were invoked");
    }

    @Test
    void testJakartaNullSchemaIgnored() {
        BeanValidationScanner.applyConstraints((AnnotationTarget)this.jakartaTargetClass, (Schema)this.proxySchema(this.schema, this.methodsInvoked), null, null);
        Assertions.assertArrayEquals((Object[])new String[]{"getType"}, (Object[])this.methodsInvoked.toArray(), (String)"Unexpected methods were invoked");
    }

    @Test
    void testJavaxRefSchemaIgnored() {
        this.schema.setType(Schema.SchemaType.OBJECT);
        this.schema.setRef("#/components/schemas/Anything");
        BeanValidationScanner.applyConstraints((AnnotationTarget)this.javaxTargetClass, (Schema)this.proxySchema(this.schema, this.methodsInvoked), null, null);
        Assertions.assertArrayEquals((Object[])new String[]{"getType", "getRef"}, (Object[])this.methodsInvoked.toArray(), (String)"Unexpected methods were invoked");
    }

    @Test
    void testJakartaRefSchemaIgnored() {
        this.schema.setType(Schema.SchemaType.OBJECT);
        this.schema.setRef("#/components/schemas/Anything");
        BeanValidationScanner.applyConstraints((AnnotationTarget)this.jakartaTargetClass, (Schema)this.proxySchema(this.schema, this.methodsInvoked), null, null);
        Assertions.assertArrayEquals((Object[])new String[]{"getType", "getRef"}, (Object[])this.methodsInvoked.toArray(), (String)"Unexpected methods were invoked");
    }

    @Test
    void testJavaxArrayListNotNullAndNotEmptyAndMaxItems() {
        FieldInfo targetField = this.javaxTargetClass.field("arrayListNotNullAndNotEmptyAndMaxItems");
        this.testArrayListNotNullAndNotEmptyAndMaxItems(targetField);
    }

    @Test
    void testJakartaArrayListNotNullAndNotEmptyAndMaxItems() {
        FieldInfo targetField = this.jakartaTargetClass.field("arrayListNotNullAndNotEmptyAndMaxItems");
        this.testArrayListNotNullAndNotEmptyAndMaxItems(targetField);
    }

    void testArrayListNotNullAndNotEmptyAndMaxItems(FieldInfo targetField) {
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = targetField.name();
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandler((Schema)parentSchema));
        this.testTarget.sizeArray((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyArray((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandler((Schema)parentSchema));
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertEquals((Integer)1, (Integer)this.schema.getMinItems());
        Assertions.assertEquals((Integer)20, (Integer)this.schema.getMaxItems());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testJavaxArrayListNullableAndMinItemsAndMaxItems() {
        FieldInfo targetField = this.javaxTargetClass.field("arrayListNullableAndMinItemsAndMaxItems");
        this.testArrayListNullableAndMinItemsAndMaxItems(targetField);
    }

    @Test
    void testJakartaArrayListNullableAndMinItemsAndMaxItems() {
        FieldInfo targetField = this.jakartaTargetClass.field("arrayListNullableAndMinItemsAndMaxItems");
        this.testArrayListNullableAndMinItemsAndMaxItems(targetField);
    }

    void testArrayListNullableAndMinItemsAndMaxItems(FieldInfo targetField) {
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = targetField.name();
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandlerFail());
        this.testTarget.sizeArray((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyArray((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandler((Schema)parentSchema));
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertEquals((Integer)5, (Integer)this.schema.getMinItems());
        Assertions.assertEquals((Integer)20, (Integer)this.schema.getMaxItems());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testJavaxMapObjectNotNullAndNotEmptyAndMaxProperties() {
        FieldInfo targetField = this.javaxTargetClass.field("mapObjectNotNullAndNotEmptyAndMaxProperties");
        this.testMapObjectNotNullAndNotEmptyAndMaxProperties(targetField);
    }

    @Test
    void testJakartaMapObjectNotNullAndNotEmptyAndMaxProperties() {
        FieldInfo targetField = this.jakartaTargetClass.field("mapObjectNotNullAndNotEmptyAndMaxProperties");
        this.testMapObjectNotNullAndNotEmptyAndMaxProperties(targetField);
    }

    void testMapObjectNotNullAndNotEmptyAndMaxProperties(FieldInfo targetField) {
        this.schema.setAdditionalPropertiesBoolean(Boolean.TRUE);
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = targetField.name();
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandler((Schema)parentSchema));
        this.testTarget.sizeObject((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyObject((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandler((Schema)parentSchema));
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertEquals((Integer)1, (Integer)this.schema.getMinProperties());
        Assertions.assertEquals((Integer)20, (Integer)this.schema.getMaxProperties());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testJavaxMapObjectNullableAndMinPropertiesAndMaxProperties() {
        FieldInfo targetField = this.javaxTargetClass.field("mapObjectNullableAndMinPropertiesAndMaxProperties");
        this.testMapObjectNullableAndMinPropertiesAndMaxProperties(targetField);
    }

    @Test
    void testJakartaMapObjectNullableAndMinPropertiesAndMaxProperties() {
        FieldInfo targetField = this.jakartaTargetClass.field("mapObjectNullableAndMinPropertiesAndMaxProperties");
        this.testMapObjectNullableAndMinPropertiesAndMaxProperties(targetField);
    }

    void testMapObjectNullableAndMinPropertiesAndMaxProperties(FieldInfo targetField) {
        this.schema.setAdditionalPropertiesBoolean(Boolean.TRUE);
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = targetField.name();
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandlerFail());
        this.testTarget.sizeObject((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyObject((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandler((Schema)parentSchema));
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertEquals((Integer)5, (Integer)this.schema.getMinProperties());
        Assertions.assertEquals((Integer)20, (Integer)this.schema.getMaxProperties());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testJavaxMapObjectNullableNoAdditionalProperties() {
        FieldInfo targetField = this.javaxTargetClass.field("mapObjectNullableAndMinPropertiesAndMaxProperties");
        this.testMapObjectNullableNoAdditionalProperties(targetField);
    }

    @Test
    void testJakartaMapObjectNullableNoAdditionalProperties() {
        FieldInfo targetField = this.jakartaTargetClass.field("mapObjectNullableAndMinPropertiesAndMaxProperties");
        this.testMapObjectNullableNoAdditionalProperties(targetField);
    }

    void testMapObjectNullableNoAdditionalProperties(FieldInfo targetField) {
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = targetField.name();
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandlerFail());
        this.testTarget.sizeObject((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyObject((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandlerFail());
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertEquals(null, (Integer)this.schema.getMinProperties());
        Assertions.assertEquals(null, (Integer)this.schema.getMaxProperties());
        Assertions.assertNull((Object)parentSchema.getRequired());
    }

    @Test
    void testJavaxDecimalMaxPrimaryDigits() {
        FieldInfo targetField = this.javaxTargetClass.field("decimalMaxBigDecimalPrimaryDigits");
        this.testDecimalMaxPrimaryDigits(targetField);
    }

    @Test
    void testJakartaDecimalMaxPrimaryDigits() {
        FieldInfo targetField = this.jakartaTargetClass.field("decimalMaxBigDecimalPrimaryDigits");
        this.testDecimalMaxPrimaryDigits(targetField);
    }

    void testDecimalMaxPrimaryDigits(FieldInfo targetField) {
        this.testTarget.decimalMax((AnnotationTarget)targetField, this.schema);
        this.testTarget.digits((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("200.00"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)"^\\d{1,3}([.]\\d{1,2})?$", (Object)this.schema.getPattern());
    }

    @Test
    void testJavaxDecimalMaxNoConstraint() {
        this.testTarget.decimalMax((AnnotationTarget)this.javaxTargetClass.field("decimalMaxBigDecimalNoConstraint"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testJakartaDecimalMaxNoConstraint() {
        this.testTarget.decimalMax((AnnotationTarget)this.jakartaTargetClass.field("decimalMaxBigDecimalNoConstraint"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testJavaxDecimalMaxInvalidValue() {
        this.testTarget.decimalMax((AnnotationTarget)this.javaxTargetClass.field("decimalMaxBigDecimalInvalidValue"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testJakartaDecimalMaxInvalidValue() {
        this.testTarget.decimalMax((AnnotationTarget)this.jakartaTargetClass.field("decimalMaxBigDecimalInvalidValue"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testJavaxDecimalMaxExclusiveDigits() {
        FieldInfo targetField = this.javaxTargetClass.field("decimalMaxBigDecimalExclusiveDigits");
        this.testDecimalMaxExclusiveDigits(targetField);
    }

    @Test
    void testJakartaDecimalMaxExclusiveDigits() {
        FieldInfo targetField = this.jakartaTargetClass.field("decimalMaxBigDecimalExclusiveDigits");
        this.testDecimalMaxExclusiveDigits(targetField);
    }

    void testDecimalMaxExclusiveDigits(FieldInfo targetField) {
        this.testTarget.decimalMax((AnnotationTarget)targetField, this.schema);
        this.testTarget.digits((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("201.0"), (Object)this.schema.getMaximum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)"^\\d{1,3}([.]\\d)?$", (Object)this.schema.getPattern());
    }

    @Test
    void testJavaxDecimalMaxInclusive() {
        this.testTarget.decimalMax((AnnotationTarget)this.javaxTargetClass.field("decimalMaxBigDecimalInclusive"), this.schema);
        Assertions.assertEquals((Object)new BigDecimal("201.00"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testJakartaDecimalMaxInclusive() {
        this.testTarget.decimalMax((AnnotationTarget)this.jakartaTargetClass.field("decimalMaxBigDecimalInclusive"), this.schema);
        Assertions.assertEquals((Object)new BigDecimal("201.00"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testJavaxDecimalMinPrimary() {
        this.testTarget.decimalMin((AnnotationTarget)this.javaxTargetClass.field("decimalMinBigDecimalPrimary"), this.schema);
        Assertions.assertEquals((Object)new BigDecimal("10.0"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJakartaDecimalMinPrimary() {
        this.testTarget.decimalMin((AnnotationTarget)this.jakartaTargetClass.field("decimalMinBigDecimalPrimary"), this.schema);
        Assertions.assertEquals((Object)new BigDecimal("10.0"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJavaxDecimalMinNoConstraint() {
        this.testTarget.decimalMin((AnnotationTarget)this.javaxTargetClass.field("decimalMinBigDecimalNoConstraint"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJakartaDecimalMinNoConstraint() {
        this.testTarget.decimalMin((AnnotationTarget)this.jakartaTargetClass.field("decimalMinBigDecimalNoConstraint"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJavaxDecimalMinInvalidValue() {
        this.testTarget.decimalMin((AnnotationTarget)this.javaxTargetClass.field("decimalMinBigDecimalInvalidValue"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJakartaDecimalMinInvalidValue() {
        this.testTarget.decimalMin((AnnotationTarget)this.jakartaTargetClass.field("decimalMinBigDecimalInvalidValue"), this.schema);
        Assertions.assertEquals(null, (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJavaxDecimalMinExclusiveDigits() {
        FieldInfo targetField = this.javaxTargetClass.field("decimalMinBigDecimalExclusiveDigits");
        this.testDecimalMinExclusiveDigits(targetField);
    }

    @Test
    void testJakartaDecimalMinExclusiveDigits() {
        FieldInfo targetField = this.jakartaTargetClass.field("decimalMinBigDecimalExclusiveDigits");
        this.testDecimalMinExclusiveDigits(targetField);
    }

    void testDecimalMinExclusiveDigits(FieldInfo targetField) {
        this.testTarget.decimalMin((AnnotationTarget)targetField, this.schema);
        this.testTarget.digits((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("9.00"), (Object)this.schema.getMinimum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMinimum());
        Assertions.assertEquals((Object)"^\\d([.]\\d{1,2})?$", (Object)this.schema.getPattern());
    }

    @Test
    void testJavaxDecimalMinInclusive() {
        this.testTarget.decimalMin((AnnotationTarget)this.javaxTargetClass.field("decimalMinBigDecimalInclusive"), this.schema);
        Assertions.assertEquals((Object)new BigDecimal("9.00"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJakartaDecimalMinInclusive() {
        this.testTarget.decimalMin((AnnotationTarget)this.jakartaTargetClass.field("decimalMinBigDecimalInclusive"), this.schema);
        Assertions.assertEquals((Object)new BigDecimal("9.00"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJavaxIntegerPositiveNotZeroMaxValue() {
        FieldInfo targetField = this.javaxTargetClass.field("integerPositiveNotZeroMaxValue");
        this.testIntegerPositiveNotZeroMaxValue(targetField);
    }

    @Test
    void testJakartaIntegerPositiveNotZeroMaxValue() {
        FieldInfo targetField = this.jakartaTargetClass.field("integerPositiveNotZeroMaxValue");
        this.testIntegerPositiveNotZeroMaxValue(targetField);
    }

    void testIntegerPositiveNotZeroMaxValue(FieldInfo targetField) {
        this.testTarget.max((AnnotationTarget)targetField, this.schema);
        this.testTarget.positive((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("1"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
        Assertions.assertEquals((Object)new BigDecimal("1000"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testJavaxIntegerPositiveNotZeroMaxValueExclusive() {
        FieldInfo targetField = this.javaxTargetClass.field("integerPositiveNotZeroMaxValue");
        this.testIntegerPositiveNotZeroMaxValueExclusive(targetField);
    }

    @Test
    void testJakartaIntegerPositiveNotZeroMaxValueExclusive() {
        FieldInfo targetField = this.jakartaTargetClass.field("integerPositiveNotZeroMaxValue");
        this.testIntegerPositiveNotZeroMaxValueExclusive(targetField);
    }

    void testIntegerPositiveNotZeroMaxValueExclusive(FieldInfo targetField) {
        this.schema.setExclusiveMaximum(Boolean.TRUE);
        this.schema.setExclusiveMinimum(Boolean.TRUE);
        this.testTarget.max((AnnotationTarget)targetField, this.schema);
        this.testTarget.positive((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)this.schema.getMinimum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMinimum());
        Assertions.assertEquals((Object)new BigDecimal("1000"), (Object)this.schema.getMaximum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testJavaxIntegerPositiveOrZeroMaxValue() {
        FieldInfo targetField = this.javaxTargetClass.field("integerPositiveOrZeroMaxValue");
        this.testIntegerPositiveOrZeroMaxValue(targetField);
    }

    @Test
    void testJakartaIntegerPositiveOrZeroMaxValue() {
        FieldInfo targetField = this.jakartaTargetClass.field("integerPositiveOrZeroMaxValue");
        this.testIntegerPositiveOrZeroMaxValue(targetField);
    }

    void testIntegerPositiveOrZeroMaxValue(FieldInfo targetField) {
        this.testTarget.max((AnnotationTarget)targetField, this.schema);
        this.testTarget.positiveOrZero((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
        Assertions.assertEquals((Object)new BigDecimal("999"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testJavaxIntegerPositiveOrZeroMaxValueExclusive() {
        FieldInfo targetField = this.javaxTargetClass.field("integerPositiveOrZeroMaxValue");
        this.testIntegerPositiveOrZeroMaxValueExclusive(targetField);
    }

    @Test
    void testJakartaIntegerPositiveOrZeroMaxValueExclusive() {
        FieldInfo targetField = this.jakartaTargetClass.field("integerPositiveOrZeroMaxValue");
        this.testIntegerPositiveOrZeroMaxValueExclusive(targetField);
    }

    void testIntegerPositiveOrZeroMaxValueExclusive(FieldInfo targetField) {
        this.schema.setExclusiveMaximum(Boolean.TRUE);
        this.schema.setExclusiveMinimum(Boolean.TRUE);
        this.testTarget.max((AnnotationTarget)targetField, this.schema);
        this.testTarget.positiveOrZero((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("-1"), (Object)this.schema.getMinimum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMinimum());
        Assertions.assertEquals((Object)new BigDecimal("999"), (Object)this.schema.getMaximum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMaximum());
    }

    @Test
    void testJavaxIntegerNegativeNotZeroMinValue() {
        FieldInfo targetField = this.javaxTargetClass.field("integerNegativeNotZeroMinValue");
        this.testIntegerNegativeNotZeroMinValue(targetField);
    }

    @Test
    void testJakartaIntegerNegativeNotZeroMinValue() {
        FieldInfo targetField = this.jakartaTargetClass.field("integerNegativeNotZeroMinValue");
        this.testIntegerNegativeNotZeroMinValue(targetField);
    }

    void testIntegerNegativeNotZeroMinValue(FieldInfo targetField) {
        this.testTarget.min((AnnotationTarget)targetField, this.schema);
        this.testTarget.negative((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("-1"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)new BigDecimal("-1000000"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJavaxIntegerNegativeNotZeroMinValueExclusive() {
        FieldInfo targetField = this.javaxTargetClass.field("integerNegativeNotZeroMinValue");
        this.testIntegerNegativeNotZeroMinValueExclusive(targetField);
    }

    @Test
    void testJakartaIntegerNegativeNotZeroMinValueExclusive() {
        FieldInfo targetField = this.jakartaTargetClass.field("integerNegativeNotZeroMinValue");
        this.testIntegerNegativeNotZeroMinValueExclusive(targetField);
    }

    void testIntegerNegativeNotZeroMinValueExclusive(FieldInfo targetField) {
        this.schema.setExclusiveMaximum(Boolean.TRUE);
        this.schema.setExclusiveMinimum(Boolean.TRUE);
        this.testTarget.min((AnnotationTarget)targetField, this.schema);
        this.testTarget.negative((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)this.schema.getMaximum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)new BigDecimal("-1000000"), (Object)this.schema.getMinimum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJavaxIntegerNegativeOrZeroMinValue() {
        FieldInfo targetField = this.javaxTargetClass.field("integerNegativeOrZeroMinValue");
        this.testIntegerNegativeOrZeroMinValue(targetField);
    }

    @Test
    void testJakartaIntegerNegativeOrZeroMinValue() {
        FieldInfo targetField = this.jakartaTargetClass.field("integerNegativeOrZeroMinValue");
        this.testIntegerNegativeOrZeroMinValue(targetField);
    }

    void testIntegerNegativeOrZeroMinValue(FieldInfo targetField) {
        this.testTarget.min((AnnotationTarget)targetField, this.schema);
        this.testTarget.negativeOrZero((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("0"), (Object)this.schema.getMaximum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)new BigDecimal("-999"), (Object)this.schema.getMinimum());
        Assertions.assertEquals(null, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJavaxIntegerNegativeOrZeroMinValueExclusive() {
        FieldInfo targetField = this.javaxTargetClass.field("integerNegativeOrZeroMinValue");
        this.testIntegerNegativeOrZeroMinValueExclusive(targetField);
    }

    @Test
    void testJakartaIntegerNegativeOrZeroMinValueExclusive() {
        FieldInfo targetField = this.jakartaTargetClass.field("integerNegativeOrZeroMinValue");
        this.testIntegerNegativeOrZeroMinValueExclusive(targetField);
    }

    void testIntegerNegativeOrZeroMinValueExclusive(FieldInfo targetField) {
        this.schema.setExclusiveMaximum(Boolean.TRUE);
        this.schema.setExclusiveMinimum(Boolean.TRUE);
        this.testTarget.min((AnnotationTarget)targetField, this.schema);
        this.testTarget.negativeOrZero((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)new BigDecimal("1"), (Object)this.schema.getMaximum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMaximum());
        Assertions.assertEquals((Object)new BigDecimal("-999"), (Object)this.schema.getMinimum());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)this.schema.getExclusiveMinimum());
    }

    @Test
    void testJavaxStringNotBlankNotNull() {
        FieldInfo targetField = this.javaxTargetClass.field("stringNotBlankNotNull");
        this.testStringNotBlankNotNull(targetField);
    }

    @Test
    void testJakartaStringNotBlankNotNull() {
        FieldInfo targetField = this.jakartaTargetClass.field("stringNotBlankNotNull");
        this.testStringNotBlankNotNull(targetField);
    }

    void testStringNotBlankNotNull(FieldInfo targetField) {
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = targetField.name();
        this.testTarget.notBlank((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandler((Schema)parentSchema));
        this.testTarget.notNull((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandler((Schema)parentSchema));
        Assertions.assertEquals((Object)"\\S", (Object)this.schema.getPattern());
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testJavaxStringNotBlankDigits() {
        FieldInfo targetField = this.javaxTargetClass.field("stringNotBlankDigits");
        this.testStringNotBlankDigits(targetField);
    }

    @Test
    void testJakartaStringNotBlankDigits() {
        FieldInfo targetField = this.jakartaTargetClass.field("stringNotBlankDigits");
        this.testStringNotBlankDigits(targetField);
    }

    void testStringNotBlankDigits(FieldInfo targetField) {
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = targetField.name();
        this.testTarget.digits((AnnotationTarget)targetField, this.schema);
        this.testTarget.notBlank((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandler((Schema)parentSchema));
        Assertions.assertEquals((Object)"^\\d{1,8}([.]\\d{1,10})?$", (Object)this.schema.getPattern());
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testJavaxStringNotEmptyMaxSize() {
        FieldInfo targetField = this.javaxTargetClass.field("stringNotEmptyMaxSize");
        this.testStringNotEmptyMaxSize(targetField);
    }

    @Test
    void testJakartaStringNotEmptyMaxSize() {
        FieldInfo targetField = this.jakartaTargetClass.field("stringNotEmptyMaxSize");
        this.testStringNotEmptyMaxSize(targetField);
    }

    void testStringNotEmptyMaxSize(FieldInfo targetField) {
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = targetField.name();
        this.testTarget.sizeString((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyString((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandler((Schema)parentSchema));
        Assertions.assertEquals((Integer)1, (Integer)this.schema.getMinLength());
        Assertions.assertEquals((Integer)2000, (Integer)this.schema.getMaxLength());
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testJavaxStringNotEmptySizeRange() {
        FieldInfo targetField = this.javaxTargetClass.field("stringNotEmptySizeRange");
        this.testStringNotEmptySizeRange(targetField);
    }

    @Test
    void testJakartaStringNotEmptySizeRange() {
        FieldInfo targetField = this.jakartaTargetClass.field("stringNotEmptySizeRange");
        this.testStringNotEmptySizeRange(targetField);
    }

    void testStringNotEmptySizeRange(FieldInfo targetField) {
        SchemaImpl parentSchema = new SchemaImpl();
        String propertyKey = targetField.name();
        this.testTarget.sizeString((AnnotationTarget)targetField, this.schema);
        this.testTarget.notEmptyString((AnnotationTarget)targetField, this.schema, propertyKey, this.requirementHandler((Schema)parentSchema));
        Assertions.assertEquals((Integer)100, (Integer)this.schema.getMinLength());
        Assertions.assertEquals((Integer)2000, (Integer)this.schema.getMaxLength());
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testJavaxJacksonRequiredString() {
        String propertyKey = "jacksonRequiredTrueString";
        FieldInfo targetField = this.javaxTargetClass.field(propertyKey);
        this.testJacksonRequiredString(targetField, propertyKey);
    }

    @Test
    void testJakartaJacksonRequiredString() {
        String propertyKey = "jacksonRequiredTrueString";
        FieldInfo targetField = this.jakartaTargetClass.field(propertyKey);
        this.testJacksonRequiredString(targetField, propertyKey);
    }

    void testJacksonRequiredString(FieldInfo targetField, String propertyKey) {
        SchemaImpl parentSchema = new SchemaImpl();
        this.testTarget.requiredJackson((AnnotationTarget)targetField, propertyKey, (arg_0, arg_1) -> BeanValidationScannerTest.lambda$testJacksonRequiredString$2((Schema)parentSchema, arg_0, arg_1));
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertEquals(Arrays.asList(propertyKey), (Object)parentSchema.getRequired());
    }

    @Test
    void testJavaxJacksonDefaultString() {
        String propertyKey = "jacksonDefaultString";
        FieldInfo targetField = this.javaxTargetClass.field(propertyKey);
        this.testJacksonDefaultString(targetField);
    }

    @Test
    void testJakartaJacksonDefaultString() {
        String propertyKey = "jacksonDefaultString";
        FieldInfo targetField = this.jakartaTargetClass.field(propertyKey);
        this.testJacksonDefaultString(targetField);
    }

    void testJacksonDefaultString(FieldInfo targetField) {
        String propertyKey = "jacksonDefaultString";
        SchemaImpl parentSchema = new SchemaImpl();
        this.testTarget.requiredJackson((AnnotationTarget)targetField, propertyKey, (arg_0, arg_1) -> BeanValidationScannerTest.lambda$testJacksonDefaultString$3((Schema)parentSchema, arg_0, arg_1));
        Assertions.assertNull((Object)this.schema.getNullable());
        Assertions.assertNull((Object)parentSchema.getRequired());
    }

    @Test
    void testJavaxPatternFields() {
        this.testPatternFields(this.javaxTargetClass.field("patternFromBV"), "^something$");
    }

    @Test
    void testJakartaPatternFields() {
        this.testPatternFields(this.jakartaTargetClass.field("patternFromBV"), "^something$");
    }

    void testPatternFields(FieldInfo targetField, String expectedPattern) {
        this.testTarget.pattern((AnnotationTarget)targetField, this.schema);
        Assertions.assertEquals((Object)expectedPattern, (Object)this.schema.getPattern());
    }

    private static /* synthetic */ void lambda$testJacksonDefaultString$3(Schema parentSchema, AnnotationTarget target, String name) {
        parentSchema.addRequired(name);
    }

    private static /* synthetic */ void lambda$testJacksonRequiredString$2(Schema parentSchema, AnnotationTarget target, String name) {
        parentSchema.addRequired(name);
    }
}

