/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class LogCapture
implements BeforeEachCallback,
AfterEachCallback {
    private String loggerName;
    private Logger logger;
    private TestHandler handler;
    private Level oldLevel;

    public LogCapture(String loggerName) {
        this.loggerName = loggerName;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.logger = Logger.getLogger(this.loggerName);
        this.handler = new TestHandler();
        this.logger.addHandler(this.handler);
        this.oldLevel = this.logger.getLevel();
        this.logger.setLevel(Level.ALL);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.handler != null) {
            this.logger.removeHandler(this.handler);
        }
        if (this.logger != null) {
            this.logger.setLevel(this.oldLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogRecord> getAll() {
        List list = this.handler.records;
        synchronized (list) {
            return new ArrayList<LogRecord>(this.handler.records);
        }
    }

    public LogRecord assertLogContaining(String substring) {
        List list = this.handler.records;
        synchronized (list) {
            for (LogRecord r : this.handler.records) {
                if (!r.getMessage().contains(substring)) continue;
                return r;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Log containing \"").append(substring).append("\" was not found.");
            sb.append("\n");
            sb.append("Log records recorded:\n");
            if (this.handler.records.isEmpty()) {
                sb.append("<no records>\n");
            }
            for (LogRecord r : this.handler.records) {
                sb.append("[").append(r.getLevel()).append("] ");
                sb.append(r.getMessage()).append("\n");
            }
            throw new AssertionError((Object)sb.toString());
        }
    }

    private static class TestHandler
    extends Handler {
        private List<LogRecord> records = Collections.synchronizedList(new ArrayList());

        private TestHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            this.records.add(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

