/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import java.util.Collections;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AbstractAnnotationScannerTest {
    AbstractAnnotationScannerTest() {
    }

    @Test
    void testMakePath() {
        String path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"", "", ""});
        Assertions.assertEquals((Object)"/", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"/", "/"});
        Assertions.assertEquals((Object)"/", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"", "/bookings"});
        Assertions.assertEquals((Object)"/bookings", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"/api", "/bookings"});
        Assertions.assertEquals((Object)"/api/bookings", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"api", "bookings"});
        Assertions.assertEquals((Object)"/api/bookings", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"/", "/bookings", "{id}"});
        Assertions.assertEquals((Object)"/bookings/{id}", (Object)path);
    }

    @Test
    void testNoConfiguredProfile() {
        OpenApiConfig config = new OpenApiConfig(){};
        OperationImpl operation = new OperationImpl();
        operation.setExtensions(Collections.singletonMap("x-smallrye-profile-external", ""));
        boolean result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertTrue((boolean)result);
        Assertions.assertEquals((int)0, (int)operation.getExtensions().size());
    }

    @Test
    void testConfiguredIncludeProfile() {
        OpenApiConfig config = new OpenApiConfig(){

            public Set<String> getScanProfiles() {
                return Collections.singleton("external");
            }
        };
        OperationImpl operation = new OperationImpl();
        boolean result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertFalse((boolean)result);
        operation.setExtensions(Collections.singletonMap("x-smallrye-profile-external", ""));
        result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertTrue((boolean)result);
        Assertions.assertEquals((int)0, (int)operation.getExtensions().size());
    }

    @Test
    void testConfiguredExcludeProfile() {
        OpenApiConfig config = new OpenApiConfig(){

            public Set<String> getScanExcludeProfiles() {
                return Collections.singleton("external");
            }
        };
        OperationImpl operation = new OperationImpl();
        boolean result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertTrue((boolean)result);
        operation.setExtensions(Collections.singletonMap("x-smallrye-profile-external", ""));
        result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertFalse((boolean)result);
        Assertions.assertEquals((int)0, (int)operation.getExtensions().size());
    }
}

