/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.constants.OpenApiConstants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface OpenApiConfig {
    default public String modelReader() {
        return null;
    }

    default public String filter() {
        return null;
    }

    default public boolean scanDisable() {
        return false;
    }

    default public Pattern scanPackages() {
        return null;
    }

    default public Pattern scanClasses() {
        return null;
    }

    default public Pattern scanExcludePackages() {
        return Pattern.compile("(" + OpenApiConstants.NEVER_SCAN_PACKAGES.stream().map(Pattern::quote).collect(Collectors.joining("|")) + ")");
    }

    default public Pattern scanExcludeClasses() {
        return Pattern.compile("(" + OpenApiConstants.NEVER_SCAN_CLASSES.stream().map(Pattern::quote).collect(Collectors.joining("|")) + ")");
    }

    default public Set<String> servers() {
        return new HashSet<String>();
    }

    default public Set<String> pathServers(String path) {
        return new HashSet<String>();
    }

    default public Set<String> operationServers(String operationId) {
        return new HashSet<String>();
    }

    default public boolean scanDependenciesDisable() {
        return false;
    }

    default public Set<String> scanDependenciesJars() {
        return new HashSet<String>();
    }

    default public boolean arrayReferencesEnable() {
        return true;
    }

    default public String customSchemaRegistryClass() {
        return null;
    }

    default public boolean applicationPathDisable() {
        return false;
    }

    default public boolean privatePropertiesEnable() {
        return true;
    }

    default public String propertyNamingStrategy() {
        return "IDENTITY";
    }

    default public boolean sortedPropertiesEnable() {
        return false;
    }

    default public Map<String, String> getSchemas() {
        return new HashMap<String, String>();
    }

    default public String getOpenApiVersion() {
        return null;
    }

    default public String getInfoTitle() {
        return null;
    }

    default public String getInfoVersion() {
        return null;
    }

    default public String getInfoDescription() {
        return null;
    }

    default public String getInfoTermsOfService() {
        return null;
    }

    default public String getInfoContactEmail() {
        return null;
    }

    default public String getInfoContactName() {
        return null;
    }

    default public String getInfoContactUrl() {
        return null;
    }

    default public String getInfoLicenseName() {
        return null;
    }

    default public String getInfoLicenseUrl() {
        return null;
    }

    default public OperationIdStrategy getOperationIdStrategy() {
        return null;
    }

    default public Optional<String[]> getDefaultProduces() {
        return Optional.empty();
    }

    default public Optional<String[]> getDefaultConsumes() {
        return Optional.empty();
    }

    default public Pattern patternOf(String configValue) {
        return this.patternOf(configValue, null);
    }

    default public Pattern patternOf(String configValue, Set<String> buildIn) {
        Pattern pattern = null;
        if (configValue != null && (configValue.startsWith("^") || configValue.endsWith("$"))) {
            pattern = Pattern.compile(configValue);
        } else {
            Set<String> literals = this.asCsvSet(configValue);
            if (buildIn != null && !buildIn.isEmpty()) {
                literals.addAll(buildIn);
            }
            if (literals.isEmpty()) {
                return Pattern.compile("", 16);
            }
            pattern = Pattern.compile("(" + literals.stream().map(Pattern::quote).collect(Collectors.joining("|")) + ")");
        }
        return pattern;
    }

    default public Set<String> asCsvSet(String items) {
        HashSet<String> rval = new HashSet<String>();
        if (items != null) {
            String[] split;
            for (String item : split = items.split(",")) {
                rval.add(item.trim());
            }
        }
        return rval;
    }

    public static enum OperationIdStrategy {
        METHOD,
        CLASS_METHOD,
        PACKAGE_CLASS_METHOD;

    }
}

